/*
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2020 The International Cooperation for the Integration of Processes in Prepress, Press and Postpress (CIP4). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the
 * distribution.
 *
 * 3. The end-user documentation included with the redistribution, if any, must include the following acknowledgment: "This product includes software developed by the The International Cooperation for
 * the Integration of Processes in Prepress, Press and Postpress (www.cip4.org)" Alternately, this acknowledgment may appear in the software itself, if and wherever such third-party acknowledgments
 * normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of Processes in Prepress, Press and Postpress" must not be used to endorse or promote products derived from this software
 * without prior written permission. For written permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4", nor may "CIP4" appear in their name, without prior written permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE. ====================================================================
 *
 * This software consists of voluntary contributions made by many individuals on behalf of the The International Cooperation for the Integration of Processes in Prepress, Press and Postpress and was
 * originally based on software copyright (c) 1999-2001, Heidelberger Druckmaschinen AG copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the Integration of Processes in Prepress, Press and Postpress , please see <http://www.cip4.org/>.
 *
 *
 */
/**
 *
 * Copyright (c) 2001 Heidelberger Druckmaschinen AG, All Rights Reserved.
 *
 * AttributeName.java
 *
 * Last changes
 *
 */
package org.cip4.jdflib.core;

/**
 * constants for AttributeName
 */
public final class AttributeName
{
	private AttributeName()
	{
	}

	/** */
	public static final String ABORTED = "Aborted";
	/** */
	public static final String ABORTJOBWHENSCREENMATCHINGFAILS = "AbortJobWhenScreenMatchingFails";
	/** */
	public static final String ABSOLUTEBOX = "AbsoluteBox";
	/** */
	public static final String ABSOLUTEHEIGHT = "AbsoluteHeight";
	/** */
	public static final String ABSOLUTEWIDTH = "AbsoluteWidth";
	/** */
	public static final String ACCEPTED = "Accepted";
	/** */
	public static final String ACKNOWLEDGE = "Acknowledge";
	/** */
	public static final String ACKNOWLEDGED = "Acknowledged";
	/** */
	public static final String ACKNOWLEDGEFORMAT = "AcknowledgeFormat";
	/** */
	public static final String ACKNOWLEDGETEMPLATE = "AcknowledgeTemplate";
	/** */
	public static final String ACKNOWLEDGETYPE = "AcknowledgeType";
	/** */
	public static final String ACKNOWLEDGEURL = "AcknowledgeURL";
	/** */
	public static final String ACTION = "Action";
	/** */
	public static final String ACTIONPOOLS = "ActionPools";
	/** */
	public static final String ACTIONREF = "ActionRef";
	/** */
	public static final String ACTIONREFS = "ActionRefs";
	/** */
	public static final String ACTIVATION = "Activation";
	/** */
	public static final String ACTIVITYID = "ActivityID";
	/** */
	public static final String ACTIVITYNAME = "ActivityName";
	/** */
	public static final String ACTUAL = "Actual";
	/** */
	public static final String ACTUALAMOUNT = "ActualAmount";
	/** */
	public static final String ACTUALCOLORNAME = "ActualColorName";
	/** */
	public static final String ACTUALTOTALAMOUNT = "ActualTotalAmount";
	/** */
	public static final String ADDITIONALAMOUNT = "AdditionalAmount";
	/** */
	public static final String ADDITIONALNAMES = "AdditionalNames";
	/** */
	public static final String ADDITIONALPRICE = "AdditionalPrice";
	/** */
	public static final String ADHESIVETYPE = "AdhesiveType";
	/** */
	public static final String ADJUSTCONTRAST = "AdjustContrast";
	/** */
	public static final String ADJUSTCYANRED = "AdjustCyanRed";
	/** */
	public static final String ADJUSTHUE = "AdjustHue";
	/** */
	public static final String ADJUSTLIGHTNESS = "AdjustLightness";
	/** */
	public static final String ADJUSTMAGENTAGREEN = "AdjustMagentaGreen";
	/** */
	public static final String ADJUSTSATURATION = "AdjustSaturation";
	/** */
	public static final String ADJUSTYELLOWBLUE = "AdjustYellowBlue";
	/** */
	public static final String ADVANCEDISTANCE = "AdvanceDistance";
	/** */
	public static final String AFTER = "After";
	/** */
	public static final String AGENTNAME = "AgentName";
	/** */
	public static final String AGENTVERSION = "AgentVersion";
	/** */
	public static final String AIMCURVE = "AimCurve";
	/** */
	public static final String ALIAS = "Alias";
	/** */
	public static final String ALIASSEPARATIONS = "AliasSeparations";
	/** */
	public static final String ALIGNMENTREFERENCEWEB = "AlignmentReferenceWeb";
	/** */
	public static final String ALLOWEDHWRELATION = "AllowedHWRelation";
	/** */
	public static final String ALLOWEDLENGTH = "AllowedLength";
	/** */
	public static final String ALLOWEDREGEXP = "AllowedRegExp";
	/** */
	public static final String ALLOWEDROTATE = "AllowedRotate";
	/** */
	public static final String ALLOWEDROTATEMOD = "AllowedRotateMod";
	/** */
	public static final String ALLOWEDSHIFT = "AllowedShift";
	/** */
	public static final String ALLOWEDTRANSFORMS = "AllowedTransforms";
	/** */
	public static final String ALLOWEDVALUE = "AllowedValue";
	/** */
	public static final String ALLOWEDVALUEDURATIONLIST = "AllowedValueDurationList";
	/** */
	public static final String ALLOWEDVALUELIST = "AllowedValueList";
	/** */
	public static final String ALLOWEDVALUEMAX = "AllowedValueMax";
	/** */
	public static final String ALLOWEDVALUEMIN = "AllowedValueMin";
	/** */
	public static final String ALLOWEDVALUEMOD = "AllowedValueMod";
	/** */
	public static final String ALLOWEDX = "AllowedX";
	/** */
	public static final String ALLOWEDXYRELATION = "AllowedXYRelation";
	/** */
	public static final String ALLOWEDY = "AllowedY";
	/** */
	public static final String ALLOWEDZ = "AllowedZ";
	/** */
	public static final String ALLOWPSXOBJECTS = "AllowPSXObjects";
	/** */
	public static final String ALLOWTRANSPARENCY = "AllowTransparency";
	/** */
	public static final String ALPHAISSHAPE = "AlphaIsShape";
	/** */
	public static final String ALTERNATEBRAND = "AlternateBrand";
	/** */
	public static final String ALTERNATECOLORSPACE = "AlternateColorSpace";
	/** */
	public static final String ALTERNATEIMAGES = "AlternateImages";
	/** */
	public static final String ALTERNATEPOSITIONS = "AlternatePositions";
	/** */
	public static final String ALWAYSEMBED = "AlwaysEmbed";
	/** */
	public static final String AMBIGUOUSSEPARATIONS = "AmbiguousSeparations";
	/** */
	public static final String AMOUNT = "Amount";
	/** */
	public static final String AMOUNTPRODUCED = "AmountProduced";
	/** */
	public static final String AMOUNTREQUIRED = "AmountRequired";
	/** */
	public static final String ANCHOR = "Anchor";
	/** */
	public static final String ANCHORTYPE = "AnchorType";
	/** */
	public static final String ANGLE = "Angle";
	/** */
	public static final String ANGLEMAP = "AngleMap";
	/** */
	public static final String ANNOTATIONPRINTFLAG = "AnnotationPrintFlag";
	/** */
	public static final String ANNOTATIONTYPE = "AnnotationType";
	/** */
	public static final String ANTIALIASIMAGES = "AntiAliasImages";
	public static final String ANTIALIASING = "AntiAliasing";
	/** */
	public static final String APERTURE = "Aperture";
	public static final String APPLICATION = "Application";
	public static final String APPLICATIONAREA = "ApplicationArea";
	public static final String APPOS = "AppOS";

	public static final String APPROVALROLE = "ApprovalRole";
	public static final String APPROVALROLEDETAILS = "ApprovalRoleDetails";
	public static final String APPROVALSTATE = "ApprovalState";
	public static final String APPROVALSTATEDETAILS = "ApprovalStateDetails";
	public static final String APPVERSION = "AppVersion";
	/** */
	public static final String AREA = "Area";
	/** */
	public static final String AREAGLUE = "AreaGlue";
	/** */
	public static final String ARTDELIVERYTYPE = "ArtDeliveryType";
	/** */
	public static final String ASCII85ENCODEPAGES = "ASCII85EncodePages";
	/** */
	public static final String ASPECTRATIO = "AspectRatio";
	/** */
	public static final String ASSEMBLYID = "AssemblyID";
	/** */
	public static final String ASSEMBLYIDS = "AssemblyIDs";
	/** */
	public static final String ASSETTYPES = "AssetTypes";
	/** */
	public static final String ATTEMPTFIXUPERRORS = "AttemptFixupErrors";
	/** */
	public static final String ATTEMPTFIXUPWARNINGS = "AttemptFixupWarnings";
	/** */
	public static final String ATTRIBUTE = "Attribute";
	/** */
	public static final String ATTRIBUTENAME = "AttributeName";
	/** */
	public static final String ATTRIBUTES = "Attributes";
	/** */
	public static final String ATTRIBUTESNATURALLANG = "AttributesNaturalLang";
	/** */
	public static final String AUTHENTICATIONTYPE = "AuthenticationType";
	/** */
	public static final String AUTHOR = "Author";
	/** */
	public static final String AUTHORIZATION = "Authorization";
	/** */
	public static final String AUTHORIZATIONEXPIRES = "AuthorizationExpires";
	/** */
	public static final String AUTOFILTERIMAGES = "AutoFilterImages";
	/** */
	public static final String AUTOMATED = "Automated";
	/** */
	public static final String AUTOMATION = "Automation";
	/** */
	public static final String AUTOPOSITIONEPSINFO = "AutoPositionEPSInfo";
	/** */
	public static final String AUTOROTATEPAGES = "AutoRotatePages";
	/** */
	public static final String AVAILABILITY = "Availability";
	/** */
	public static final String AVAILABLEAMOUNT = "AvailableAmount";
	/** */
	public static final String AVERAGEAMOUNT = "AverageAmount";
	/** */
	public static final String AVERAGECLEANUP = "AverageCleanup";
	/** */
	public static final String AVERAGESETUP = "AverageSetup";

	/** */
	public static final String BACKBRIGHTNESS = "BackBrightness";
	/** */
	public static final String BACKCOATINGDETAIL = "BackCoatingDetail";
	/** */
	public static final String BACKCOATINGS = "BackCoatings";
	/** */
	public static final String BACKFACEPAGES = "BackFacePages";
	/** */
	public static final String BACKGLOSSVALUE = "BackGlossValue";
	/** */
	public static final String BACKING = "Backing";
	public static final String BACKISOPAPERSUBSTRATE = "BackISOPaperSubstrate";
	/** */
	public static final String BACKMARKLIST = "BackMarkList";
	/** */
	public static final String BACKOVERFOLD = "BackOverfold";
	/** */
	public static final String BACKPAGES = "BackPages";
	/** */
	public static final String BACKSIDE = "BackSide";
	/** */
	public static final String BACKSPREAD = "BackSpread";
	/** */
	public static final String BADFEEDQUALITY = "BadFeedQuality";
	/** */
	public static final String BADFEEDS = "BadFeeds";
	/** */
	public static final String BANDHEIGHT = "BandHeight";
	/** */
	public static final String BANDORDERING = "BandOrdering";
	/** */
	public static final String BANDWIDTH = "BandWidth";
	/** */
	public static final String BARCODEVERSION = "BarcodeVersion";
	/** */
	public static final String BASEORDRESET = "BaseOrdReset";
	/** */
	public static final String BATCHID = "BatchID";
	/** */
	public static final String BEARERBARS = "BearerBars";
	/** */
	public static final String BEFORE = "Before";
	/** */
	public static final String BELONGSTOANNOTATION = "BelongsToAnnotation";
	/** */
	public static final String BEND = "Bend";
	/** */
	public static final String BESTEFFORTEXCEPTIONS = "BestEffortExceptions";
	/** */
	public static final String BILLINGCODE = "BillingCode";
	/** */
	public static final String BILLINGTYPE = "BillingType";
	/** */
	public static final String BILLINGTYPEDETAILS = "BillingTypeDetails";
	/** */
	public static final String BINARYOK = "BinaryOK";
	/** */
	public static final String BINARYVALUE = "BinaryValue";
	/** */
	public static final String BINDERCOLOR = "BinderColor";
	/** */
	public static final String BINDERCOLORDETAILS = "BinderColorDetails";
	/** */
	public static final String BINDERMATERIAL = "BinderMaterial";
	/** */
	public static final String BINDERNAME = "BinderName";
	/** */
	public static final String BINDERYSIGNATURENAME = "BinderySignatureName";
	/** */
	public static final String BINDERYSIGNATUREPAGINATIONINDEX = "BinderySignaturePaginationIndex";
	/** */
	public static final String BINDERYSIGNATURETYPE = "BinderySignatureType";
	/** */
	public static final String BINDING = "Binding";
	/** */
	public static final String BINDINGEDGE = "BindingEdge";
	/** */
	public static final String BINDINGORDER = "BindingOrder";
	/** */
	public static final String BINDINGORIENTATION = "BindingOrientation";
	/** */
	public static final String BINDINGSIDE = "BindingSide";
	/** */
	public static final String BITDEPTH = "BitDepth";
	/** */
	public static final String BITSPERSAMPLE = "BitsPerSample";
	/** */
	public static final String BLACKCOLORLIMIT = "BlackColorLimit";
	/** */
	public static final String BLACKDENSITYLIMIT = "BlackDensityLimit";
	/** */
	public static final String BLACKGENERATION = "BlackGeneration";
	/** */
	public static final String BLACKWIDTH = "BlackWidth";
	/** */
	public static final String BLANKDIMENSIONSX = "BlankDimensionsX";
	/** */
	public static final String BLANKDIMENSIONSY = "BlankDimensionsY";
	/** */
	public static final String BLANKPAGE = "BlankPage";
	/** */
	public static final String BLEEDFACE = "BleedFace";
	/** */
	public static final String BLEEDFOOT = "BleedFoot";
	/** */
	public static final String BLEEDHEAD = "BleedHead";
	/** */
	public static final String BLEEDSPINE = "BleedSpine";
	/** */
	public static final String BLEEDBOTTOM = "BleedBottom";
	/** */
	public static final String BLEEDLEFT = "BleedLeft";
	/** */
	public static final String BLEEDRIGHT = "BleedRight";
	/** */
	public static final String BLEEDTOP = "BleedTop";
	/** */
	public static final String BLENDCOLORSPACE = "BlendColorSpace";
	/** */
	public static final String BLENDMODE = "BlendMode";
	/** */
	public static final String BLINDSTITCH = "BlindStitch";
	/** */
	public static final String BLOCKELEMENTSIZE = "BlockElementSize";
	/** */
	public static final String BLOCKELEMENTTYPE = "BlockElementType";
	/** */
	public static final String BLOCKNAME = "BlockName";
	/** */
	public static final String BLOCKS = "Blocks";
	/** */
	public static final String BLOCKSIZE = "BlockSize";
	/** */
	public static final String BLOCKSUBDIVISION = "BlockSubdivision";
	/** */
	public static final String BLOCKTRF = "BlockTrf";
	/** */
	public static final String BLOCKTYPE = "BlockType";
	/** */
	public static final String BORDER = "Border";
	/** */
	public static final String BOTTLEANGLE = "BottleAngle";
	/** */
	public static final String BOTTLEAXIS = "BottleAxis";
	/** */
	public static final String BOTTOMBRAND = "BottomBrand";
	/** */
	public static final String BOTTOMCOLOR = "BottomColor";
	/** */
	public static final String BOTTOMCOLORDETAILS = "BottomColorDetails";
	/** */
	public static final String BOTTOMFOLDIN = "BottomFoldIn";
	/** */
	public static final String BOTTOMLENGTH = "BottomLength";
	/** */
	public static final String BOUNDINGBOX = "BoundingBox";
	/** */
	public static final String BOX = "Box";
	/** */
	public static final String BOXEDQUANTITY = "BoxedQuantity";
	/** */
	public static final String BOXFOLDINGTYPE = "BoxFoldingType";
	/** */
	public static final String BOXSHAPE = "BoxShape";
	/** */
	public static final String BRAND = "Brand";
	/** */
	public static final String BRIGHTNESS = "Brightness";
	/** */
	public static final String BROADSHEETNUMBER = "BroadsheetNumber";
	/** */
	public static final String BUNDLEDEPTH = "BundleDepth";
	/** */
	public static final String BUNDLEITEMINDEX = "BundleItemIndex";
	/** */
	public static final String BUNDLETYPE = "BundleType";
	/** */
	public static final String BURNOUTAREA = "BurnOutArea";
	/** */
	public static final String BUSINESSID = "BusinessID";
	/** */
	public static final String BUSINESSREFID = "BusinessRefID";
	/** */
	public static final String BUSY = "Busy";
	/** */
	public static final String BUYERACCOUNT = "BuyerAccount";
	/** */
	public static final String BYTEORDER = "ByteOrder";

	/** */
	public static final String CANNOTEMBEDFONTPOLICY = "CannotEmbedFontPolicy";
	/** */
	public static final String CAPACITY = "Capacity";
	/** */
	public static final String CARTONMAXWEIGHT = "CartonMaxWeight";
	/** */
	public static final String CARTONQUANTITY = "CartonQuantity";
	/** */
	public static final String CARTONSHAPE = "CartonShape";
	/** */
	public static final String CARTONSTRENGTH = "CartonStrength";
	/** */
	public static final String CARTONTOPFLAPS = "CartonTopFlaps";
	/** */
	public static final String CASERADIUS = "CaseRadius";
	/** */
	public static final String CASTINGMATERIAL = "CastingMaterial";
	/** */
	public static final String CATALOGDETAILS = "CatalogDetails";
	/** */
	public static final String CATALOGID = "CatalogID";
	/** */
	public static final String CATEGORY = "Category";
	/** */
	public static final String CELLINDEX = "CellIndex";
	/** */
	public static final String CENTER = "Center";
	/** */
	public static final String CENTERACROSS = "CenterAcross";
	/** */
	public static final String CENTERCROPBOX = "CenterCropBox";
	/** */
	public static final String CENTERREFERENCE = "CenterReference";
	/** */
	public static final String CHANNELID = "ChannelID";
	/** */
	public static final String CHANNELMODE = "ChannelMode";
	/** */
	public static final String CHANNELTYPE = "ChannelType";
	/** */
	public static final String CHANNELTYPEDETAILS = "ChannelTypeDetails";
	/** */
	public static final String CHANNELUSAGE = "ChannelUsage";
	/** */
	public static final String CHARACTERPROBLEM = "CharacterProblem";
	/** */
	public static final String CHECKSUM = "CheckSum";
	/** */
	public static final String CHILDFOLIO = "ChildFolio";
	/** */
	public static final String CIELAB = "CIELab";
	/** */
	public static final String CIETINT = "CIETint";
	/** */
	public static final String CIEWHITENESS = "CIEWhiteness";
	/** */
	public static final String CITY = "City";
	/** */
	public static final String CLAIM = "Claim";
	public static final String CLAMPCOLOR = "ClampColor";
	public static final String CLAMPCOLORDETAILS = "ClampColorDetails";
	public static final String CLAMPD = "ClampD";
	public static final String CLAMPSIZE = "ClampSize";
	public static final String CLAMPSYSTEM = "ClampSystem";
	/** */
	public static final String CLASS = "Class";
	/** */
	public static final String CLASSES = "Classes";
	/** */
	public static final String CLASSNAME = "ClassName";
	/** */
	public static final String CLEANUPDURATION = "CleanupDuration";
	/** */
	public static final String CLIPBOX = "ClipBox";
	/** */
	public static final String CLIPBOXFORMAT = "ClipBoxFormat";
	/** */
	public static final String CLIPBOXTEMPLATE = "ClipBoxTemplate";
	/** */
	public static final String CLIPOFFSET = "ClipOffset";
	/** */
	public static final String CLIPPATH = "ClipPath";
	/** */
	public static final String CMYK = "CMYK";
	/** */
	public static final String CODE = "Code";
	/** */
	public static final String CODEBLOCKSIZE = "CodeBlockSize";
	/** */
	public static final String COLLAPSEBLEEDS = "CollapseBleeds";
	/** */
	public static final String COLLATE = "Collate";
	/** */
	public static final String COLOR = "Color";
	/** */
	public static final String COLORANT = "Colorant";
	/** */
	public static final String COLORANTDEPTH = "ColorantDepth";
	/** */
	public static final String COLORANTNAME = "ColorantName";
	/** */
	public static final String COLORANTSETNAME = "ColorantSetName";
	/** */
	public static final String COLORBOOK = "ColorBook";
	/** */
	public static final String COLORBOOKENTRY = "ColorBookEntry";
	/** */
	public static final String COLORBOOKPREFIX = "ColorBookPrefix";
	/** */
	public static final String COLORBOOKSUFFIX = "ColorBookSuffix";
	/** */
	public static final String COLORDETAILS = "ColorDetails";
	/** */
	public static final String COLORLIST = "ColorList";
	/** */
	public static final String COLORMANAGEMENTSYSTEM = "ColorManagementSystem";
	/** */
	public static final String COLORNAME = "ColorName";
	/** */
	public static final String COLORSPACE = "ColorSpace";
	/** */
	public static final String COLORTRANSFORM = "ColorTransform";
	/** */
	public static final String COLORTYPE = "ColorType";
	/** */
	public static final String COLORTYPEDETAILS = "ColorTypeDetails";
	/** */
	public static final String COLUMNS = "Columns";
	/** */
	public static final String COMBINEDMETHOD = "CombinedMethod";
	/** */
	public static final String COMBINEDPROCESSINDEX = "CombinedProcessIndex";
	/** */
	public static final String COMBINEDPROCESSTYPE = "CombinedProcessType";
	/** */
	public static final String COMBINEDPROCESSUSAGE = "CombinedProcessUsage";
	/** */
	public static final String COMMAND = "Command";
	/** */
	public static final String COMMANDRESULT = "CommandResult";
	/** */
	public static final String COMMENTID = "CommentID";
	public static final String COMMENTURL = "CommentURL";
	public static final String COMMONFOLDS = "CommonFolds";
	/** */
	public static final String COMPANY = "Company";
	/** */
	public static final String COMPENSATE = "Compensate";
	/** */
	public static final String COMPENSATION = "Compensation";
	/** */
	public static final String COMPENSATIONCTMFORMAT = "CompensationCTMFormat";
	/** */
	public static final String COMPENSATIONCTMTEMPLATE = "CompensationCTMTemplate";
	/** */
	public static final String COMPENSATIONPROCESS = "CompensationProcess";
	/** */
	public static final String COMPENSATIONVALUE = "CompensationValue";
	/** */
	public static final String COMPLETED = "Completed";
	/** */
	public static final String COMPONENTGRANULARITY = "ComponentGranularity";
	/** */
	public static final String COMPONENTORIENTATION = "ComponentOrientation";
	/** */
	public static final String COMPONENTSPERROW = "ComponentsPerRow";
	/** */
	public static final String COMPONENTTYPE = "ComponentType";
	/** */
	public static final String COMPRESSION = "Compression";
	/** */
	public static final String COMPRESSIONALGORITHM = "CompressionAlgorithm";
	/** */
	public static final String COMPRESSIONFILTER = "CompressionFilter";
	/** */
	public static final String COMPRESSIONRATIO = "CompressionRatio";
	/** */
	public static final String COMPRESSIONTYPES = "CompressionTypes";
	/** */
	public static final String COMPRESSPAGES = "CompressPages";
	/** */
	public static final String CONDITION = "Condition";
	/** */
	public static final String CONSTRAINT = "Constraint";
	/** */
	public static final String CONSUMABLETYPE = "ConsumableType";
	/** */
	public static final String CONSUMPTION = "Consumption";
	/** */
	public static final String CONTACT = "Contact";
	/** */
	public static final String CONTACTSCREEN = "ContactScreen";
	/** */
	public static final String CONTACTTYPEDETAILS = "ContactTypeDetails";
	/** */
	public static final String CONTACTTYPES = "ContactTypes";
	/** */
	public static final String CONTENTDATAREFS = "ContentDataRefs";
	/** */
	public static final String CONTENTLISTINDEX = "ContentListIndex";
	/** */
	public static final String CONTENTREF = "ContentRef";
	/** */
	public static final String CONTENTREFS = "ContentRefs";
	/** */
	public static final String CONTENTSMODIFIED = "ContentsModified";
	/** */
	public static final String CONTENTTYPE = "ContentType";
	/** */
	public static final String CONTEXT = "Context";
	/** */
	public static final String CONTRACT = "Contract";
	/** */
	public static final String CONTROLLERID = "ControllerID";
	/** */
	public static final String CONVERTDEVINDEPCOLORS = "ConvertDevIndepColors";
	/** */
	public static final String CONVERTIMAGESTOINDEXED = "ConvertImagesToIndexed";
	/** */
	public static final String COPIES = "Copies";
	/** */
	public static final String COREMATERIAL = "CoreMaterial";
	/** */
	public static final String COREWEIGHT = "CoreWeight";
	/** */
	public static final String CORNERTYPE = "CornerType";
	/** */
	public static final String COSTCENTERID = "CostCenterID";
	/** */
	public static final String COSTTYPE = "CostType";
	/** */
	public static final String COSTTYPEDETAILS = "CostTypeDetails";
	/** */
	public static final String COUNT = "Count";
	/** */
	public static final String COUNTERID = "CounterID";
	/** */
	public static final String COUNTERTYPES = "CounterTypes";
	/** */
	public static final String COUNTERUNIT = "CounterUnit";
	/** */
	public static final String COUNTRY = "Country";
	/** */
	public static final String COUNTRYCODE = "CountryCode";
	/** */
	public static final String COVERBOARDWIDTH = "CoverBoardWidth";
	/** */
	public static final String COVEROFFSET = "CoverOffset";
	/** */
	public static final String COVERTYPE = "CoverType";
	/** */
	public static final String COVERWIDTH = "CoverWidth";
	/** */
	public static final String CREATIONDATE = "CreationDate";
	/** */
	public static final String CREATIONDATEINDOCUMENT = "CreationDateInDocument";
	/** */
	public static final String CREATIONID = "CreationID";
	/** */
	public static final String CREATOR = "Creator";
	/** */
	public static final String CREEP = "Creep";
	/** */
	public static final String CREEPVALUE = "CreepValue";
	/** */
	public static final String CTM = "CTM";
	/**
	 * @deprecated
	 */
	@Deprecated
	public static final String CUMULATIVEAMOUNT = "CumulativeAmount"; // TODO remove , not in C++
	/** */
	public static final String CURRENCY = "Currency";
	/** */
	public static final String CURRENTVALUE = "CurrentValue";
	/** */
	public static final String CURVE = "Curve";
	/** */
	public static final String CUSTOMERID = "CustomerID";
	/** */
	public static final String CUSTOMERJOBNAME = "CustomerJobName";
	/** */
	public static final String CUSTOMERORDERID = "CustomerOrderID";
	/** */
	public static final String CUSTOMERPROJECTID = "CustomerProjectID";
	/** */
	public static final String CUTBOX = "CutBox";
	/** */
	public static final String CUTMEDIA = "CutMedia";
	/** */
	public static final String CUTOUT = "CutOut";
	/** */
	public static final String CUTPATH = "CutPath";
	/** */
	public static final String CUTTYPE = "CutType";
	/** */
	public static final String CUTWIDTH = "CutWidth";
	/** */
	public static final String CUTWIDTHFOOT = "CutWidthFoot";
	/** */
	public static final String CUTWIDTHHEAD = "CutWidthHead";
	/** */
	public static final String CYCLE = "Cycle";

	/** */
	public static final String DATA = "Data";
	/** */
	public static final String DATABASE = "DataBase";
	/** */
	public static final String DATATYPE = "DataType";
	/** */
	public static final String DBSCHEMATYPE = "DBSchemaType";
	/** */
	public static final String DCTQUALITY = "DCTQuality";
	/** */
	public static final String DDESCUTTYPE = "DDESCutType";
	/** */
	public static final String DEADLINE = "DeadLine";
	/** */
	public static final String DEFAULTID = "DefaultID";
	public static final String DEFAULTJDF = "DefaultJDF";
	public static final String DEFAULTPRIORITY = "DefaultPriority";
	public static final String DEFAULTRENDERINGINTENT = "DefaultRenderingIntent";
	public static final String DEFAULTTRAPPING = "DefaultTrapping";
	public static final String DEFAULTVALUE = "DefaultValue";

	public static final String DEFECTREASON = "DefectReason";
	public static final String DEFECTTYPE = "DefectType";
	public static final String DEFECTTYPEDETAILS = "DefectTypeDetails";

	public static final String DELIVERYMODE = "DeliveryMode";
	public static final String DELIVERYUNIT = "DeliveryUnit";
	public static final String DELIVERYUNIT0 = "DeliveryUnit0";
	public static final String DELIVERYUNIT1 = "DeliveryUnit1";
	public static final String DELIVERYUNIT2 = "DeliveryUnit2";
	public static final String DELIVERYUNIT3 = "DeliveryUnit3";
	public static final String DELIVERYUNIT4 = "DeliveryUnit4";
	public static final String DELIVERYUNIT5 = "DeliveryUnit5";
	public static final String DELIVERYUNIT6 = "DeliveryUnit6";
	public static final String DELIVERYUNIT7 = "DeliveryUnit7";
	public static final String DELIVERYUNIT8 = "DeliveryUnit8";
	public static final String DELIVERYUNIT9 = "DeliveryUnit9";

	public static final String DENSITY = "Density";
	/** */
	public static final String DENSITYSTANDARD = "DensityStandard";
	/** */
	public static final String DEPENDENTMACROREF = "DependentMacroRef";
	/** */
	public static final String DEPTH = "Depth";
	/** */
	public static final String DESCRIPTIONTYPE = "DescriptionType";
	/** */
	public static final String DESCRIPTIVENAME = "DescriptiveName";
	/** */
	public static final String DETAIL = "Detail";
	/** */
	public static final String DETECTBLEND = "DetectBlend";
	/** */
	public static final String DEVCAPREF = "DevCapRef";
	/** */
	public static final String DEVCAPREFS = "DevCapRefs";
	/** */
	public static final String DEVCAPSREF = "DevCapsRef";
	/** */
	public static final String DEVICECLASS = "DeviceClass";
	/** */
	public static final String DEVICECONDITION = "DeviceCondition";
	/** */
	public static final String DEVICEDETAILS = "DeviceDetails";
	/** */
	public static final String DEVICEFAMILY = "DeviceFamily";
	/** */
	public static final String DEVICEID = "DeviceID";
	/** */
	public static final String DEVICEMODULEINDEX = "DeviceModuleIndex";
	/** */
	public static final String DEVICEOPERATIONMODE = "DeviceOperationMode";
	/** */
	public static final String DEVICESTATUS = "DeviceStatus";
	/** */
	public static final String DEVICETYPE = "DeviceType";
	/** */
	public static final String DEVNS = "DevNS";
	/** */
	public static final String DIAMETER = "Diameter";
	/** */
	public static final String DIESIDE = "DieSide";
	/** */
	public static final String DIFFERENTBOXSIZE = "DifferentBoxSize";
	/** */
	public static final String DIFFUSION = "Diffusion";
	/** */
	public static final String DIGITALDELIVERYDIRECTION = "DigitalDeliveryDirection";
	/** */
	public static final String DIGITALDELIVERYPROTOCOL = "DigitalDeliveryProtocol";
	/** */
	public static final String DIMENSION = "Dimension";
	/** */
	public static final String DIMENSIONS = "Dimensions";
	/** */
	public static final String DIRECTION = "Direction";
	/** */
	public static final String DIRECTORY = "Directory";
	/** */
	public static final String DIRECTPROOF = "DirectProof";
	/** */
	public static final String DIRECTPROOFAMOUNT = "DirectProofAmount";
	/** */
	public static final String DISPLAYTRAPS = "DisplayTraps";
	/** */
	public static final String DISPOSITION = "Disposition";
	/** */
	public static final String DISPOSITIONACTION = "DispositionAction";
	/** */
	public static final String DISPOSITIONUSAGE = "DispositionUsage";
	/** */
	public static final String DISTANCE = "Distance";
	/** */
	public static final String DIVIDEPOSITIONS = "DividePositions";
	/** */
	public static final String DOCCOPIES = "DocCopies";
	/** */
	public static final String DOCINDEX = "DocIndex";
	/** */
	public static final String DOCNAMES = "DocNames";
	/** */
	public static final String DOCORD = "DocOrd";
	/** */
	public static final String DOCRUNINDEX = "DocRunIndex";
	/** */
	public static final String DOCS = "Docs";
	/** */
	public static final String DOCSHEETINDEX = "DocSheetIndex";
	/** */
	public static final String DOCTAGS = "DocTags";
	/** */
	public static final String DOCUMENTCOMPRESSION = "DocumentCompression";
	/** */
	public static final String DOCUMENTCORRUPTION = "DocumentCorruption";
	/** */
	public static final String DOCUMENTENCODING = "DocumentEncoding";
	/** */
	public static final String DOCUMENTISGOODCOMPRESSION = "DocumentIsGoodCompression";
	/** */
	public static final String DOCUMENTNATURALLANG = "DocumentNaturalLang";
	/** */
	public static final String DOCUMENTPDLTYPE = "DocumentPDLType";
	/** */
	public static final String DOTGAIN = "DotGain";
	/** */
	public static final String DOTHUMBNAILS = "DoThumbnails";
	/** */
	public static final String DOTSIZE = "DotSize";
	/** */
	public static final String DOUBLEFEEDQUALITY = "DoubleFeedQuality";
	/** */
	public static final String DOUBLEFEEDS = "DoubleFeeds";
	/** */
	public static final String DOWNSAMPLEIMAGES = "DownsampleImages";
	/** */
	public static final String DRAFTOK = "DraftOK";
	/** */
	public static final String DROPID = "DropID";
	/** */
	public static final String DRYING = "Drying";
	/** */
	public static final String DUEDATE = "DueDate";
	/** */
	public static final String DUELEVEL = "DueLevel";
	/** */
	public static final String DURATION = "Duration";

	/** */
	public static final String EARLIEST = "Earliest";
	/** */
	public static final String EARLYCHANGE = "EarlyChange";
	/** */
	public static final String EDGEANGLE = "EdgeAngle";
	/** */
	public static final String EDGESHAPE = "EdgeShape";
	/** */
	public static final String EDITABLE = "Editable";
	/** */
	public static final String EDITION = "Edition";
	/** */
	public static final String EDITIONVERSION = "EditionVersion";
	/** */
	public static final String EFFECTIVERESOLUTION = "EffectiveResolution";
	/** */
	public static final String EFFORT = "Effort";
	/** */
	public static final String ELEMENTID = "ElementID";
	/** */
	public static final String ELEMENTIDS = "ElementIDs";
	/** */
	public static final String ELEMENTPAGES = "ElementPages";
	/** */
	public static final String ELEMENTTYPE = "ElementType";
	/** */
	public static final String EMBEDALLFONTS = "EmbedAllFonts";
	/** */
	public static final String EMBEDDEDPS = "EmbeddedPS";
	/** */
	public static final String EMBEDDINGRESTRICTIONFLAG = "EmbeddingRestrictionFlag";
	/** */
	public static final String EMBEDJOBOPTIONS = "EmbedJobOptions";
	/** */
	public static final String EMBOSSINGTYPE = "EmbossingType";
	/** */
	public static final String EMITDSCWARNINGS = "EmitDSCWarnings";
	/** */
	public static final String EMITPDFBG = "EmitPDFBG";
	/** */
	public static final String EMITPDFHALFTONES = "EmitPDFHalftones";
	/** */
	public static final String EMITPDFTRANSFERS = "EmitPDFTransfers";
	/** */
	public static final String EMITPDFUCR = "EmitPDFUCR";
	/** */
	public static final String EMPLOYEEINFO = "EmployeeInfo";
	/** */
	public static final String ENABLED = "Enabled";
	/** */
	public static final String ENCODECOLORIMAGES = "EncodeColorImages";
	/** */
	public static final String ENCODEDBYTEALIGN = "EncodedByteAlign";
	/** */
	public static final String ENCODEIMAGES = "EncodeImages";
	/** */
	public static final String ENCODING = "Encoding";
	/** */
	public static final String ENCODINGDETAILS = "EncodingDetails";
	/** */
	public static final String ENCRYPTEDDOCUMENT = "EncryptedDocument";
	/** */
	public static final String ENCRYPTIONFILTER = "EncryptionFilter";
	/** */
	public static final String ENCRYPTIONLENGTH = "EncryptionLength";
	/** */
	public static final String ENCRYPTIONRESTRICTIONS = "EncryptionRestrictions";
	/** */
	public static final String ENCRYPTIONSUBFILTER = "EncryptionSubFilter";
	/** */
	public static final String ENCRYPTIONV = "EncryptionV";
	/** */
	public static final String END = "End";
	/** */
	public static final String ENDOFBLOCK = "EndOfBlock";
	/** */
	public static final String ENDOFBUNDLEITEM = "EndOfBundleItem";
	/** */
	public static final String ENDOFDOCUMENT = "EndOfDocument";
	/** */
	public static final String ENDOFLINE = "EndOfLine";
	/** */
	public static final String ENDOFSET = "EndOfSet";
	/** */
	public static final String ENDPAGE = "EndPage";
	/** */
	public static final String ENDSTATUS = "EndStatus";
	/** */
	public static final String ENDTIME = "EndTime";
	/** */
	public static final String ERRORCORRECTIONLEVEL = "ErrorCorrectionLevel";
	/** */
	public static final String ERRORCOUNT = "ErrorCount";
	/** */
	public static final String ERRORID = "ErrorID";
	/** */
	public static final String ERRORSTATE = "ErrorState";
	/** */
	public static final String ERRORTYPE = "ErrorType";
	/** */
	public static final String ERRORURL = "ErrorURL";
	/** */
	public static final String ESTIMATE = "Estimate";
	/** */
	public static final String ESTIMATEDJPEGQUALITY = "EstimatedJPEGQuality";
	/** */
	public static final String EVENTID = "EventID";
	/** */
	public static final String EVENTVALUE = "EventValue";
	/** */
	public static final String EXACT = "Exact";
	/** */
	public static final String EXECUTIONPOLICY = "ExecutionPolicy";
	/** */
	public static final String EXPIRES = "Expires";
	/** */
	public static final String EXTENT = "Extent";
	/** */
	public static final String EXTERNALREFERENCEMISSING = "ExternalReferenceMissing";
	/** */
	public static final String EXTRADURATION = "ExtraDuration";

	/** */
	public static final String FACECELLS = "FaceCells";
	/** */
	public static final String FAILED = "Failed";
	/** */
	public static final String FALSE = "false";
	/** */
	public static final String FAMILIES = "Families";
	/** */
	public static final String FAMILY = "Family";
	/** */
	public static final String FAMILYNAME = "FamilyName";
	/** */
	public static final String FEEDERSYNCHRONIZATION = "FeederSynchronization";
	/** */
	public static final String FEEDERTYPE = "FeederType";
	/** */
	public static final String FIELDRANGE = "FieldRange";
	/** */
	public static final String FILE = "File";
	/** */
	public static final String FILEFORMAT = "FileFormat";
	/** */
	public static final String FILENAME = "FileName";
	/** */
	public static final String FILEPATH = "FilePath";
	/** */
	public static final String FILEPERPAGE = "FilePerPage";
	/** */
	public static final String FILESIZE = "FileSize";
	/** */
	public static final String FILETARGETDEVICEMODEL = "FileTargetDeviceModel";
	/** */
	public static final String FILETEMPLATE = "FileTemplate";
	/** */
	public static final String FILEVERSION = "FileVersion";
	/** */
	public static final String FILLCOLORNAME = "FillColorName";
	/** */
	public static final String FILLCOLORTYPE = "FillColorType";
	/** */
	public static final String FILLMATERIAL = "FillMaterial";
	/** */
	public static final String FILLPRIORITY = "FillPriority";
	/** */
	public static final String FINISHEDPAGE = "FinishedPage";
	/** */
	public static final String FINISHEDPAGEORIENTATION = "FinishedPageOrientation";
	/** */
	public static final String FINISHINGORDER = "FinishingOrder";
	/** */
	public static final String FINISHINGS = "Finishings";
	/** */
	public static final String FIRSTEND = "FirstEnd";
	/** */
	public static final String FIRSTNAME = "FirstName";
	/** */
	public static final String FIRSTPAGE = "FirstPage";
	/** */
	public static final String FIRSTSTART = "FirstStart";
	/** */
	public static final String FIRSTSURFACE = "FirstSurface";
	/** */
	public static final String FITTOPAGE = "FitToPage";
	/** */
	public static final String FIXATION = "Fixation";
	/** */
	public static final String FIXEXPRESSION = "FixExpression";
	/** */
	public static final String FLATDIMENSIONS = "FlatDimensions";
	/** */
	public static final String FLATNESS = "Flatness";
	/** */
	public static final String FLEXVALUE = "FlexValue";
	/** */
	public static final String FLIPBACKCOVER = "FlipBackCover";
	/** */
	public static final String FLUSHPOLICY = "FlushPolicy";
	/** */
	public static final String FLUTE = "Flute";
	/** */
	public static final String FLUTEDIRECTION = "FluteDirection";
	/** */
	public static final String FOLDCATALOG = "FoldCatalog";
	/** */
	public static final String FOLDCATALOGORIENTATION = "FoldCatalogOrientation";
	/** */
	public static final String FOLDERMODULEINDEX = "FolderModuleIndex";
	/** */
	public static final String FOLDINDEX = "FoldIndex";
	public static final String FOLDINGDETAILS = "FoldingDetails";
	public static final String FOLDINGWIDTH = "FoldingWidth";
	/** */
	public static final String FOLDLAY = "FoldLay";
	/** */
	public static final String FOLDOUTPAGES = "FoldOutPages";
	/** */
	public static final String FOLDS = "Folds";
	/** */
	public static final String FOLDSHEETIN = "FoldSheetIn";
	/** */
	public static final String FOLIO = "Folio";
	/** */
	public static final String FOLIOCOUNT = "FolioCount";
	/** */
	public static final String FONT = "Font";
	/** */
	public static final String FONTCORRUPTED = "FontCorrupted";
	/** */
	public static final String FONTCREATOR = "FontCreator";
	/** */
	public static final String FONTEMBEDDED = "FontEmbedded";
	/** */
	public static final String FONTISSTANDARDLATIN = "FontIsStandardLatin";
	/** */
	public static final String FONTNAME = "FontName";
	/** */
	public static final String FONTNOTUSED = "FontNotUsed";
	/** */
	public static final String FONTSIZE = "FontSize";
	/** */
	public static final String FONTSUBSET = "FontSubset";
	/** */
	public static final String FONTTYPE = "FontType";
	/** */
	public static final String FONTVENDOR = "FontVendor";
	/** */
	public static final String FORCEFRONTSIDE = "ForceFrontSide";
	/** */
	public static final String FORCESEPARATIONS = "ForceSeparations";
	/** */
	public static final String FORMAT = "Format";
	/** */
	public static final String FOUNTAINNUMBER = "FountainNumber";
	/** */
	public static final String FOUNTAINPOSITIONS = "FountainPositions";
	/** */
	public static final String FOUNTAINSOLUTION = "FountainSolution";
	/** */
	public static final String FRAMEHEIGHT = "FrameHeight";
	/** */
	public static final String FRAMEWIDTH = "FrameWidth";
	/** */
	public static final String FREQUENCY = "Frequency";
	/** */
	public static final String FRIENDLYNAME = "FriendlyName";
	/** */
	public static final String FROM = "From";
	/** */
	public static final String FROMBOX = "FromBox";
	/** */
	public static final String FRONTCOATINGDETAIL = "FrontCoatingDetail";
	/** */
	public static final String FRONTCOATINGS = "FrontCoatings";
	/** */
	public static final String FRONTFACEPAGES = "FrontFacePages";
	/** */
	public static final String FRONTFOLDIN = "FrontFoldIn";
	/** */
	public static final String FRONTGLOSSVALUE = "FrontGlossValue";
	/** */
	public static final String FRONTMARKLIST = "FrontMarkList";
	/** */
	public static final String FRONTOVERFOLD = "FrontOverfold";
	/** */
	public static final String FRONTPAGES = "FrontPages";
	/** */
	public static final String FRONTSIDE = "FrontSide";
	/** */
	public static final String FRONTSPREAD = "FrontSpread";

	/** */
	public static final String GANGELEMENTID = "GangElementID";
	/** */
	public static final String GANGNAME = "GangName";
	/** */
	public static final String GANGNAMES = "GangNames";
	/** */
	public static final String GANGPOLICY = "GangPolicy";
	/** */
	public static final String GAPLIST = "GapList";
	/** */
	public static final String GENERATEPAGESTREAMS = "GeneratePageStreams";
	/** */
	public static final String GENERICATTRIBUTES = "GenericAttributes";
	/** */
	public static final String GLUEBRAND = "GlueBrand";
	/** */
	public static final String GLUELINEREFSHEETS = "GlueLineRefSheets";
	/** */
	public static final String GLUELINEWIDTH = "GlueLineWidth";
	/** */
	public static final String GLUETYPE = "GlueType";
	/** */
	public static final String GLUINGPATTERN = "GluingPattern";
	/** */
	public static final String GLUINGPRODUCTIONID = "GluingProductionID";
	/** */
	public static final String GLUINGTECHNIQUE = "GluingTechnique";
	/** */
	public static final String GRADE = "Grade";
	/** */
	public static final String GRAINDIRECTION = "GrainDirection";
	/** */
	public static final String GRAY = "Gray";
	/** */
	public static final String GROSSWEIGHT = "GrossWeight";
	/** */
	public static final String GROUPBY = "GroupBy";
	/** */
	public static final String GROUPCODE = "GroupCode";
	/** */
	public static final String GUTTER = "Gutter";
	/** */
	public static final String GUTTERMINIMUMLIMIT = "GutterMinimumLimit";
	/** */
	public static final String GUTTERPOLICY = "GutterPolicy";
	/** */
	public static final String GUTTERX = "GutterX";
	/** */
	public static final String GUTTERX2 = "GutterX2";
	/** */
	public static final String GUTTERY = "GutterY";
	/** */
	public static final String GUTTERY2 = "GutterY2";

	/** */
	public static final String HALFTONE = "HalfTone";
	/** */
	public static final String HALFTONED = "Halftoned";
	/** */
	public static final String HALFTONENAME = "HalftoneName";
	/** */
	public static final String HALFTONEPHASE = "HalfTonePhase";
	/** */
	public static final String HALFTONEPHASEORIGIN = "HalfTonePhaseOrigin";
	/** */
	public static final String HARDENERTYPE = "HardenerType";
	/** */
	public static final String HASBLEEDS = "HasBleeds";
	/** */
	public static final String HASCOLORLUT = "HasColorLUT";
	/** */
	public static final String HASDEFAULT = "HasDefault";
	/** */
	public static final String HASEXTERNALREFERENCE = "HasExternalReference";
	/** */
	public static final String HASFILLCOLOR = "HasFillColor";
	/** */
	public static final String HASOPI = "HasOPI";
	/** */
	public static final String HASPRICE = "HasPrice";
	/** */
	public static final String HASSOFTMASK = "HasSoftMask";
	/** */
	public static final String HASSTROKECOLOR = "HasStrokeColor";
	/** */
	public static final String HEIGHT = "Height";
	/** */
	public static final String HELPTEXT = "HelpText";
	/** */
	public static final String HOLD = "Hold";
	/** */
	public static final String HOLECOUNT = "HoleCount";
	/** */
	public static final String HOLEREFERENCEEDGE = "HoleReferenceEdge";
	/** */
	public static final String HOLETYPE = "HoleType";
	/** */
	public static final String HONORPDFOVERPRINT = "HonorPDFOverprint";
	/** */
	public static final String HORIZONTALCREEP = "HorizontalCreep";
	/** */
	public static final String HORIZONTALEXCESS = "HorizontalExcess";
	/** */
	public static final String HORIZONTALEXCESSBACK = "HorizontalExcessBack";
	/** */
	public static final String HORIZONTALFITPOLICY = "HorizontalFitPolicy";
	/** */
	public static final String HOTFOLDER = "HotFolder";
	/** */
	public static final String HOURCOUNTER = "HourCounter";
	/** */
	public static final String HSAMPLES = "HSamples";
	/** */
	public static final String HTTPGET = "HttpGet";
	/** */
	public static final String HUFFTABLE = "HuffTable";
	/** */
	public static final String HWRELATION = "HWRelation";

	/** */
	public static final String ICCCOLORASDEVICECOLOR = "ICCColorAsDeviceColor";
	/** */
	public static final String ICCOUTPUTPROFILEUSAGE = "ICCOutputProfileUsage";
	/** */
	public static final String ICCPROFILESUBFOLDER = "ICCProfileSubFolder";
	/** */
	public static final String ICCPROFILEUSAGE = "ICCProfileUsage";
	/** */
	public static final String ICONUSAGE = "IconUsage";
	/** */
	public static final String ICSVERSIONS = "ICSVersions";
	/** */
	public static final String ID = "ID";
	/** */
	public static final String IDENTIFIER = "Identifier";
	/** */
	public static final String IDLESTARTTIME = "IdleStartTime";
	/** */
	public static final String IDPATTRIBUTEFIDELITY = "IDPAttributeFidelity";
	/** */
	public static final String IDUSAGE = "IDUsage";
	/** */
	public static final String IDVALUE = "IDValue";
	/** */
	public static final String IGNOREANNOTFORMS = "IgnoreAnnotForms";
	/** */
	public static final String IGNOREBG = "IgnoreBG";
	/** */
	public static final String IGNORECOLORSEPS = "IgnoreColorSeps";
	/** */
	public static final String IGNORECONTEXT = "IgnoreContext";
	/** */
	public static final String IGNOREDEVICEEXTGSTATE = "IgnoreDeviceExtGState";
	/** */
	public static final String IGNOREDSC = "IgnoreDSC";
	/** */
	public static final String IGNOREEMBEDDEDICC = "IgnoreEmbeddedICC";
	/** */
	public static final String IGNOREEXTENSIONS = "IgnoreExtensions";
	/** */
	public static final String IGNOREEXTERNSTREAMREF = "IgnoreExternStreamRef";
	/** */
	public static final String IGNOREFILEPARAMS = "IgnoreFileParams";
	/** */
	public static final String IGNOREHALFTONES = "IgnoreHalftones";
	/** */
	public static final String IGNOREOVERPRINT = "IgnoreOverprint";
	/** */
	public static final String IGNOREPAGEROTATION = "IgnorePageRotation";
	/** */
	public static final String IGNOREPDLCOPIES = "IgnorePDLCopies";
	/** */
	public static final String IGNOREPDLIMPOSITION = "IgnorePDLImposition";
	/** */
	public static final String IGNORERAWDATA = "IgnoreRawData";
	/** */
	public static final String IGNORESEPARABLEIMAGESONLY = "IgnoreSeparableImagesOnly";
	/** */
	public static final String IGNORESHOWPAGE = "IgnoreShowPage";
	/** */
	public static final String IGNORESOURCEFILE = "IgnoreSourceFile";
	/** */
	public static final String IGNORETRANSFERS = "IgnoreTransfers";
	/** */
	public static final String IGNORETTFONTSFIRST = "IgnoreTTFontsFirst";
	/** */
	public static final String IGNOREUCR = "IgnoreUCR";
	/** */
	public static final String ILLUMINATION = "Illumination";
	public static final String ILLUMINATIONANGLE = "IlluminationAngle";
	/** */
	public static final String IMAGABLESIDE = "ImagableSide";
	/** */
	public static final String IMAGEAUTOFILTERSTRATEGY = "ImageAutoFilterStrategy";
	/** */
	public static final String IMAGEDEPTH = "ImageDepth";
	/** */
	public static final String IMAGEDOWNSAMPLETHRESHOLD = "ImageDownsampleThreshold";
	/** */
	public static final String IMAGEDOWNSAMPLETYPE = "ImageDownsampleType";
	/** */
	public static final String IMAGEFILTER = "ImageFilter";
	/** */
	public static final String IMAGEFLIPPED = "ImageFlipped";
	/** */
	public static final String IMAGEINTERNALTRAPPING = "ImageInternalTrapping";
	/** */
	public static final String IMAGEMASKTRAPPING = "ImageMaskTrapping";
	/** */
	public static final String IMAGEMASKTYPE = "ImageMaskType";
	/** */
	public static final String IMAGEMEMORY = "ImageMemory";
	/** */
	public static final String IMAGEPRESCANSTRATEGY = "ImagePreScanStrategy";
	/** */
	public static final String IMAGEREPLACEMENTSTRATEGY = "ImageReplacementStrategy";
	/** */
	public static final String IMAGERESOLUTION = "ImageResolution";
	/** */
	public static final String IMAGEROTATION = "ImageRotation";
	/** */
	public static final String IMAGESCALINGRATIO = "ImageScalingRatio";
	/** */
	public static final String IMAGESIZE = "ImageSize";
	/** */
	public static final String IMAGESKEW = "ImageSkew";
	/** */
	public static final String IMAGESUBFOLDER = "ImagesSubFolder";
	/** */
	public static final String IMAGETOIMAGETRAPPING = "ImageToImageTrapping";
	/** */
	public static final String IMAGETOOBJECTTRAPPING = "ImageToObjectTrapping";
	/** */
	public static final String IMAGETRAPPLACEMENT = "ImageTrapPlacement";
	/** */
	public static final String IMAGETRAPWIDTH = "ImageTrapWidth";
	/** */
	public static final String IMAGETRAPWIDTHY = "ImageTrapWidthY";
	/** */
	public static final String IMAGETYPE = "ImageType";
	/** */
	public static final String IMAGEVIEWINGSTRATEGY = "ImageViewingStrategy";
	/** */
	public static final String IMPLICITGUTTER = "ImplicitGutter";
	/** */
	public static final String IMPLICITGUTTERMINIMUMLIMIT = "ImplicitGutterMinimumLimit";
	/** */
	public static final String INCLUDEBASEFONTS = "IncludeBaseFonts";
	/** */
	public static final String INCLUDECIDFONTS = "IncludeCIDFonts";
	/** */
	public static final String INCLUDEEMBEDDEDFONTS = "IncludeEmbeddedFonts";
	/** */
	public static final String INCLUDEINBUNDLEITEM = "IncludeInBundleItem";
	/** */
	public static final String INCLUDEITEMINBUNDLE = "IncludeItemInBundle";
	/** */
	public static final String INCLUDEOCG = "IncludeOCG";
	/** */
	public static final String INCLUDEOTHERRESOURCES = "IncludeOtherResources";
	/** */
	public static final String INCLUDEPROCSETS = "IncludeProcSets";
	/** */
	public static final String INCLUDETRUETYPEFONTS = "IncludeTrueTypeFonts";
	/** */
	public static final String INCLUDETYPE1FONTS = "IncludeType1Fonts";
	/** */
	public static final String INCLUDETYPE3FONTS = "IncludeType3Fonts";
	/** */
	public static final String INCORRECTCOMPONENTQUALITY = "IncorrectComponentQuality";
	/** */
	public static final String INCORRECTCOMPONENTS = "IncorrectComponents";
	/** */
	public static final String INDEPENDENT = "Independent";
	/** */
	public static final String INDEX = "Index";
	/** */
	public static final String INITIALPAGESIZE = "InitialPageSize";
	/** */
	public static final String INITIALRESOLUTION = "InitialResolution";
	/** */
	public static final String INKCOVERAGE = "InkCoverage";
	/** */
	public static final String INKNAME = "InkName";
	/** */
	public static final String INKSTATE = "InkState";
	/** */
	public static final String INNERCOREDIAMETER = "InnerCoreDiameter";
	/** */
	public static final String INNERDIMENSIONS = "InnerDimensions";
	/** */
	public static final String INNERMOSTSHINGLING = "InnermostShingling";
	/** */
	public static final String INPUTBOX = "InputBox";
	/** */
	public static final String INPUTFIELD = "InputField";
	/** */
	public static final String INSERTERROR = "InsertError";
	/** */
	public static final String INSERTLOCATION = "InsertLocation";
	/** */
	public static final String INSERTOK = "InsertOK";
	/** */
	public static final String INSIDEBOX = "InsideBox";
	/** */
	public static final String INSIDELOSS = "InsideLoss";
	/** */
	public static final String INSTRUMENTATION = "Instrumentation";
	/** */
	public static final String INTEGERVALUE = "IntegerValue";
	/** */
	public static final String INTENT = "Intent";
	/** */
	public static final String INTERLEAVED = "Interleaved";
	/** */
	public static final String INTERLEAVING = "Interleaving";
	/** */
	public static final String INTERNALCOLORMODEL = "InternalColorModel";
	/** */
	public static final String IPPJOBPRIORITY = "IPPJobPriority";
	/** */
	public static final String IPPVERSION = "IPPVersion";
	/** */
	public static final String ISBLANK = "IsBlank";
	/** */
	public static final String ISBN = "ISBN";
	/** */
	public static final String ISBN10 = "ISBN10";
	/** */
	public static final String ISBN13 = "ISBN13";
	/** */
	public static final String ISDEVICE = "IsDevice";
	/** */
	public static final String ISDOUBLEBYTEFONT = "IsDoubleByteFont";
	/** */
	public static final String ISFONTSCREENONLY = "IsFontScreenOnly";
	/** */
	public static final String ISOPAPERSUBSTRATE = "ISOPaperSubstrate";
	/** */
	public static final String ISPAGE = "IsPage";
	/** */
	public static final String ISPRINTABLE = "IsPrintable";
	/** */
	public static final String ISTRAPPED = "IsTrapped";
	/** */
	public static final String ISWASTE = "IsWaste";
	/** */
	public static final String ITEM = "Item";
	/** */
	public static final String ITEMNAME = "ItemName";
	/** */
	public static final String ITEMNAMES = "ItemNames";

	/** */
	public static final String JBIG2LOSSLESS = "JBIG2Lossless";
	/** */
	public static final String JDFDETAILS = "JDFDetails";
	/** */
	public static final String JDFERRORURL = "JDFErrorURL";
	/** */
	public static final String JDFINPUTURL = "JDFInputURL";
	/** */
	public static final String JDFOUTPUTURL = "JDFOutputURL";
	/** */
	public static final String JDFURL = "JDFURL";
	/** */
	public static final String JDFVERSIONS = "JDFVersions";
	/** */
	public static final String JMFROLE = "JMFRole";
	/** */
	public static final String JMFSENDERID = "JMFSenderID";
	/** */
	public static final String JMFURL = "JMFURL";
	/** */
	public static final String JOBDETAILS = "JobDetails";
	/** */
	public static final String JOBFORMAT = "JobFormat";
	/** */
	public static final String JOBID = "JobID";
	/** */
	public static final String JOBPARTID = "JobPartID";
	/** */
	public static final String JOBPRIORITY = "JobPriority";
	/** */
	public static final String JOBTEMPLATE = "JobTemplate";
	/** */
	public static final String JOBTITLE = "JobTitle";
	/** */
	public static final String JOGEDGE = "JogEdge";
	/** */
	public static final String JOGSIDE = "JogSide";
	/** */
	public static final String JOINTWIDTH = "JointWidth";
	/** */
	public static final String JPXQUALITY = "JPXQuality";
	/** */
	public static final String JREF = "jRef";
	/** */
	public static final String JREFDESTINATION = "jRefDestination";
	/** */
	public static final String JREFSOURCE = "jRefSource";

	/** */
	public static final String K = "K";
	/** */
	public static final String KEY = "Key";
	/** */
	public static final String KEYWORDS = "Keywords";
	/** */
	public static final String KNOCKOUTBLEED = "KnockoutBleed";
	/** */
	public static final String KNOCKOUTCMYKWHITE = "KnockOutCMYKWhite";
	/** */
	public static final String KNOCKOUTREFS = "KnockoutRefs";
	/** */
	public static final String KNOCKOUTSOURCE = "KnockoutSource";
	/** */
	public static final String KNOWNLOCALIZATIONS = "KnownLocalizations";

	/** */
	public static final String LAB = "Lab";
	/** */
	public static final String LABCOLORVALUE = "LabColorValue";
	/** */
	public static final String LABORTYPE = "LaborType";
	/** */
	public static final String LAMINATINGBOX = "LaminatingBox";
	/** */
	public static final String LAMINATINGMETHOD = "LaminatingMethod";
	/** */
	public static final String LANG = "Lang";
	/** */
	public static final String LANGUAGE = "Language";
	/** */
	public static final String LANGUAGES = "Languages";
	/** */
	public static final String LASTCOUNT = "LastCount";
	/** */
	public static final String LASTEND = "LastEnd";
	/** */
	public static final String LASTREPEAT = "LastRepeat";
	/** */
	public static final String LASTSTART = "LastStart";
	/** */
	public static final String LAYERAMOUNT = "LayerAmount";
	/** */
	public static final String LAYERCOMPRESSION = "LayerCompression";
	/** */
	public static final String LAYERID = "LayerID";
	/** */
	public static final String LAYERIDS = "LayerIDs";
	/** */
	public static final String LAYERLIFT = "LayerLift";
	/** */
	public static final String LAYERRATES = "LayerRates";
	/** */
	public static final String LAYERS = "Layers";
	/** */
	public static final String LAYERSPERTILE = "LayersPerTile";
	/** */
	public static final String LAYOUTELEMENTPAGENUM = "LayoutElementPageNum";
	/** */
	public static final String LAYOUTSTYLE = "LayoutStyle";
	/** */
	public static final String LEADINGEDGE = "LeadingEdge";
	/** */
	public static final String LENGTH = "Length";
	/** */
	public static final String LENGTHJDF = LENGTH;
	/** */
	public static final String LENGTHOVERALL = "LengthOverall";
	/** */
	public static final String LEVEL = "Level";
	/** */
	public static final String LIGHT = "Light";
	/** */
	public static final String LINEARIZED = "Linearized";
	/** */
	public static final String LINEARTBLACKLEVEL = "LineArtBlackLevel";
	/** */
	public static final String LINEWIDTH = "LineWidth";
	/** */
	public static final String LINK = "Link";
	/** */
	public static final String LINKUSAGE = "LinkUsage";
	/** */
	public static final String LISTCOMMANDS = "ListCommands";
	/** */
	public static final String LISTPOLICY = "ListPolicy";
	/** */
	public static final String LISTQUERIES = "ListQueries";
	/** */
	public static final String LISTREGISTRATIONS = "ListRegistrations";
	/** */
	public static final String LISTSIGNALS = "ListSignals";
	/** */
	public static final String LISTTYPE = "ListType";
	/** */
	public static final String LOADING = "Loading";
	/** */
	public static final String LOCALIZATION = "Localization";
	/** */
	public static final String LOCATION = "Location";
	/** */
	public static final String LOCATIONNAME = "LocationName";
	/** */
	public static final String LOCATOR = "Locator";
	/** */
	public static final String LOCID = "LocID";
	/** */
	public static final String LOCKDISTILLERPARAMS = "LockDistillerParams";
	/** */
	public static final String LOCKED = "Locked";
	/** */
	public static final String LOCKORIGINS = "LockOrigins";
	/** */
	public static final String LOGERRORS = "LogErrors";
	/** */
	public static final String LOGICALPAGE = "LogicalPage";
	/** */
	public static final String LOGICALPRINTERSECTION = "LogicalPrinterSection";
	/** */
	public static final String LOGICALSTACKORD = "LogicalStackOrd";
	/**
	 *
	 */
	public static final String LOGICALSTACKSEQUENCE = "LogicalStackSequence";
	/** */
	public static final String LOTCONTROL = "LotControl";
	/** */
	public static final String LOTCONTROLLED = "LotControlled";
	/** */
	public static final String LOTDETAILS = "LotDetails";
	/** */
	public static final String LOTID = "LotID";
	/** */
	public static final String LOWERRIBBONNAME = "LowerRibbonName";

	/** */
	public static final String MACROREFS = "MacroRefs";
	/** */
	public static final String MAGNIFICATION = "Magnification";
	/** */
	public static final String MANUALFEED = "ManualFeed";
	/** */
	public static final String MANUFACTURER = "Manufacturer";
	/** */
	public static final String MANUFACTURERURL = "ManufacturerURL";
	/** */
	public static final String MAPPINGSELECTION = "MappingSelection";
	/** */
	public static final String MARGINBOTTOM = "MarginBottom";
	/** */
	public static final String MARGINLEFT = "MarginLeft";
	/** */
	public static final String MARGINRIGHT = "MarginRight";
	/** */
	public static final String MARGINTOP = "MarginTop";
	/** */
	public static final String MARKCONTEXT = "MarkContext";
	/** */
	public static final String MARKJUSTIFICATION = "MarkJustification";
	/** */
	public static final String MARKLIST = "MarkList";
	/** */
	public static final String MARKNAME = "MarkName";
	/** */
	public static final String MARKOFFSET = "MarkOffset";
	/** */
	public static final String MARKORIENTATION = "MarkOrientation";
	/** */
	public static final String MARKPOSITION = "MarkPosition";
	/** */
	public static final String MARKSIDE = "MarkSide";
	/** */
	public static final String MARKTYPE = "MarkType";
	/** */
	public static final String MARKUSAGE = "MarkUsage";
	/** */
	public static final String MASK = "Mask";
	/** */
	public static final String MASKBLEED = "MaskBleed";
	/** */
	public static final String MASKING = "Masking";
	/** */
	public static final String MASKSEPARATION = "MaskSeparation";
	/** */
	public static final String MATERIAL = "Material";
	/** */
	public static final String MAXAMOUNT = "MaxAmount";
	/** */
	public static final String MAXCLEANUP = "MaxCleanup";
	/** */
	public static final String MAXCOLLECT = "MaxCollect";
	/** */
	public static final String MAXDIAMETER = "MaxDiameter";
	/** */
	public static final String MAXDOCORD = "MaxDocOrd";
	/** */
	public static final String MAXENTRIES = "MaxEntries";
	/** */
	public static final String MAXGROUPS = "MaxGroups";
	/** */
	public static final String MAXHEAT = "MaxHeat";
	/** */
	public static final String MAXHEIGHT = "MaxHeight";
	/** */
	public static final String MAXOCCURRENCES = "MaxOccurrences";
	/** */
	public static final String MAXOCCURRENCIES = "MaxOccurrencies";
	/** */
	public static final String MAXOCCURS = "MaxOccurs";
	/** */
	public static final String MAXORD = "MaxOrd";
	/** */
	public static final String MAXPERGROUP = "MaxPerGroup";
	/** */
	public static final String MAXQUANTITY = "MaxQuantity";
	/** */
	public static final String MAXRESOLUTION = "MaxResolution";
	public static final String MAXRUNSPEED = "MaxRunSpeed";
	public static final String MAXSEARCHRECURSION = "MaxSearchRecursion";
	/** */
	public static final String MAXSTACKDEPTH = "MaxStackDepth";
	/** */
	public static final String MAXSETORD = "MaxSetOrd";
	/** */
	public static final String MAXSETUP = "MaxSetup";
	/** */
	public static final String MAXSUBSETPCT = "MaxSubsetPct";
	/** */
	public static final String MAXVERSION = "MaxVersion";
	/** */
	public static final String MAXWEIGHT = "MaxWeight";
	/** */
	public static final String MAXWIDTH = "MaxWidth";
	/** */
	public static final String MEASUREMENTANGLE = "MeasurementAngle";
	public static final String MEASUREMENTFILTER = "MeasurementFilter";
	public static final String MEASUREMENTS = "Measurements";
	public static final String MEASUREMENTUSAGE = "MeasurementUsage";

	public static final String MEDIACOLORNAME = "MediaColorName";
	public static final String MEDIACOLORNAMEDETAILS = "MediaColorNameDetails";
	public static final String MEDIALABEL = "MediaLabel";
	public static final String MEDIALOCATION = "MediaLocation";
	public static final String MEDIAQUALITY = "MediaQuality";
	public static final String MEDIASETCOUNT = "MediaSetCount";
	public static final String MEDIASIDE = "MediaSide";
	public static final String MEDIATYPE = "MediaType";
	public static final String MEDIATYPEDETAILS = "MediaTypeDetails";
	public static final String MEDIAUNIT = "MediaUnit";
	/** */
	public static final String MELTINGTEMPERATURE = "MeltingTemperature";
	/** */
	public static final String MERGEID = "MergeID";
	/** */
	public static final String MERGETARGET = "MergeTarget";
	/** */
	public static final String MESSAGEEVENTS = "MessageEvents";
	/** */
	public static final String MESSAGEID = "MessageID";
	/** */
	public static final String MESSAGEREFID = "MessageRefID";
	/** */
	public static final String MESSAGETYPE = "MessageType";
	/** */
	public static final String MESSAGETYPES = "MessageTypes";
	/** */
	public static final String METADATA = "Metadata";
	/** */
	public static final String METADATA0 = "Metadata0";
	/** */
	public static final String METADATA1 = "Metadata1";
	/** */
	public static final String METADATA2 = "Metadata2";
	/** */
	public static final String METADATA3 = "Metadata3";
	/** */
	public static final String METADATA4 = "Metadata4";
	/** */
	public static final String METADATA5 = "Metadata5";
	/** */
	public static final String METADATA6 = "Metadata6";
	/** */
	public static final String METADATA7 = "Metadata7";
	/** */
	public static final String METADATA8 = "Metadata8";
	/** */
	public static final String METADATA9 = "Metadata9";
	/** */
	public static final String METHOD = "Method";
	/** */
	public static final String MILESTONETYPE = "MilestoneType";
	/** */
	public static final String MILESTONETYPES = "MileStoneTypes";
	/** */
	public static final String MILLINGDEPTH = "MillingDepth";
	/** */
	public static final String MIME = "MIME";
	/** */
	public static final String MIMETYPE = "MimeType";
	/** */
	public static final String MIMETYPEDETAILS = "MimeTypeDetails";
	/** */
	public static final String MIMETYPEVERSION = "MimeTypeVersion";
	/** */
	public static final String MINAMOUNT = "MinAmount";
	/** */
	public static final String MINAPPROVALS = "MinApprovals";
	/** */
	public static final String MINCLEANUP = "MinCleanup";
	/** */
	public static final String MINCOLLECT = "MinCollect";
	/** */
	public static final String MINDELAYTIME = "MinDelayTime";
	/** */
	public static final String MINDURATION = "MinDuration";
	/** */
	public static final String MINGUTTER = "MinGutter";
	/** */
	public static final String MINIMUMBLACKWIDTH = "MinimumBlackWidth";
	/** */
	public static final String MINIMUMWAIT = "MinimumWait";
	/** */
	public static final String MINLATESTATUS = "MinLateStatus";
	/** */
	public static final String MINLINEWIDTH = "MinLineWidth";
	/** */
	public static final String MINOCCURS = "MinOccurs";
	/** */
	public static final String MINQUANTITY = "MinQuantity";
	/** */
	public static final String MINRESOLUTION = "MinResolution";
	/** */
	public static final String MINSETUP = "MinSetup";
	/** */
	public static final String MINSTATUS = "MinStatus";
	/** */
	public static final String MIRRORAROUND = "MirrorAround";
	/** */
	public static final String MIRRORMARGINS = "MirrorMargins";
	/** */
	public static final String MISSINGPRINTERFONT = "MissingPrinterFont";
	/** */
	public static final String MISSINGSCREENFONT = "MissingScreenFont";
	/** */
	public static final String MODE = "Mode";
	/** */
	public static final String MODELDESCRIPTION = "ModelDescription";
	/** */
	public static final String MODELNAME = "ModelName";
	/** */
	public static final String MODELNUMBER = "ModelNumber";
	/** */
	public static final String MODELURL = "ModelURL";
	/** */
	public static final String MODIFICATION = "Modification";
	/** */
	public static final String MODIFICATIONDATE = "ModificationDate";
	/** */
	public static final String MODIFICATIONDATEINDOCUMENT = "ModificationDateInDocument";
	/** */
	public static final String MODIFICATIONID = "ModificationID";
	/** */
	public static final String MODULEAVAILABLEINDEX = "ModuleAvailableIndex";
	/** */
	public static final String MODULEDRYING = "ModuleDrying";
	/** */
	public static final String MODULEHEIGHT = "ModuleHeight";
	/** */
	public static final String MODULEID = "ModuleID";
	/** */
	public static final String MODULEINDEX = "ModuleIndex";
	/** */
	public static final String MODULEREFS = "ModuleRefs";
	/** */
	public static final String MODULETYPE = "ModuleType";
	/** */
	public static final String MODULEWIDTH = "ModuleWidth";
	/** */
	public static final String MOUNTID = "MountID";
	/** */
	public static final String MOUNTING = "Mounting";
	/** */
	public static final String MUSTHONOREXCEPTIONS = "MustHonorExceptions";

	/** */
	public static final String N = "N";
	/** */
	public static final String NAME = "Name";
	/** */
	public static final String NAMEDFEATURES = "NamedFeatures";
	/** */
	public static final String NAMEPREFIX = "NamePrefix";
	/** */
	public static final String NAMESPACE = "NameSpace";
	/** */
	public static final String NAMESUFFIX = "NameSuffix";
	/** */
	public static final String NATURALLANG = "NaturalLang";
	/** */
	public static final String NDOC = "NDoc";
	/** */
	public static final String NEEDLEPOSITIONS = "NeedlePositions";
	/** */
	public static final String NEUTRALDENSITY = "NeutralDensity";
	/** */
	public static final String NEVEREMBED = "NeverEmbed";
	/** */
	public static final String NEWERTHAN = "NewerThan";
	/** */
	public static final String NEWSPAWNID = "NewSpawnID";
	/** */
	public static final String NEWTIME = "NewTime";
	/** */
	public static final String NEWVALUE = "NewValue";
	/** */
	public static final String NEXTQUEUEENTRYID = "NextQueueEntryID";
	/** */
	public static final String NIPWIDTH = "NipWidth";
	/** */
	public static final String NODEID = "NodeID";
	/** */
	public static final String NODESTATUS = "NodeStatus";
	/** */
	public static final String NODESTATUSDETAILS = "NodeStatusDetails";
	/** */
	public static final String NONPRINTABLEMARGINBOTTOM = "NonPrintableMarginBottom";
	/** */
	public static final String NONPRINTABLEMARGINLEFT = "NonPrintableMarginLeft";
	/** */
	public static final String NONPRINTABLEMARGINRIGHT = "NonPrintableMarginRight";
	/** */
	public static final String NONPRINTABLEMARGINTOP = "NonPrintableMarginTop";
	/** */
	public static final String NOOP = "NoOp";
	/** */
	public static final String NOTCHINGDEPTH = "NotchingDepth";
	/** */
	public static final String NOTCHINGDISTANCE = "NotchingDistance";
	/** */
	public static final String NPAGE = "NPage";
	/** */
	public static final String NSET = "NSet";
	/** */
	public static final String NUMBER = "Number";
	/** */
	public static final String NUMBEROFCOLORSINLUT = "NumberOfColorsInLUT";
	/** */
	public static final String NUMBEROFNEEDLES = "NumberOfNeedles";
	/** */
	public static final String NUMBEROFPAGES = "NumberOfPages";
	/** */
	public static final String NUMBEROFPATHPOINTS = "NumberOfPathPoints";
	/** */
	public static final String NUMBEROFSTITCHES = "NumberOfStitches";
	/** */
	public static final String NUMBERUP = "NumberUp";
	/** */
	public static final String NUMBERVALUE = "NumberValue";
	/** */
	public static final String NUMCOLORS = "NumColors";
	/** */
	public static final String NUMRESOLUTIONS = "NumResolutions";
	/** */
	public static final String NUPSEPARATION = "NUpSeparation";

	/** */
	public static final String OBJECTTAGS = "ObjectTags";
	/** */
	public static final String OBLIGATED = "Obligated";
	/** */
	public static final String OBSERVATIONPATH = "ObservationPath";
	/** */
	public static final String OBSERVER = "Observer";
	/** */
	public static final String OCCURRENCES = "Occurrences";
	/** */
	public static final String OCGDEFAULT = "OCGDefault";
	/** */
	public static final String OCGINTENT = "OCGIntent";
	/** */
	public static final String OCGNAME = "OCGName";
	/** */
	public static final String OCGPROCESS = "OCGProcess";
	/** */
	public static final String OCGZOOM = "OCGZoom";
	/** */
	public static final String OFFERRANGE = "OfferRange";
	/** */
	public static final String OFFSET = "Offset";
	/** */
	public static final String OFFSETAMOUNT = "OffsetAmount";
	/** */
	public static final String OFFSETDIRECTION = "OffsetDirection";
	/** */
	public static final String OFFSETUNITS = "OffsetUnits";
	/** */
	public static final String OLDERTHAN = "OlderThan";
	/** */
	public static final String OLDTIME = "OldTime";
	/** */
	public static final String OLDVALUE = "OldValue";
	/** */
	public static final String ONESHEET = "OneSheet";
	/** */
	public static final String OPACITY = "Opacity";
	/** */
	public static final String OPACITYLEVEL = "OpacityLevel";
	/** */
	public static final String OPENING = "Opening";
	/** */
	public static final String OPERATION = "Operation";
	/** */
	public static final String OPERATIONDETAILS = "OperationDetails";
	/** */
	public static final String OPERATIONS = "Operations";
	/** */
	public static final String OPERATORINTERVENTIONEXCEPTIONS = "OperatorInterventionExceptions";
	/** */
	public static final String OPERATORTEXT = "OperatorText";
	/** */
	public static final String OPIMISSING = "OPIMissing";
	/** */
	public static final String OPITYPE = "OPIType";
	/** */
	public static final String OPIVERSION = "OPIVersion";
	/** */
	public static final String OPTIMIZE = "Optimize";
	/** */
	public static final String OPTION = "Option";
	/** */
	public static final String OPTIONALCOMBINEDTYPES = "OptionalCombinedTypes";
	/** */
	public static final String ORD = "Ord";
	/** */
	public static final String ORDER = "Order";
	/** */
	public static final String ORDEREDAMOUNT = "OrderedAmount";
	/** */
	public static final String ORDERQUANTITY = "OrderQuantity";
	/** */
	public static final String ORDEXPRESSION = "OrdExpression";
	/** */
	public static final String ORDID = "OrdID";
	/** */
	public static final String ORDRESET = "OrdReset";
	/** */
	public static final String ORDSCONSUMED = "OrdsConsumed";
	/** */
	public static final String ORGANIZATION = "Organization";
	public static final String ORGANIZATIONNAME = "OrganizationName";
	/** */
	public static final String ORIENTATION = "Orientation";
	/** */
	public static final String ORIGINALRESOLUTION = "OriginalResolution";
	/** */
	public static final String OSVERSION = "OSVersion";
	/** */
	public static final String OUTERCOREDIAMETER = "OuterCoreDiameter";
	/** */
	public static final String OUTERMOSTSHINGLING = "OutermostShingling";
	/** */
	public static final String OUTPUTBIN = "OutputBin";
	/** */
	public static final String OUTPUTCOLORSPACE = "OutputColorSpace";
	/** */
	public static final String OUTPUTINTENTCOLORSPACE = "OutputIntentColorSpace";
	/** */
	public static final String OUTPUTINTENTSTANDARD = "OutputIntentStandard";
	/** */
	public static final String OUTPUTPREFERENCESSUBFOLDER = "OutputPreferencesSubFolder";
	/** */
	public static final String OUTPUTRESOLUTION = "OutputResolution";
	/** */
	public static final String OUTPUTSIZE = "OutputSize";
	/** */
	public static final String OUTPUTTYPE = "OutputType";
	/** */
	public static final String OUTSIDEBOX = "OutsideBox";
	/** */
	public static final String OUTSIDEGAIN = "OutsideGain";
	/** */
	public static final String OUTSIDEGUTTER = "OutsideGutter";
	/** */
	public static final String OVERFOLD = "Overfold";
	/** */
	public static final String OVERFOLDSIDE = "OverfoldSide";
	/** */
	public static final String OVERHANG = "Overhang";
	/** */
	public static final String OVERHANGOFFSET = "OverhangOffset";
	/** */
	public static final String OVERLAP = "Overlap";
	/** */
	public static final String OVERPRINTBLACKLINEART = "OverPrintBlackLineArt";
	/** */
	public static final String OVERPRINTBLACKTEXT = "OverPrintBlackText";
	/** */
	public static final String OVERPRINTFLAG = "OverprintFlag";
	/** */
	public static final String OVERPRINTMODE = "OverPrintMode";
	/** */
	public static final String OVERWRITEPOLICY = "OverwritePolicy";
	/** */
	public static final String OWNERSHIP = "Ownership";

	/** */
	public static final String PACKAGING = "Packaging";
	/** */
	public static final String PAGE = "Page";
	/** */
	public static final String PAGEBOXTYPE = "PageBoxType";
	/** */
	public static final String PAGECOPIES = "PageCopies";
	/** */
	public static final String PAGEDELIVERY = "PageDelivery";
	/** */
	public static final String PAGEDIMENSION = "PageDimension";
	/** */
	public static final String PAGEDISTRIBUTIONSCHEME = "PageDistributionScheme";
	/** */
	public static final String PAGEFORMAT = "PageFormat";
	/** */
	public static final String PAGEHASOPTIONALCONTENT = "PageHasOptionalContent";
	/** */
	public static final String PAGEHASUNKNOWNOBJECTS = "PageHasUnknownObjects";
	/** */
	public static final String PAGEINDEX = "PageIndex";
	/** */
	public static final String PAGELABEL = "PageLabel";
	/** */
	public static final String PAGELABELPREFIX = "PageLabelPrefix";
	/** */
	public static final String PAGELABELSUFFIX = "PageLabelSuffix";
	/** */
	public static final String PAGELIST = "PageList";
	/** */
	public static final String PAGELISTINDEX = "PageListIndex";
	/** */
	public static final String PAGENAMES = "PageNames";
	/** */
	public static final String PAGENUMBER = "PageNumber";
	/** */
	public static final String PAGEORDER = "PageOrder";
	/** */
	public static final String PAGEPLACEMENTNAME = "PagePlacementName";
	/** */
	public static final String PAGERANGE = "PageRange";
	/** */
	public static final String PAGEREFS = "PageRefs";
	/** */
	public static final String PAGES = "Pages";
	/** */
	public static final String PAGESCALINGFACTOR = "PageScalingFactor";
	/** */
	public static final String PAGESET = "PageSet";
	/** */
	public static final String PAGESHAVESAMEORIENTATION = "PagesHaveSameOrientation";
	/** */
	public static final String PAGESPAGENUMBER = "PagesPageNumber";
	/** */
	public static final String PAGESTATUS = "PageStatus";
	/** */
	public static final String PAGETAGS = "PageTags";
	/** */
	public static final String PALLETMAXHEIGHT = "PalletMaxHeight";
	/** */
	public static final String PALLETMAXWEIGHT = "PalletMaxWeight";
	/** */
	public static final String PALLETQUANTITY = "PalletQuantity";
	/** */
	public static final String PALLETSIZE = "PalletSize";
	/** */
	public static final String PALLETTYPE = "PalletType";
	/** */
	public static final String PALLETWRAPPING = "PalletWrapping";
	/** */
	public static final String PARAMS = "Params";
	/** */
	public static final String PARENTFOLIO = "ParentFolio";
	/** */
	public static final String PARENTJOBID = "ParentJobID";
	/** */
	public static final String PARENTJOBPARTID = "ParentJobPartID";
	/** */
	public static final String PARSEDSCCOMMENTS = "ParseDSCComments";
	/** */
	public static final String PARSEDSCCOMMENTSFORDOCINFO = "ParseDSCCommentsForDocInfo";
	/** */
	public static final String PARTIDKEYS = "PartIDKeys";
	/** */
	public static final String PARTUSAGE = "PartUsage";
	/** */
	public static final String PARTVERSION = "PartVersion";
	/** */
	public static final String PASSED = "Passed";
	/** */
	public static final String PASSTHROUGHJPEGIMAGES = "PassThroughJPEGImages";
	/** */
	public static final String PASSWORD = "Password";
	public static final String PATCHUSAGE = "PatchUsage";
	public static final String PATH = "Path";
	/** */
	public static final String PATTERN = "Pattern";
	/** */
	public static final String PDFVERSION = "PDFVersion";
	/** */
	public static final String PDFX1ACHECK = "PDFX1aCheck";
	/** */
	public static final String PDFX3CHECK = "PDFX3Check";
	/** */
	public static final String PDFXBLEEDBOXTOTRIMBOXOFFSET = "PDFXBleedBoxToTrimBoxOffset";
	/** */
	public static final String PDFXCHECK = "PDFXCheck";
	/** */
	public static final String PDFXCOMPLIANTPDFONLY = "PDFXCompliantPDFOnly";
	/** */
	public static final String PDFXNOTRIMBOXERROR = "PDFXNoTrimBoxError";
	/** */
	public static final String PDFXOUTPUTCONDITION = "PDFXOutputCondition";
	/** */
	public static final String PDFXOUTPUTINTENTPROFILE = "PDFXOutputIntentProfile";
	/** */
	public static final String PDFXREGISTRYNAME = "PDFXRegistryName";
	/** */
	public static final String PDFXSETBLEEDBOXTOMEDIABOX = "PDFXSetBleedBoxToMediaBox";
	/** */
	public static final String PDFXTRAPPED = "PDFXTrapped";
	/** */
	public static final String PDFXTRIMBOXTOMEDIABOXOFFSET = "PDFXTrimBoxToMediaBoxOffset";
	/** */
	public static final String PDFXVERSION = "PDFXVersion";
	/** */
	public static final String PDLOBJECTTYPE = "PDLObjectType";
	/** */
	public static final String PDLTYPE = "PDLType";
	/** */
	public static final String PDLVERSION = "PDLVersion";
	/** */
	public static final String PERCENTAGE = "Percentage";
	/** */
	public static final String PERCENTAGES = "Percentages";
	/** */
	public static final String PERCENTCOMPLETED = "PercentCompleted";
	/** */
	public static final String PERFECTINGMODULE = "PerfectingModule";
	/** */
	public static final String PERSISTENT = "Persistent";
	/** */
	public static final String PERSONALID = "PersonalID";
	/** */
	public static final String PHASEAMOUNT = "PhaseAmount";
	/** */
	public static final String PHASESTARTTIME = "PhaseStartTime";
	/** */
	public static final String PHASEWASTE = "PhaseWaste";
	/** */
	public static final String PHONETICFIRSTNAME = "PhoneticFirstName";
	/** */
	public static final String PHONETICLASTNAME = "PhoneticLastName";
	/** */
	public static final String PHYSICALSECTION = "PhysicalSection";
	/** */
	public static final String PICKUP = "Pickup";
	/** */
	public static final String PIPEID = "PipeID";
	/** */
	public static final String PIPEPARTIDKEYS = "PipePartIDKeys";
	/** */
	public static final String PIPEPAUSE = "PipePause";
	/** */
	public static final String PIPEPROTOCOL = "PipeProtocol";
	/** */
	public static final String PIPERESUME = "PipeResume";
	/** */
	public static final String PIPEURL = "PipeURL";
	/** */
	public static final String PITCH = "Pitch";
	/** */
	public static final String PIXELDEPTH = "PixelDepth";
	/** */
	public static final String PIXELHEIGHT = "PixelHeight";
	/** */
	public static final String PIXELSKIP = "PixelSkip";
	/** */
	public static final String PIXELWIDTH = "PixelWidth";
	/** */
	public static final String PLATELAYOUT = "PlateLayout";
	public static final String PLATEPOSITION = "PlatePosition";
	public static final String PLATETECHNOLOGY = "PlateTechnology";
	public static final String PLATETYPE = "PlateType";
	public static final String PLATEUSAGE = "PlateUsage";
	/** */
	public static final String POLARITY = "Polarity";
	public static final String POLARITYCHANGE = "PolarityChange";
	public static final String POLICY = "Policy";
	public static final String POOL = "Pool";
	/** */
	public static final String POSITION = "Position";
	public static final String POSITIONORD = "PositionOrd";
	public static final String POSITIONPOLICY = "PositionPolicy";
	public static final String POSITIONX = "PositionX";
	public static final String POSITIONY = "PositionY";
	/** */
	public static final String POSTALCODE = "PostalCode";
	/** */
	public static final String POSTBAKETEMP = "PostBakeTemp";
	/** */
	public static final String POSTBAKETIME = "PostBakeTime";
	/** */
	public static final String POSTBOX = "PostBox";
	/** */
	public static final String POSTCOMPRESSIONENCODING = "PostCompressionEncoding";
	/** */
	public static final String POSTER = "Poster";
	/** */
	public static final String POSTEROVERLAP = "PosterOverlap";
	/** */
	public static final String POSTEXPOSETIME = "PostExposeTime";
	/** */
	public static final String POWDER = "Powder";
	/** */
	public static final String POWERONTIME = "PowerOnTime";
	/** */
	public static final String PRECOMPRESSIONINDIVIUALENCODING = "PreCompressionIndividualEncoding";
	/** */
	public static final String PREDICTOR = "Predictor";
	/** */
	public static final String PREFERRED = "Preferred";
	/** */
	public static final String PREFERREDFONT = "PreferredFont";
	/** */
	public static final String PREFLIGHTACTIONLIST = "PreflightActionList";
	/** */
	public static final String PREFLIGHTOUTPUT = "PreflightOutput";
	/** */
	public static final String PREFLIGHTPROFILE = "PreflightProfile";
	/** */
	public static final String PREFLIGHTRULE = "PreflightRule";
	/** */
	public static final String PREFLIGHTSTATUS = "PreflightStatus";
	/** */
	public static final String PREFLIGHTTOOL = "PreflightTool";
	/** */
	public static final String PREFLIGHTTOOLVERSION = "PreflightToolVersion";
	/** */
	public static final String PREHEATTEMP = "PreHeatTemp";
	/** */
	public static final String PREHEATTIME = "PreHeatTime";
	/** */
	public static final String PREPRINTED = "PrePrinted";
	/** */
	public static final String PRESENTATIONDIRECTION = "PresentationDirection";
	/** */
	public static final String PRESENTATIONURL = "PresentationURL";
	/** */
	public static final String PRESENTHWRELATION = "PresentHWRelation";
	/** */
	public static final String PRESENTLENGTH = "PresentLength";
	/** */
	public static final String PRESENTREGEXP = "PresentRegExp";
	/** */
	public static final String PRESENTROTATEMOD = "PresentRotateMod";
	/** */
	public static final String PRESENTSHIFT = "PresentShift";
	/** */
	public static final String PRESENTTRANSFORMS = "PresentTransforms";
	/** */
	public static final String PRESENTVALUE = "PresentValue";
	/** */
	public static final String PRESENTVALUEDURATIONLIST = "PresentValueDurationList";
	/** */
	public static final String PRESENTVALUELIST = "PresentValueList";
	/** */
	public static final String PRESENTVALUEMAX = "PresentValueMax";
	/** */
	public static final String PRESENTVALUEMIN = "PresentValueMin";
	/** */
	public static final String PRESENTVALUEMOD = "PresentValueMod";
	/** */
	public static final String PRESENTX = "PresentX";
	/** */
	public static final String PRESENTXYRELATION = "PresentXYRelation";
	/** */
	public static final String PRESENTY = "PresentY";
	/** */
	public static final String PRESENTZ = "PresentZ";
	/** */
	public static final String PRESERVEBLACK = "PreserveBlack";
	/** */
	public static final String PRESERVECOPYPAGE = "PreserveCopyPage";
	/** */
	public static final String PRESERVEEPSINFO = "PreserveEPSInfo";
	/** */
	public static final String PRESERVEHALFTONEINFO = "PreserveHalftoneInfo";
	/** */
	public static final String PRESERVEOPICOMMENTS = "PreserveOPIComments";
	/** */
	public static final String PRESERVEOVERPRINTSETTINGS = "PreserveOverprintSettings";
	/** */
	public static final String PRESTACKAMOUNT = "PreStackAmount";
	/** */
	public static final String PRESTACKMETHOD = "PreStackMethod";
	/** */
	public static final String PREVIEWFILETYPE = "PreviewFileType";
	/** */
	public static final String PREVIEWTYPE = "PreviewType";
	/** */
	public static final String PREVIEWUSAGE = "PreviewUsage";
	/** */
	public static final String PREVIEWUSAGES = "PreviewUsages";
	/** */
	public static final String PREVQUEUEENTRYID = "PrevQueueEntryID";
	/** */
	public static final String PRICE = "Price";
	/** */
	public static final String PRINTABLEAREA = "PrintableArea";
	/** */
	public static final String PRINTCONDITION = "PrintCondition";
	/** */
	public static final String PRINTCONDITIONNAME = "PrintConditionName";
	/** */
	public static final String PRINTERFONTSSUBFOLDER = "PrinterFontsSubFolder";
	/** */
	public static final String PRINTINGTECHNOLOGY = "PrintingTechnology";
	/** */
	public static final String PRINTINGTYPE = "PrintingType";
	/** */
	public static final String PRINTPASS = "PrintPass";
	/** */
	public static final String PRINTPDFANNOTATIONS = "PrintPDFAnnotations";
	/** */
	public static final String PRINTQUALITY = "PrintQuality";
	/** */
	public static final String PRINTTRAPANNOTATIONS = "PrintTrapAnnotations";
	/** */
	public static final String PRIORITY = "Priority";
	/** */
	public static final String PROCESSCOLORMODEL = "ProcessColorModel";
	/** */
	public static final String PROCESSUSAGE = "ProcessUsage";
	/** */
	public static final String PRODUCER = "Producer";
	/** */
	public static final String PRODUCT = "Product";
	public static final String PRODUCTID = "ProductID";
	public static final String PRODUCTIONAMOUNT = "ProductionAmount";
	public static final String PRODUCTIONCOUNTER = "ProductionCounter";
	public static final String PRODUCTIONPATHID = "ProductionPathID";
	public static final String PRODUCTIONTYPE = "ProductionType";
	public static final String PRODUCTPART = "ProductPart";
	public static final String PRODUCTTYPE = "ProductType";
	public static final String PRODUCTTYPEDETAILS = "ProductTypeDetails";
	public static final String PRODUCTVERSION = "ProductVersion";
	/** */
	public static final String PROGRESSIONORDER = "ProgressionOrder";
	/** */
	public static final String PROJECTID = "ProjectID";
	/** */
	public static final String PROOF = "Proof";
	/** */
	public static final String PROOFNAME = "ProofName";
	/** */
	public static final String PROOFQUALITY = "ProofQuality";
	/** */
	public static final String PROOFRENDERINGINTENT = "ProofRenderingIntent";
	/** */
	public static final String PROOFTARGET = "ProofTarget";
	/** */
	public static final String PROOFTYPE = "ProofType";
	/** */
	public static final String PROPERTY = "Property";
	/** */
	public static final String PROPERTYLIST = "PropertyList";
	/** */
	public static final String PSFONTNAME = "PSFontName";
	/** */
	public static final String PSLEVEL = "PSLevel";
	/** */
	public static final String PULLOUTVALUE = "PullOutValue";
	/** */
	public static final String PUNCH = "Punch";
	/** */
	public static final String PUNCHTYPE = "PunchType";
	/** */
	public static final String PURPOSE = "Purpose";
	/** */
	public static final String PURPOSEDETAILS = "PurposeDetails";

	/** */
	public static final String QFACTOR = "QFactor";
	public static final String QUALITYCBASE = "QualityBase";
	public static final String QUALITYCONTROLMETHODS = "QualityControlMethods";
	public static final String QUANTTABLE = "QuantTable";
	/** */
	public static final String QUERY = "Query";
	/** */
	public static final String QUEUEENTRYDETAILS = "QueueEntryDetails";
	/** */
	public static final String QUEUEENTRYID = "QueueEntryID";
	/** */
	public static final String QUEUEINFO = "QueueInfo";
	/** */
	public static final String QUEUESIZE = "QueueSize";
	/** */
	public static final String QUEUEURL = "QueueURL";

	/** */
	public static final String RANGE = "Range";
	/** */
	public static final String RATIO = "Ratio";
	/** */
	public static final String RAWALIAS = "RawAlias";
	/** */
	public static final String RAWNAME = "RawName";
	/** */
	public static final String RAWNAMES = "RawNames";
	/** */
	public static final String READERPAGECOUNT = "ReaderPageCount";
	/** */
	public static final String REASON = "Reason";
	/** */
	public static final String REASONDETAILS = "ReasonDetails";
	/** */
	public static final String RECEIVERURL = "ReceiverURL";
	/** */
	public static final String RECOMMENDATION = "Recommendation";
	/** */
	public static final String RECORDS = "Records";
	/** */
	public static final String RECYCLED = "Recycled";
	/** */
	public static final String RECYCLEDPERCENTAGE = "RecycledPercentage";
	/** */
	public static final String REF = "ref"; // important: lower case "r", only
	// "ref" is an attribute name
	// see JDFConstants.REF for "Ref" as part of a name
	/** */
	public static final String REFERENCEEDGE = "ReferenceEdge";
	/** */
	public static final String REFID = "refID";
	/** */
	public static final String REGEXP = "RegExp";
	/** */
	public static final String REGION = "Region";
	/** */
	public static final String REGISTRATION = "Registration";
	/** */
	public static final String RELATEDCOMMANDS = "RelatedCommands";
	/** */
	public static final String RELATEDJOBID = "RelatedJobID";
	/** */
	public static final String RELATEDJOBPARTID = "RelatedJobPartID";
	/** */
	public static final String RELATIVEBOX = "RelativeBox";
	/** */
	public static final String RELATIVEHEIGHT = "RelativeHeight";
	/** */
	public static final String RELATIVESIZE = "RelativeSize";
	/** */
	public static final String RELATIVESTARTPOSITION = "RelativeStartPosition";
	/** */
	public static final String RELATIVETRAVEL = "RelativeTravel";
	/** */
	public static final String RELATIVEWIDTH = "RelativeWidth";
	/** */
	public static final String RELATIVEWORKINGPATH = "RelativeWorkingPath";
	/** */
	public static final String RELATIVEWORKINGPATTERN = "RelativeWorkingPattern";
	/** */
	public static final String RELIEFTHICKNESS = "ReliefThickness";
	/** */
	public static final String REMOTEPIPEENDPAUSE = "RemotePipeEndPause";
	/** */
	public static final String REMOTEPIPEENDRESUME = "RemotePipeEndResume";
	/** */
	public static final String RENDERINGINTENT = "RenderingIntent";
	/** */
	public static final String REPEATPOLICY = "RepeatPolicy";
	/** */
	public static final String REPEATSTEP = "RepeatStep";
	/** */
	public static final String REPEATTIME = "RepeatTime";
	/** */
	public static final String REPLACEFIELD = "ReplaceField";
	/** */
	public static final String REPLACEMENTCOLORANTNAME = "ReplacementColorantName";
	/** */
	public static final String REPORTATTR = "ReportAttr";
	/** */
	public static final String REQUESTQUALITY = "RequestQuality";
	/** */
	public static final String REQUIRED = "Required";
	/** */
	public static final String RESEND = "Resend";
	/** */
	public static final String RESOLUTION = "Resolution";
	/** */
	public static final String RESOLUTIONREDUCTIONSTRATEGY = "ResolutionReductionStrategy";
	/** */
	public static final String RESOURCEDETAILS = "ResourceDetails";
	/** */
	public static final String RESOURCEID = "ResourceID";
	/** */
	public static final String RESOURCENAME = "ResourceName";
	/** */
	public static final String RESOURCETYPE = "ResourceType";
	/** */
	public static final String RESOURCEUPDATE = "ResourceUpdate";
	/** */
	public static final String RESOURCEUSAGE = "ResourceUsage";
	/** */
	public static final String RESOURCEWEIGHT = "ResourceWeight";
	/** */
	public static final String RESPONSEURL = "ResponseURL";
	/** */
	public static final String RESTORETIME = "RestoreTime";
	/** */
	public static final String RESTRICTIONS = "Restrictions";
	/** */
	public static final String RESTRICTEDCONTENTOBJECTS = "RestrictedContentObjects";
	/** */
	public static final String RESTTIME = "RestTime";
	/** */
	public static final String RETRYPOLICY = "RetryPolicy";
	/** */
	public static final String RETURNCODE = "ReturnCode";
	/** */
	public static final String RETURNJMF = "ReturnJMF";
	/** */
	public static final String RETURNLIST = "ReturnList";
	/** */
	public static final String RETURNTIME = "ReturnTime";
	/** */
	public static final String RETURNURL = "ReturnURL";
	/** */
	public static final String REVERSEPAGENUMBER = "ReversePageNumber";
	public static final String RGB = "RGB";
	public static final String RGBGRAY2BLACK = "RGBGray2Black";
	/** */
	public static final String RGBGRAY2BLACKTHRESHOLD = "RGBGray2BlackThreshold";
	/** */
	public static final String RIBBONCOLOR = "RibbonColor";
	/** */
	public static final String RIBBONCOLORDETAILS = "RibbonColorDetails";
	/** */
	public static final String RIBBONEND = "RibbonEnd";
	/** */
	public static final String RIBBONNAME = "RibbonName";
	/** */
	public static final String RINGDIAMETER = "RingDiameter";
	/** */
	public static final String RINGMECHANIC = "RingMechanic";
	/** */
	public static final String RINGSHAPE = "RingShape";
	/** */
	public static final String RINGSYSTEM = "RingSystem";
	/** */
	public static final String RIVETSEXPOSED = "RivetsExposed";
	/** */
	public static final String ROLES = "Roles";
	/** */
	public static final String ROLLCUT = "RollCut";
	/** */
	public static final String ROLLDIAMETER = "RollDiameter";
	/** */
	public static final String ROTATE = "Rotate";
	/** */
	public static final String ROTATED = "Rotated";
	/** */
	public static final String ROTATEMOD = "RotateMod";
	/** */
	public static final String ROTATEPOLICY = "RotatePolicy";
	/** */
	public static final String ROTATION = "Rotation";
	/** */
	public static final String ROTATIONPOLICY = "RotationPolicy";
	/** */
	public static final String ROUNDING = "Rounding";
	/** */
	public static final String ROUTE = "Route";
	/** */
	public static final String ROWS = "Rows";
	/** */
	public static final String ROWSPERSTRIP = "RowsPerStrip";
	/** */
	public static final String RREF = "rRef";
	/** */
	public static final String RREFS = "rRefs";
	/** */
	public static final String RREFSOVERWRITTEN = "rRefsOverwritten";
	/** */
	public static final String RREFSROCOPIED = "rRefsROCopied";
	/** */
	public static final String RREFSRWCOPIED = "rRefsRWCopied";
	/** */
	public static final String RSUBREF = "rSubRef";
	/** */
	public static final String RUN = "Run";
	public static final String RUNINDEX = "RunIndex";
	public static final String RUNPAGE = "RunPage";
	public static final String RUNPAGERANGE = "RunPageRange";
	public static final String RUNSET = "RunSet";
	public static final String RUNTAG = "RunTag";
	public static final String RUNTAGS = "RunTags";

	public static final String SAMPLE = "Sample";
	public static final String SAMPLEBACKING = "SampleBacking";
	public static final String SAMPLEINTERVAL = "SampleInterval";
	/** */
	public static final String SCALE = "Scale";
	/** */
	public static final String SCALING = "Scaling";
	/** */
	public static final String SCALINGORIGIN = "ScalingOrigin";
	/** */
	public static final String SCHEMALOCATION = "schemaLocation";
	/** */
	public static final String SCOPE = "Scope";
	/** */
	public static final String SCREEN = "Screen";
	/** */
	public static final String SCREENFONTSSUBFOLDER = "ScreenFontsSubFolder";
	/** */
	public static final String SCREENINGFAMILY = "ScreeningFamily";
	/** */
	public static final String SCREENINGTYPE = "ScreeningType";
	/** */
	public static final String SCREENRULING = "ScreenRuling";
	/** */
	public static final String SCREENSHAPE = "ScreenShape";
	/** */
	public static final String SEALING = "Sealing";
	/** */
	public static final String SEALINGTEMPERATURE = "SealingTemperature";
	/** */
	public static final String SEARCHDEPTH = "SearchDepth";
	/** */
	public static final String SECTIONINDEX = "SectionIndex";
	/** */
	public static final String SECTIONLIST = "SectionList";
	/** */
	public static final String SECUREJMFURL = "SecureJMFURL";
	/** */
	public static final String SEGMENTATION = "Segmentation";
	/** */
	public static final String SELECT = "Select";
	/** */
	public static final String SENDERID = "SenderID";
	/** */
	public static final String SEPARATION = "Separation";
	/** */
	public static final String SEPARATIONFLAG = "SeparationFlag";
	/** */
	public static final String SEPARATIONLIST = "SeparationList";
	/** */
	public static final String SEPARATIONNAMETAG = "SeparationNameTag";
	/** */
	public static final String SERIALNUMBER = "SerialNumber";
	/** */
	public static final String SERVICELEVEL = "ServiceLevel";
	/** */
	public static final String SETCOPIES = "SetCopies";
	/** */
	public static final String SETDOCINDEX = "SetDocIndex";
	/** */
	public static final String SETINDEX = "SetIndex";
	/** */
	public static final String SETLEVEL = "SetLevel";
	/** */
	public static final String SETNAMES = "SetNames";
	/** */
	public static final String SETORD = "SetOrd";
	/** */
	public static final String SETPAGESIZE = "SetPageSize";
	/** */
	public static final String SETREF = "SetRef";
	/** */
	public static final String SETRUNINDEX = "SetRunIndex";
	/** */
	public static final String SETS = "Sets";
	/** */
	public static final String SETSHEETINDEX = "SetSheetIndex";
	/** */
	public static final String SETSPLITBY = "SetSplitBy";
	/** */
	public static final String SETTAGS = "SetTags";
	/** */
	public static final String SETTINGSPOLICY = "SettingsPolicy";
	/** */
	public static final String SETUP = "Setup";
	/** */
	public static final String SETUPDURATION = "SetupDuration";
	/** */
	public static final String SETUPPROCSETS = "SetupProcsets";
	/** */
	public static final String SEVERITY = "Severity";
	/** */
	public static final String SEWINGPATTERN = "SewingPattern";
	/** */
	public static final String SHADINGTYPE = "ShadingType";
	/** */
	public static final String SHAPE = "Shape";
	/** */
	public static final String SHAPEDEPTH = "ShapeDepth";
	/** */
	public static final String SHAPETYPE = "ShapeType";
	/** */
	public static final String SHEETCOLLATE = "SheetCollate";
	/** */
	public static final String SHEETCOUNT = "SheetCount";
	/** */
	public static final String SHEETCOUNTRESET = "SheetCountReset";
	/** */
	public static final String SHEETFORMAT = "SheetFormat";
	/** */
	public static final String SHEETHEIGHT = "SheetHeight";
	/** */
	public static final String SHEETINDEX = "SheetIndex";
	/** */
	public static final String SHEETLAY = "SheetLay";
	/** */
	public static final String SHEETNAME = "SheetName";
	/** */
	public static final String SHEETNAMEFORMAT = "SheetNameFormat";
	/** */
	public static final String SHEETNAMETEMPLATE = "SheetNameTemplate";
	/**
	 * @deprecated
	 */
	/** */
	public static final String SHEETOCCURRENCE = "SheetOccurrence";
	@Deprecated
	/** */
	public static final String SHEETOCCURENCE = SHEETOCCURRENCE;
	/** */
	public static final String SHEETOFFSET = "SheetOffset";
	/** */
	public static final String SHEETPART = "SheetPart";
	/** */
	public static final String SHEETSIDES = "SheetSides";
	/** */
	public static final String SHEETTYPE = "SheetType";
	/** */
	public static final String SHEETUSAGE = "SheetUsage";
	/** */
	public static final String SHEETWIDTH = "SheetWidth";
	/** */
	public static final String SHIFT = "Shift";
	/** */
	public static final String SHIFTBACK = "ShiftBack";
	/** */
	public static final String SHIFTFRONT = "ShiftFront";
	/** */
	public static final String SHIFTX = "ShiftX";
	/** */
	public static final String SHIFTXSIDE1 = "ShiftXSide1";
	/** */
	public static final String SHIFTXSIDE2 = "ShiftXSide2";
	/** */
	public static final String SHIFTY = "ShiftY";
	/** */
	public static final String SHIFTYSIDE1 = "ShiftYSide1";
	/** */
	public static final String SHIFTYSIDE2 = "ShiftYSide2";
	/** */
	public static final String SHORTVALUE = "ShortValue";
	/** */
	public static final String SHOWLIST = "ShowList";
	/** */
	public static final String SHRINKINDEX = "ShrinkIndex";
	/** */
	public static final String SHRINKINGMETHOD = "ShrinkingMethod";
	/** */
	public static final String SHRINKTOFIT = "ShrinkToFit";
	/** */
	public static final String SHUTDOWNTYPE = "ShutDownType";
	/** */
	public static final String SIDE = "Side";
	/** */
	public static final String SIDELINEEPS = "SidelineEPS";
	/** */
	public static final String SIDELINEFONTS = "SidelineFonts";
	/** */
	public static final String SIDELINEIMAGES = "SidelineImages";
	/** */
	public static final String SIDES = "Sides";
	/** */
	public static final String SIGNAL = "Signal";
	/** */
	public static final String SIGNALTYPE = "SignalType";
	/** */
	public static final String SIGNALTYPES = "SignalTypes";
	/** */
	public static final String SIGNATURENAME = "SignatureName";
	/** */
	public static final String SIZE = "Size";
	/** */
	public static final String SIZEPOLICY = "SizePolicy";
	/** */
	public static final String SKIPPAGE = "SkipPage";
	/** */
	public static final String SLEEVEINTERLOCK = "SleeveInterlock";
	/** */
	public static final String SLIDINGTRAPLIMIT = "SlidingTrapLimit";
	/** */
	public static final String SMOOTHNESS = "Smoothness";
	/** */
	public static final String SORTAMOUNT = "SortAmount";
	/** */
	public static final String SORTED = "Sorted";
	/** */
	public static final String SORTING = "Sorting";
	/** */
	public static final String SOURCEBLEEDBOX = "SourceBleedBox";
	/** */
	public static final String SOURCECLIPBOX = "SourceClipBox";
	/** */
	public static final String SOURCECLIPPATH = "SourceClipPath";
	/** */
	public static final String SOURCECS = "SourceCS";
	/** */
	public static final String SOURCECSS = "SourceCSs";
	/** */
	public static final String SOURCEDEVICEID = "SourceDeviceID";
	public static final String SOURCEFREQUENCY = "SourceFrequency";
	/** */
	public static final String SOURCEMEDIABOX = "SourceMediaBox";
	/** */
	public static final String SOURCENAME = "SourceName";
	/** */
	public static final String SOURCEOBJECTS = "SourceObjects";
	/** */
	public static final String SOURCERENDERINGINTENT = "SourceRenderingIntent";
	/** */
	public static final String SOURCERIBBON = "SourceRibbon";
	/** */
	public static final String SOURCESHEET = "SourceSheet";
	/** */
	public static final String SOURCETRIMBOX = "SourceTrimBox";
	/** */
	public static final String SOURCEWEB = "SourceWeb";
	/** */
	public static final String SOURCEWORKSTYLE = "SourceWorkStyle";
	/** */
	public static final String SPAN = "Span";
	/** */
	public static final String SPAWNID = "SpawnID";
	/** */
	public static final String SPAWNIDS = "SpawnIDs";
	/** */
	public static final String SPAWNSTATUS = "SpawnStatus";
	/** */
	public static final String SPECIALINK = "SpecialInk";
	/** */
	public static final String SPECIFICYIELD = "SpecificYield";
	public static final String SPECTRALRESOLUTION = "SpectralResolution";
	public static final String SPECTRUM = "Spectrum";
	public static final String SPEED = "Speed";
	/** */
	public static final String SPINE = "Spine";
	public static final String SPINEBOARDWIDTH = "SpineBoardWidth";
	public static final String SPINECOLOR = "SpineColor";
	public static final String SPINECOLORDETAILS = "SpineColorDetails";
	public static final String SPINETHICKNESS = "SpineThickness";
	public static final String SPINEWIDTH = "SpineWidth";
	/** */
	public static final String SPLITDOCUMENTS = "SplitDocuments";
	/** */
	public static final String SPOTFUNCTION = "SpotFunction";
	public static final String SPREADTYPE = "SpreadType";
	public static final String SRGB = "sRGB";
	/** */
	public static final String STACKAMOUNT = "StackAmount";
	/** */
	public static final String STACKCOMPRESSION = "StackCompression";
	/** */
	public static final String STACKDEPTH = "StackDepth";
	/** */
	public static final String STAGGERCOLUMNS = "StaggerColumns";
	/** */
	public static final String STAGGERCONTINUOUS = "StaggerContinuous";
	/** */
	public static final String STAGGERROWS = "StaggerRows";
	/** */
	public static final String STANDARD = "Standard";
	/** */
	public static final String STANDARDAMOUNT = "StandardAmount";
	/** */
	public static final String STAPLESHAPE = "StapleShape";
	/** */
	public static final String START = "Start";
	/** */
	public static final String STARTOFFSET = "StartOffset";
	/** */
	public static final String STARTPAGE = "StartPage";
	/** */
	public static final String STARTPOSITION = "StartPosition";
	/** */
	public static final String STARTTIME = "StartTime";
	/** */
	public static final String STARTVALUE = "StartValue";
	/** */
	public static final String STATIONAMOUNT = "StationAmount";
	/** */
	public static final String STATIONNAME = "StationName";
	/** */
	public static final String STATUS = "Status";
	/** */
	public static final String STATUSDETAILS = "StatusDetails";
	/** */
	public static final String STATUSLIST = "StatusList";
	/** */
	public static final String STEP = "Step";
	/** */
	public static final String STEPDOCS = "StepDocs";
	/** */
	public static final String STEPLIMIT = "StepLimit";
	/** */
	public static final String STEPREPEAT = "StepRepeat";
	/** */
	public static final String STITCHFROMFRONT = "StitchFromFront";
	/** */
	public static final String STITCHINGPOSITION = "StitchingPosition";
	/** */
	public static final String STITCHINGREFERENCEEDGE = "StitchingReferenceEdge";
	/** */
	public static final String STITCHORIGIN = "StitchOrigin";
	/** */
	public static final String STITCHPOSITIONS = "StitchPositions";
	/** */
	public static final String STITCHTYPE = "StitchType";
	/** */
	public static final String STITCHWIDTH = "StitchWidth";
	/** */
	public static final String STOCKTYPE = "StockType";
	/** */
	public static final String STORAGEEVENT = "StorageEvent";
	/** */
	public static final String STORAGEPERIOD = "StoragePeriod";
	/** */
	public static final String STRAPCOLOR = "StrapColor";
	/** */
	public static final String STRAPPINGTYPE = "StrappingType";
	/** */
	public static final String STRAPPOSITIONS = "StrapPositions";
	/** */
	public static final String STREET = "Street";
	/** */
	public static final String STRINGVALUE = "StringValue";
	/** */
	public static final String STRIPBRAND = "StripBrand";
	/** */
	public static final String STRIPCOLOR = "StripColor";
	/** */
	public static final String STRIPCOLORDETAILS = "StripColorDetails";
	/** */
	public static final String STRIPLENGTH = "StripLength";
	/** */
	public static final String STRIPMARKDETAILS = "StripMarkDetails";
	/** */
	public static final String STRIPMATERIAL = "StripMaterial";
	/** */
	public static final String STRIPTYPE = "StripType";
	/** */
	public static final String STROKEALTERNATECOLORSPACE = "StrokeAlternateColorSpace";
	/** */
	public static final String STROKECOLORNAME = "StrokeColorName";
	/** */
	public static final String STROKECOLORSPACE = "StrokeColorSpace";
	/** */
	public static final String STROKECOLORTYPE = "StrokeColorType";
	/** */
	public static final String STROKEOVERPRINTFLAG = "StrokeOverprintFlag";
	/** */
	public static final String STROKESHADINGTYPE = "StrokeShadingType";
	/** */
	public static final String STROKETHICKNESS = "StrokeThickness";
	/** */
	public static final String SUBJECT = "Subject";
	/** */
	public static final String SUBMISSIONTIME = "SubmissionTime";
	/** */
	public static final String SUBMITPOLICY = "SubmitPolicy";
	/** */
	public static final String SUBMODULEINDEX = "SubModuleIndex";
	/** */
	public static final String SUBRUN = "SubRun";
	/** */
	public static final String SUBSCRIBED = "Subscribed";
	/** */
	public static final String SUBSETFONTS = "SubsetFonts";
	/** */
	public static final String SUPPRESSCENTER = "SuppressCenter";
	/** */
	public static final String SUPPRESSROTATE = "SuppressRotate";
	/** */
	public static final String SURFACECONTENTSBOX = "SurfaceContentsBox";
	/** */
	public static final String SURFACECOUNT = "SurfaceCount";

	/** */
	public static final String TABBANKS = "TabBanks";
	/** */
	public static final String TABCOUNT = "TabCount";
	/** */
	public static final String TABEDGE = "TabEdge";
	/** */
	public static final String TABEXTENSIONDISTANCE = "TabExtensionDistance";
	/** */
	public static final String TABOFFSET = "TabOffset";
	/** */
	public static final String TABSETCOLLATIONORDER = "TabSetCollationOrder";
	/** */
	public static final String TABSPERBANK = "TabsPerBank";
	/** */
	public static final String TABWIDTH = "TabWidth";
	/** */
	public static final String TAGNUMBER = "TagNumber";
	/** */
	public static final String TAGTYPE = "TagType";
	/** */
	public static final String TARGETROUTE = "TargetRoute";
	/** */
	public static final String TEETHPERDIMENSION = "TeethPerDimension";
	/** */
	public static final String TEMPERATURE = "Temperature";
	/** */
	public static final String TEMPLATE = "Template";
	/** */
	public static final String TEMPLATEID = "TemplateID";
	/** */
	public static final String TEMPLATETYPE = "TemplateType";
	/** */
	public static final String TEMPLATEVERSION = "TemplateVersion";
	/** */
	public static final String TESTREF = "TestRef";
	/** */
	public static final String TEXTBLACKLEVEL = "TextBlackLevel";
	/** */
	public static final String TEXTSIZE = "TextSize";
	/** */
	public static final String TEXTSIZETHRESHOLD = "TextSizeThreshold";
	/** */
	public static final String TEXTURE = "Texture";
	/** */
	public static final String THICKNESS = "Thickness";
	/** */
	public static final String THREADBRAND = "ThreadBrand";
	/** */
	public static final String THREADLENGTH = "ThreadLength";
	/** */
	public static final String THREADMATERIAL = "ThreadMaterial";
	/** */
	public static final String THREADPOSITIONS = "ThreadPositions";
	/** */
	public static final String THREADSTITCHWIDTH = "ThreadStitchWidth";
	/** */
	public static final String THREADTHICKNESS = "ThreadThickness";
	/** */
	public static final String TIES = "Ties";
	/** */
	public static final String TIGHTBACKING = "TightBacking";
	/** */
	public static final String TILEID = "TileID";
	/** */
	public static final String TILESIZE = "TileSize";
	/** */
	public static final String TIME = "Time";
	/** */
	public static final String TIMEINTERVAL = "TimeInterval";
	/** */
	public static final String TIMESTAMP = "TimeStamp";
	/** */
	public static final String TINT = "Tint";
	/** */
	public static final String TITLE = "Title";
	/** */
	public static final String TO = "To";
	/** */
	public static final String TOBOX = "ToBox";
	/** */
	public static final String TOLERANCE = "Tolerance";
	/** */
	public static final String TOLERANCEBLACK = "ToleranceBlack";
	/** */
	public static final String TOLERANCECYAN = "ToleranceCyan";
	/** */
	public static final String TOLERANCEDOTGAIN = "ToleranceDotGain";
	/** */
	public static final String TOLERANCEMAGENTA = "ToleranceMagenta";
	/** */
	public static final String TOLERANCEYELLOW = "ToleranceYellow";
	/** */
	public static final String TOOLAMOUNT = "ToolAmount";
	/** */
	public static final String TOOLID = "ToolID";
	/** */
	public static final String TOOLTYPE = "ToolType";
	/** */
	public static final String TOPBRAND = "TopBrand";
	/** */
	public static final String TOPCOLOR = "TopColor";
	/** */
	public static final String TOPCOLORDETAILS = "TopColorDetails";
	/** */
	public static final String TOPEXCESS = "TopExcess";
	/** */
	public static final String TOPFOLDIN = "TopFoldIn";
	/** */
	public static final String TOPLENGTH = "TopLength";
	/** */
	public static final String TOTALAMOUNT = "TotalAmount";
	/** */
	public static final String TOTALDIMENSIONS = "TotalDimensions";
	/** */
	public static final String TOTALDURATION = "TotalDuration";
	/** */
	public static final String TOTALPRODUCTIONCOUNTER = "TotalProductionCounter";
	/** */
	public static final String TOTALVOLUME = "TotalVolume";
	/** */
	public static final String TOTALWEIGHT = "TotalWeight";
	/** */
	public static final String TRACKINGID = "TrackingID";
	/** */
	public static final String TRANSACTIONID = "TransactionID";
	/** */
	public static final String TRANSFER = "Transfer";
	/** */
	public static final String TRANSFERCURVE = "TransferCurve";
	/** */
	public static final String TRANSFERFUNCTION = "TransferFunction";
	/** */
	public static final String TRANSFERFUNCTIONINFO = "TransferFunctionInfo";
	/** */
	public static final String TRANSFERFUNCTIONSOURCE = "TransferFunctionSource";
	/** */
	public static final String TRANSFORMATION = "Transformation";
	/** */
	public static final String TRANSFORMATIONCONTEXT = "TransformationContext";
	/** */
	public static final String TRANSFORMS = "Transforms";
	/** */
	public static final String TRANSPARENCYFLAG = "TransparencyFlag";
	/** */
	public static final String TRANSPARENCYRENDERINGQUALITY = "TransparencyRenderingQuality";
	/** */
	public static final String TRAPCOLORSCALING = "TrapColorScaling";
	/** */
	public static final String TRAPENDSTYLE = "TrapEndStyle";
	/** */
	public static final String TRAPJOINSTYLE = "TrapJoinStyle";
	/** */
	public static final String TRAPNETANNOTATIONPDFX = "TrapnetAnnotationPDFX";
	/** */
	public static final String TRAPPEDKEY = "TrappedKey";
	/** */
	public static final String TRAPPING = "Trapping";
	/** */
	public static final String TRAPPINGTYPE = "TrappingType";
	/** */
	public static final String TRAPPLACEMENT = "TrapPlacement";
	/** */
	public static final String TRAPWIDTH = "TrapWidth";
	/** */
	public static final String TRAPWIDTHY = "TrapWidthY";
	/** */
	public static final String TRAPZONE = "TrapZone";
	/** */
	public static final String TRAVEL = "Travel";
	/** */
	public static final String TRAVELINTERVAL = "TravelInterval";
	/** */
	public static final String TRIMCLIPPATH = "TrimClipPath";
	/** */
	public static final String TRIMCOVER = "TrimCover";
	/** */
	public static final String TRIMCTM = "TrimCTM";
	/** */
	public static final String TRIMFACE = "TrimFace";
	/** */
	public static final String TRIMFOOT = "TrimFoot";
	/** */
	public static final String TRIMHEAD = "TrimHead";
	/** */
	public static final String TRIMMINGOFFSET = "TrimmingOffset";
	/** */
	public static final String TRIMMINGTYPE = "TrimmingType";
	/** */
	public static final String TRIMBOTTOM = "TrimBottom";
	/** */
	public static final String TRIMBOX = "TrimBox";
	/** */
	public static final String TRIMLEFT = "TrimLeft";
	/** */
	public static final String TRIMRIGHT = "TrimRight";
	/** */
	public static final String TRIMTOP = "TrimTop";
	/** */
	public static final String TRIMSIZE = "TrimSize";
	/** */
	public static final String TRUE = "true";
	/** */
	public static final String TTAST42 = "TTasT42";
	/** */
	public static final String TUCKED = "Tucked";
	/** */
	public static final String TYPE = "Type";
	/** */
	public static final String TYPEAMOUNT = "TypeAmount";
	/** */
	public static final String TYPEEXPRESSION = "TypeExpression";
	/** */
	public static final String TYPEOCCURRENCENUM = "TypeOccurrenceNum";
	/** */
	@Deprecated
	public static final String TYPEOCCURENCENUM = TYPEOCCURRENCENUM;
	/** */
	public static final String TYPEORDER = "TypeOrder";
	/** */
	public static final String TYPES = "Types";

	/** */
	public static final String UCRANDBGINFO = "UCRandBGInfo";
	/** */
	public static final String UID = "UID";
	/** */
	public static final String UNCOMPRESSED = "Uncompressed";
	/** */
	public static final String UNDERCOLORREMOVAL = "UnderColorRemoval";
	/** */
	public static final String UNDERLAYS = "UnderLays";
	/** */
	public static final String UNIT = "Unit";
	/** */
	public static final String UNITTYPE = "UnitType";
	/** */
	public static final String UNKNOWN = "Unknown";
	/** */
	public static final String UNTIL = "Until";
	/** */
	public static final String UPC = "UPC";
	/** */
	public static final String UPDATED = "Update";
	/** */
	public static final String UPDATEDSTATUS = "UpdatedStatus";
	/** */
	public static final String UPDATEGRANULARITY = "UpdateGranularity";
	/** */
	public static final String UPDATEID = "UpdateID";
	/** */
	public static final String UPDATEIDS = "UpdateIDs";
	/** */
	public static final String UPDATEMETHOD = "UpdateMethod";
	/** */
	public static final String UPPERRIBBONNAME = "UpperRibbonName";
	/** */
	public static final String URL = "URL";
	/** */
	public static final String URLSCHEMES = "URLSchemes";
	/** */
	public static final String URLTYPE = "URLType";
	/** */
	public static final String URLTYPES = "URLTypes";
	/** */
	public static final String USAGE = "Usage";
	/** */
	public static final String USEARTIFICIALTEXTEFFECT = "UseArtificialTextEffect";
	/** */
	public static final String USEBLEEDS = "UseBleeds";
	/** */
	public static final String USEDEFAULTFONT = "UseDefaultFont";
	/** */
	public static final String USEFONTALIASNAMES = "UseFontAliasNames";
	/** */
	public static final String USEFONTEMULATION = "UseFontEmulation";
	/** */
	public static final String USEPDLALTERNATECS = "UsePDLAlternateCS";
	/** */
	public static final String USEPROLOGUE = "UsePrologue";
	/** */
	public static final String USERDISPLAY = "UserDisplay";
	/** */
	public static final String USERFILENAME = "UserFileName";
	/** */
	public static final String USERID = "UserID";
	/** */
	public static final String USERMEDIATYPE = "UserMediaType";
	/** */
	public static final String USERTEXT = "UserText";

	/** */
	public static final String VACUUM = "Vacuum";
	/** */
	public static final String VALUE = "Value";
	/** */
	public static final String VALUEDURATIONLIST = "ValueDurationList";
	/** */
	public static final String VALUEFORMAT = "ValueFormat";
	/** */
	public static final String VALUELIST = "ValueList";
	/** */
	public static final String VALUEMOD = "ValueMod";
	/** */
	public static final String VALUERANGE = "ValueRange";
	/** */
	public static final String VALUETEMPLATE = "ValueTemplate";
	/** */
	public static final String VALUEUSAGE = "ValueUsage";
	/** */
	public static final String VARNISHAREA = "VarnishArea";
	/** */
	public static final String VARNISHMETHOD = "VarnishMethod";
	/** */
	public static final String VERSION = "Version";
	/** */
	public static final String VERTICALCREEP = "VerticalCreep";
	/** */
	public static final String VERTICALFITPOLICY = "VerticalFitPolicy";
	/** */
	public static final String VIEWBINDER = "ViewBinder";
	/** */
	public static final String VISIBLELENGTH = "VisibleLength";
	/** */
	public static final String VSAMPLES = "VSamples";

	/** */
	public static final String WARNINGCOUNT = "WarningCount";
	/** */
	public static final String WASMARKED = "WasMarked";
	/** */
	public static final String WASTE = "Waste";
	/** */
	public static final String WATCHURL = "WatchURL";
	/** */
	public static final String WEBCELLALIGNMENT = "WebCellAlignment";
	/** */
	public static final String WEBNAME = "WebName";
	/** */
	public static final String WEBPRODUCT = "WebProduct";
	/** */
	public static final String WEBSETUP = "WebSetup";
	/** */
	public static final String WEIGHT = "Weight";
	/** */
	public static final String WHITEBASE = "WhiteBase";
	/** */
	public static final String WHITEISZERO = "WhiteIsZero";
	/** */
	public static final String WIDTH = "Width";
	/** */
	public static final String WINDINGRESULT = "WindingResult";
	/** */
	public static final String WIREBRAND = "WireBrand";
	/** */
	public static final String WIREGAUGE = "WireGauge";
	/** */
	public static final String WORKINGDIRECTION = "WorkingDirection";
	/** */
	public static final String WORKINGLENGTH = "WorkingLength";
	/** */
	public static final String WORKINGLIST = "WorkingList";
	/** */
	public static final String WORKINGPATH = "WorkingPath";
	/** */
	public static final String WORKSTEPID = "WorkStepID";
	/** */
	public static final String WORKSTYLE = "WorkStyle";
	/** */
	public static final String WORKTYPE = "WorkType";
	/** */
	public static final String WORKTYPEDETAILS = "WorkTypeDetails";
	/** */
	public static final String WRAPPAGES = "WrapPages";
	/** */
	public static final String WRAPPEDQUANTITY = "WrappedQuantity";
	/** */
	public static final String WRAPPERWEIGHT = "WrapperWeight";
	/** */
	public static final String WRAPPINGKIND = "WrappingKind";
	/** */
	public static final String WRAPPINGMATERIAL = "WrappingMaterial";

	/** */
	public static final String X = "X";
	/** */
	public static final String XCELLS = "XCells";
	/** */
	public static final String XMLNS = "xmlns";
	/** */
	public static final String XMLNSURI = "http://www.w3.org/2000/xmlns/";
	/** */
	public static final String XMLNSXSI = "xmlns:xsi";
	/** */
	public static final String XOFFSET = "XOffset";
	/** */
	public static final String XPATH = "XPath";
	/** */
	public static final String XPOSITION = "XPosition";
	/** */
	public static final String XSI = "xsi";
	/** */
	public static final String XSITYPE = "xsi:type";
	/** */
	public static final String XSIURI = "http://www.w3.org/2001/XMLSchema-instance";
	/** */
	public static final String XYRELATION = "XYRelation";

	/** */
	public static final String Y = "Y";
	/** */
	public static final String YCELLS = "YCells";
	/** */
	public static final String YPOSITION = "YPosition";

	/** */
	public static final String Z = "Z";
	/** */
	public static final String ZONEHEIGHT = "ZoneHeight";
	/** */
	public static final String ZONES = "Zones";
	/** */
	public static final String ZONESETTINGSX = "ZoneSettingsX";
	/** */
	public static final String ZONESETTINGSY = "ZoneSettingsY";
	/** */
	public static final String ZONESY = "ZonesY";
	/** */
	public static final String ZONEWIDTH = "ZoneWidth";

	// JDF 1.6 + 1.7 additions
	public static final String TYPEDETAILS = "TypeDetails";
	public static final String BOXTYPE = "BoxType";
	public static final String BOXTYPEDETAILS = "BoxTypeDetails";
	public static final String FACE = "Face";
	public static final String FIRSTENTRY = "FirstEntry";
	public static final String SHAPETYPEDETAILS = "ShapeTypeDetails";
	public static final String LASTENTRY = "LastEntry";
	public static final String MAXPRIORITY = "MaxPriority";
	public static final String MINPRIORITY = "MinPriority";
	public static final String MAXQUEUESIZE = "MaxQueueSize";
	public static final String PREFLIGHTLEVEL = "PreflightLevel";
	public static final String PROCSTEPSGROUP = "ProcStepsGroup";
	public static final String PROCSTEPSTYPE = "ProcStepsType";
	public static final String RELATEDPROJECTID = "RelatedProjectID";
	public static final String TOOLNAME = "ToolName";
	public static final String ADDRESSUSAGE = "AddressUsage";
	public static final String BACKSPECTRUM = "BackSpectrum";
	public static final String BOTTLING = "Bottling";
	public static final String CIVICNUMBER = "CivicNumber";
	public static final String SECUREURL = "SecureURL";
	public static final String DELIVERYID = "DeliveryID";
	public static final String DOCPAGES = "DocPages";
	public static final String EARLIESTDURATION = "EarliestDuration";
	public static final String REQUIREDDURATION = "RequiredDuration";
	public static final String FINISHEDPAGES = "FinishedPages";
	public static final String JOBIDS = "JobIDs";
	public static final String MEASUREMENTMODE = "MeasurementMode";
	public static final String REFERENCE = "Reference";
	public static final String REPLACEAFTER = "ReplaceAfter";
	public static final String REPLACEBEFORE = "ReplaceBefore";
	public static final String REVISION = "Revision";
}
