/*
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2020 The International Cooperation for the Integration of Processes in Prepress, Press and Postpress (CIP4). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the
 * distribution.
 *
 * 3. The end-user documentation included with the redistribution, if any, must include the following acknowledgment: "This product includes software developed by the The International Cooperation for
 * the Integration of Processes in Prepress, Press and Postpress (www.cip4.org)" Alternately, this acknowledgment mrSubRefay appear in the software itself, if and wherever such third-party
 * acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of Processes in Prepress, Press and Postpress" must not be used to endorse or promote products derived from this software
 * without prior written permission. For written permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4", nor may "CIP4" appear in their name, without prior writtenrestartProcesses() permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE INTERN }ATIONAL COOPERATION FOR THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIrSubRefAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. ====================================================================
 *
 * } This software consists of voluntary contributions made by many individuals on behalf of the The International Cooperation for the Integration of Processes in Prepress, Press and Postpress and was
 * originally based on software restartProcesses() copyright (c) 1999-2001, Heidelberger Druckmaschinen AG copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the Integration of Processes in Prepress, Press and Postpress , please see <http://www.cip4.org/>.
 *
 */

/**
 *
 * COPYRIGHT Heidelberger Druckmaschinen AG, 1999-2002 ALL RIGHTS RESERVED
 *
 * @author Thomas Kurberg
 *
 *         Last changes created 2002-02-04 02-07-2002 JG - modified GetTarget to handle parts 02-07-2002 JG - added part handling 02-07-2002 JG - added OptionalElements 02-07-2002 JG - added InlineRef
 *         02-07-2002 JG - modified GetTarget for parts pointing to elements that are not 02-07-2002 JG - added DeleteRef 26-11-2002 Kai Mattern - Bugfix in InLineRef
 *
 */
package org.cip4.jdflib.core;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;

/**
 * @author Dr. Rainer Prosi, Heidelberger Druckmaschinen AG
 *
 *         before August 21, 2009
 */
public class JDFRefElement extends JDFElement
{
	private static final long serialVersionUID = 1L;

	private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];
	static
	{
		atrInfoTable[0] = new AtrInfoTable(AttributeName.RSUBREF, 0x44444433, AttributeInfo.EnumAttributeType.IDREF, null, null);
		atrInfoTable[1] = new AtrInfoTable(AttributeName.RREF, 0x22222222, AttributeInfo.EnumAttributeType.IDREF, null, null);
	}

	@Override
	protected AttributeInfo getTheAttributeInfo()
	{
		AttributeInfo ai = AttributeInfo.fixedMap.get("JDFRefElement");
		if (ai != null)
			return ai;
		ai = super.getTheAttributeInfo().updateReplace(atrInfoTable);
		AttributeInfo.fixedMap.put("JDFRefElement", ai);
		return ai;
	}

	private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[1];
	static
	{
		elemInfoTable[0] = new ElemInfoTable(ElementName.PART, 0x33333331);
	}

	@Override
	protected ElementInfo getTheElementInfo()
	{
		return super.getTheElementInfo().updateReplace(elemInfoTable);
	}

	/**
	 * Constructor for JDFRefElement
	 *
	 * @param myOwnerDocument
	 * @param qualifiedName
	 */
	public JDFRefElement(final CoreDocumentImpl myOwnerDocument, final String qualifiedName)
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * Constructor for JDFRefElement
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 */
	public JDFRefElement(final CoreDocumentImpl myOwnerDocument, final String myNamespaceURI, final String qualifiedName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * Constructor for JDFRefElement
	 *
	 * @param myOwnerDocument
	 * @param myNamespaceURI
	 * @param qualifiedName
	 * @param myLocalName
	 */
	public JDFRefElement(final CoreDocumentImpl myOwnerDocument, final String myNamespaceURI, final String qualifiedName, final String myLocalName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	/**
	 * test Part element existence
	 *
	 * @return
	 *
	 * @deprecated 060310 use inline hasChildElement(ElementName.PART, null);
	 */
	@Deprecated
	public boolean hasPart()
	{
		return this.hasChildElement(ElementName.PART, null);
	}

	/**
	 * Set attribute rRef
	 *
	 * @param value the value to set the attribute to
	 */
	public void setrRef(final String value)
	{
		setAttribute(JDFConstants.RREF, value, JDFConstants.EMPTYSTRING);
	}

	/**
	 * returns true if the name specified fits the node name of this
	 *
	 * @param nodeName the name of the node to test. may be either local or qualified
	 * @param nameSpaceURI the namespace of the node to test.
	 * @return true if ok
	 */
	@Override
	public boolean fitsName(final String nodeName, final String nameSpaceURI)
	{
		if (nodeName == null || nodeName.endsWith(JDFConstants.REF))
		{
			if (fitsName_KElement(nodeName, nameSpaceURI))
			{
				return true;
			}
		}
		else
		{
			// if this is a valid ResourceRef, it also fits
			if (fitsName_KElement(nodeName + JDFConstants.REF, nameSpaceURI))
			{
				return true;
			}
		}

		return false;
	}

	/**
	 * Get string attribute rRef
	 *
	 * @return String - the vaue of the attribute
	 */
	public String getrRef()
	{
		return getAttribute(JDFConstants.RREF, JDFConstants.EMPTYSTRING, JDFConstants.EMPTYSTRING);
	}

	/**
	 * Set attribute rSubRef
	 *
	 * @param value the value to set the attribute to
	 * @deprecated in JDF 1.2
	 */
	@Deprecated
	public void setrSubRef(final String value)
	{
		setAttribute(JDFConstants.RSUBREF, value, JDFConstants.EMPTYSTRING);
	}

	/**
	 * Get string attribute rSubRef
	 *
	 * @return String - the vaue of the attribute
	 */
	public String getrSubRef()
	{
		return getAttribute(JDFConstants.RSUBREF, JDFConstants.EMPTYSTRING, JDFConstants.EMPTYSTRING);
	}

	/**
	 *
	 * @see org.cip4.jdflib.core.JDFElement#isValid(org.cip4.jdflib.core.JDFElement.EnumValidationLevel)
	 */
	@Override
	public boolean isValid(final EnumValidationLevel level)
	{
		final boolean b = super.isValid(level);
		if (!b)
		{
			return false;
		}

		final JDFResource r = getTarget();

		if (r == null)
		{
			return false;
		}

		if (!getNodeName().equals(r.getRefString()))
		{
			return false;
		}

		if (!validResourcePosition())
		{
			return false;
		}

		// RunLists and physical resources may be referenced at the root or
		// intermediate nodes
		// if((r.getPartUsage() != JDFResource.EnumPartUsage.Explicit) &&
		// !r.isLeaf())
		// {
		// return false;
		// }

		return true;
	}

	// /////////////////////////////////////////////////////////////

	/**
	 * @return
	 */
	public boolean validResourcePosition()
	{
		return validResourcePosition(getTarget());
	}

	/**
	 * get the referenced target resource The resource's PartUsage is evaluated to correctly retrieve implicit or explicit partitions<br>
	 * may return null
	 *
	 * @return JDFResource - the reference target partition
	 */
	public JDFResource getTargetRoot()
	{
		if (hasAttribute(AttributeName.RSUBREF))
		{
			final String s = getrSubRef();
			final KElement subRef = getTarget_KElement(s, AttributeName.ID);

			if (subRef instanceof JDFResource)
			{
				return (JDFResource) subRef;
			}
			return null;
		}
		final JDFResource linkRoot = getLinkRoot(null);
		if (linkRoot != null && !getNodeName().equals(linkRoot.getRefString()))
		{
			return null;
		}

		return linkRoot;
	}

	/**
	 * get the referenced target resource The resource's PartUsage is evaluated to correctly retrieve implicit or explicit partitions<br>
	 * may return null
	 *
	 * overrides the deprecated method JDFElement.getTarget()
	 *
	 * @return JDFResource - the reference target partition
	 */
	@Override
	public JDFResource getTarget()
	{
		final JDFResource targetRoot = getTargetRoot();
		if (targetRoot == null)
		{
			return null;
		}

		final JDFAttributeMap partMap = getPartMap();
		if (partMap == null)
		{
			return targetRoot;
		}
		return targetRoot.getPartition(partMap, null);
	}

	/**
	 * Get element Part
	 *
	 * @return JDFPart - the element
	 */
	public JDFPart getPart()
	{
		return (JDFPart) getElement(ElementName.PART, JDFConstants.EMPTYSTRING, 0);
	}

	/**
	 * return the NodeName of the referenced resource
	 *
	 * @return the nodename of the referenced resource
	 */
	public String getRefNodeName()
	{
		final KElement target = getTargetRoot();
		if (target != null)
		{
			return target.getNodeName();
		}

		String nn = getNodeName();
		if (nn.endsWith(JDFConstants.REF))
		{
			nn = nn.substring(0, nn.length() - JDFConstants.REF.length());
			return nn;
		}

		return null;
	}

	/**
	 * return the Localname of the target
	 *
	 * @return
	 */
	public String getRefLocalName()
	{
		final KElement target = getTargetRoot();
		if (target != null)
		{
			return target.getLocalName();
		}

		String nn = getLocalName();
		if (nn.endsWith(JDFConstants.REF))
		{
			nn = nn.substring(0, nn.length() - JDFConstants.REF.length());
			return nn;
		}

		return null;
	}

	/**
	 * inline this refElement by replacing it with a copy of its target
	 *
	 * @return JDFElement - the newly created element
	 * @throws JDFException if no target exists
	 */
	public JDFElement inlineRef()
	{
		int i;
		final JDFResource targetRes = getTarget();
		if (targetRes == null)
		{
			throw new JDFException("inlineRef: inlining null " + getLocalName() + " rRef=" + getrRef());
		}
		final JDFResource newInline = (JDFResource) appendElement(targetRes.getNodeName(), null);

		// copy elements and attributes
		newInline.setAttributes(targetRes);
		final VElement v = targetRes.getChildElementVector(null, null, null, true, 0, false);

		for (i = 0; i < v.size(); i++)
		{
			newInline.copyElement(v.item(i), null);
		}

		newInline.cleanResourceAttributes();
		final VString partNames = targetRes.getPartIDKeys();

		for (i = 0; i < partNames.size(); i++)
		{
			newInline.removeAttribute(partNames.elementAt(i), null);
		}

		// replace this (the refElement) with newInline.
		// This effectively repositions newInline from the back to the original
		// position of this
		replaceElement(newInline);

		targetRes.deleteUnLinked();
		return newInline;
	}

	/**
	 * delete this refElement and it's target
	 *
	 * @param bCheckRefCount if true, check that no other element refers to the target before deleting<br>
	 *            if bCheckRefCount=false, the target is force deleted
	 * @return JDFElement the deleted targeelement
	 * @since 290502
	 */
	public JDFElement deleteRef(final boolean bCheckRefCount)
	{
		final JDFResource e = getTarget();
		if (e != null)
		{
			if (bCheckRefCount)
			{
				e.deleteUnLinked();
			}
			else
			{
				e.deleteNode();
			}
		}
		// now zapp myself
		return (JDFElement) deleteNode();
	}

	/**
	 * Method AppendPart.
	 *
	 * @return JDFPart
	 */
	public JDFPart appendPart()
	{
		return (JDFPart) appendElementN(ElementName.PART, 1, null);
	}

	/**
	 * get element JDFPart, create one if it doesn't exist
	 *
	 * @return JDFPart
	 */
	public JDFPart getCreatePart()
	{
		return (JDFPart) getCreateElement_KElement(ElementName.PART, null, 0);
	}

	/**
	 * @deprecated
	 */
	@Deprecated
	public void removePart()
	{
		removeChild(ElementName.PART, null, 0);
	}

	/**
	 * get part map vector
	 *
	 * @deprecated 060310 not more than one is allowed - use getPartMap
	 * @return VJDFAttributeMap: vector of attribute maps, one for each part
	 */
	@Deprecated
	@Override
	public VJDFAttributeMap getPartMapVector()
	{
		return new VJDFAttributeMap(getPartMap());
	}

	/**
	 * get part map
	 *
	 * @return JDFAttributeMap: the attribute maps, one for each part
	 */
	@Override
	public JDFAttributeMap getPartMap()
	{
		return super.getPartMap();
	}

	/**
	 * set all parts to those define in vParts
	 *
	 * @param mPart attribute map for the part to set
	 */
	@Override
	public void setPartMap(final JDFAttributeMap mPart)
	{
		super.setPartMap(mPart);
	}

	/**
	 * @deprecate 060310 - remove the part defined in mPart
	 * @param mPart attribute map for the part to remove
	 */
	@Override
	public void removePartMap(final JDFAttributeMap mPart)
	{
		super.removePartMap(mPart);
	}

	/**
	 * check whether the part defined in mPart is included
	 *
	 * @param mPart attribute map for the part to remove
	 * @return boolean - returns true if the part exists
	 */
	@Override
	public boolean hasPartMap(final JDFAttributeMap mPart)
	{
		return super.hasPartMap(mPart);
	}
}
