/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.Iterator;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.util.StringUtil;

public class AttributeReplacer
extends BaseElementWalker {
    protected JDFAttributeMap theMap;
    String elemRegExp;

    public AttributeReplacer(String attributeName, String newValue, String elementExpression) {
        super(new BaseWalkerFactory());
        this.theMap = new JDFAttributeMap(attributeName, newValue);
        this.elemRegExp = elementExpression;
    }

    public AttributeReplacer(JDFAttributeMap setMap, String elementExpression) {
        super(new BaseWalkerFactory());
        this.theMap = setMap;
        this.elemRegExp = elementExpression;
    }

    public void replace(KElement root) {
        this.walkTree(root, null);
    }

    public void setMap(JDFAttributeMap map) {
        this.theMap = map;
    }

    public class WalkDefault
    extends BaseWalker {
        public WalkDefault() {
            super(AttributeReplacer.this.getFactory());
        }
    }

    public class WalkAttributeReplacer
    extends WalkDefault {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            Iterator<String> it = AttributeReplacer.this.theMap.getKeyIterator();
            while (it.hasNext()) {
                String key = it.next();
                if (!e.hasAttribute(key)) continue;
                String value = AttributeReplacer.this.theMap.get(key);
                e.setAttribute(key, value, null);
            }
            return e;
        }

        @Override
        public boolean matches(KElement e) {
            return StringUtil.matchesSimple(e.getLocalName(), AttributeReplacer.this.elemRegExp);
        }
    }
}

