/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class IntentHelper
extends BaseXJDFHelper {
    static boolean bSpanAsAttribute = true;
    public static final String INTENT = "Intent";

    public IntentHelper(KElement intent) {
        this.theElement = intent;
    }

    public static boolean isIntentResource(KElement toCheck) {
        if (toCheck == null) {
            return false;
        }
        KElement parent = toCheck.getParentNode_KElement();
        if (parent == null) {
            return false;
        }
        return INTENT.equals(parent.getLocalName()) ? new IntentHelper(parent).getResource() == toCheck : false;
    }

    @Override
    public String toString() {
        return "IntentHelper: " + this.theElement;
    }

    public KElement getIntent() {
        return this.theElement;
    }

    public KElement getResource() {
        String name = this.theElement.getAttribute("Name", null, null);
        if (name != null) {
            return this.theElement.getElement(name);
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (e instanceof JDFPart || e instanceof JDFGeneralID || e instanceof JDFComment) continue;
            return e;
        }
        return null;
    }

    public KElement getCreateResource() {
        String name = this.theElement.getAttribute("Name", null, null);
        if (name != null) {
            return this.theElement.getCreateElement(name);
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (e instanceof JDFPart || e instanceof JDFGeneralID || e instanceof JDFComment) continue;
            return e;
        }
        return null;
    }

    public String getName() {
        KElement r;
        String name = this.theElement.getAttribute("Name", null, null);
        if (name == null && (r = this.getResource()) != null) {
            name = r.getLocalName();
            this.theElement.setAttribute("Name", name);
        }
        return name;
    }

    public void setSpan(String att, String val, String dataType) {
        KElement resource = this.getCreateResource();
        this.setSpan(resource, att, val, dataType);
    }

    public void setSpan(String att, String val) {
        this.setSpan(att, val, null);
    }

    public String getSpan(String spanPath) {
        KElement resource = this.getResource();
        if (resource == null) {
            return null;
        }
        String elem = StringUtil.removeToken(spanPath, -1, "/");
        if (elem != null) {
            resource = resource.getXPathElement(elem);
        }
        if (resource == null) {
            return null;
        }
        String spanName = StringUtil.token(spanPath, -1, "/");
        String s = resource.getAttribute(spanName, null, null);
        if (s == null) {
            s = resource.getXPathAttribute(spanName + "/@Actual", null);
        }
        return s;
    }

    public void setSpan(KElement resource, String spanPath, String val, String dataType) {
        String elem = StringUtil.removeToken(spanPath, -1, "/");
        if (elem != null) {
            resource = resource.getCreateXPathElement(elem);
        }
        if (resource == null) {
            return;
        }
        String spanName = StringUtil.token(spanPath, -1, "/");
        if (bSpanAsAttribute || dataType == null) {
            resource.setAttribute(spanName, val);
        } else {
            if (!dataType.endsWith("Span")) {
                dataType = dataType + "Span";
            }
            KElement span = resource.getCreateElement(dataType);
            span.setAttribute("Name", spanName);
            span.setAttribute("Actual", val);
        }
    }

    @Override
    public void cleanUp() {
    }

    public static boolean isSpanAsAttribute() {
        return bSpanAsAttribute;
    }

    public static void setSpanAsAttribute(boolean bSpanAsAttribute) {
        IntentHelper.bSpanAsAttribute = bSpanAsAttribute;
    }
}

