/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.List;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResLink;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;

public class WalkColorIntentResLink
extends WalkResLink {
    @Override
    protected List<KElement> setResource(JDFElement rl, JDFResource linkTarget, KElement xjdf) {
        List<KElement> v = super.setResource(rl, linkTarget, xjdf);
        KElement thecolorIntent = null;
        for (KElement e1 : v) {
            boolean both;
            JDFPart part = (JDFPart)e1.getElement("Part");
            KElement colorIntent = e1.getElement("ColorIntent");
            if (thecolorIntent == null) {
                thecolorIntent = colorIntent;
            }
            JDFAutoPart.EnumSide side = part == null ? JDFAutoPart.EnumSide.Front : part.getSide();
            boolean bl = both = part == null;
            if (thecolorIntent == null) continue;
            KElement surfaceColor = thecolorIntent.getCreateChildWithAttribute("SurfaceColor", "Surface", null, side.getName(), 0);
            this.fixNumColors(surfaceColor, colorIntent);
            if (part != null) {
                part.deleteNode();
            }
            surfaceColor.setAttributes(colorIntent.getAttributeMap());
            thecolorIntent.removeAttributes(null);
            surfaceColor.moveArray(colorIntent.getChildList(null, null), null);
            if (!both) continue;
            thecolorIntent.copyElement(surfaceColor, null).setAttribute("Surface", JDFAutoPart.EnumSide.Back.getName());
        }
        return v;
    }

    private void fixNumColors(KElement surfaceColor, KElement colorIntent) {
        int nCols = colorIntent.getIntAttribute("NumColors", null, -1);
        if (nCols >= 0) {
            String surface;
            KElement parentCI = surfaceColor.getParentNode_KElement();
            JDFXYPair xy = JDFXYPair.createXYPair(parentCI.getAttribute("NumColors"));
            if (xy == null) {
                xy = new JDFXYPair(0, 0);
            }
            if ("Both".equals(surface = surfaceColor.getAttribute("Surface")) || "Front".equals(surface)) {
                xy.setX(nCols);
            }
            if ("Both".equals(surface) || "Back".equals(surface)) {
                xy.setY(nCols);
            }
            parentCI.setAttribute("NumColors", xy.toString());
        }
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement e = super.walk(jdf, xjdf);
        return e;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && super.matches(toCheck) && "ColorIntentLink".equals(toCheck.getLocalName());
    }
}

