/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.auto.JDFAutoDevCaps;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.ifaces.IDeviceCapable;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFBasicPreflightTest;
import org.cip4.jdflib.resource.devicecapability.JDFDevCap;
import org.cip4.jdflib.resource.devicecapability.JDFDevCaps;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFIsPresentEvaluation;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.StringUtil;

public abstract class JDFEvaluation
extends JDFTerm
implements JDFBaseDataTypes {
    private static final long serialVersionUID = -1231679460732331896L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFEvaluation[ --> " + super.toString() + " ]";
    }

    @Override
    public final boolean fitsMap(JDFAttributeMap m) {
        JDFBasicPreflightTest basicPreflightTest = this.getBasicPreflightTest();
        if (basicPreflightTest == null) {
            return false;
        }
        String n = basicPreflightTest.getName();
        if (m.containsKey(n)) {
            String val = m.get(n);
            return this.fitsValue(val);
        }
        return false;
    }

    @Override
    public boolean fitsJDF(KElement jdf, KElement reportRoot) {
        KElement reportRootLocal = reportRoot;
        if (reportRootLocal != null) {
            reportRootLocal = reportRootLocal.appendElement(this.getLocalName());
        }
        boolean b = false;
        String xPath = this.getEvalXPath(jdf);
        if (xPath != null) {
            b = this.fitsPath(jdf, xPath, reportRootLocal);
        }
        if (reportRootLocal != null) {
            reportRootLocal.setAttribute("Value", b, null);
            reportRootLocal.setAttribute("CapXPath", this.getRefTargetNamePath());
            reportRootLocal.setAttribute("Name", this.getRefTargetName());
        }
        return b;
    }

    @Override
    public boolean fitsContext(KElement jdf) {
        return this.getEvalXPath(jdf) != null;
    }

    private boolean fitsPath(KElement e, String xPath, KElement reportRoot) {
        int posAtI;
        boolean b = false;
        KElement attr = null;
        String newPath = null;
        int posAt = xPath.lastIndexOf("@");
        int n = posAtI = posAt > 0 ? xPath.lastIndexOf("[@") : -1;
        if (posAt < 0 || posAt == posAtI + 1) {
            KElement pathElement = e.getXPathElement(xPath);
            b = this.fitsValue(pathElement);
            if (b && reportRoot != null) {
                if (pathElement != null) {
                    newPath = pathElement.buildXPath(null, 1);
                }
                attr = reportRoot.appendElement("TestedElement");
                attr.setAttribute("Name", StringUtil.token(xPath, -1, "/"));
            }
        } else {
            String attrVal = e.getXPathAttribute(xPath, null);
            b = this.fitsValue(attrVal);
            String attName = xPath.substring(posAt + 1);
            KElement pathElement = e.getXPathElement(xPath.substring(0, posAt));
            if (pathElement instanceof JDFResource) {
                JDFResource r;
                JDFResource root = r.getResourceRoot();
                for (r = (JDFResource)pathElement; r != root && !r.hasAttribute_KElement(attName, null, false); r = (JDFResource)r.getParentNode_KElement()) {
                }
                pathElement = r;
                newPath = pathElement.buildXPath(null, 1) + "/@" + attName;
            }
            if (newPath != null) {
                attrVal = e.getXPathAttribute(newPath, null);
            }
            b = this.fitsValue(attrVal);
            if (reportRoot != null) {
                attr = reportRoot.appendElement("TestedAttribute");
                attr.setAttribute("Name", attName);
                attr.setAttribute("Value", attrVal);
            }
        }
        if (attr != null) {
            attr.setAttribute("XPath", newPath);
        }
        return b;
    }

    public abstract boolean fitsValue(String var1);

    public boolean fitsValue(KElement elem) {
        return elem != null;
    }

    public JDFAutoBasicPreflightTest.EnumListType getListType() {
        JDFAbstractState state = this.getState();
        if (state != null) {
            return state.getListType();
        }
        JDFBasicPreflightTest basicPreflightTest = this.getBasicPreflightTest();
        return basicPreflightTest == null ? null : basicPreflightTest.getListType();
    }

    protected String getEvalXPath(KElement jdf) {
        VString tokens;
        String path;
        JDFElement dc;
        ICapabilityElement stateDC = this.getRefTarget();
        if (stateDC == null) {
            return null;
        }
        VString vPath = null;
        boolean bElement = false;
        String attName = null;
        if (stateDC instanceof JDFDevCap) {
            if (!(this instanceof JDFIsPresentEvaluation)) {
                return null;
            }
            bElement = true;
            dc = (JDFDevCap)stateDC;
            vPath = ((JDFDevCap)dc).getNamePathVector(true);
            if (vPath != null) {
                for (int i = 0; i < vPath.size(); ++i) {
                    path = vPath.get(i);
                    tokens = StringUtil.tokenize(path, "/", false);
                    if (tokens.size() != 3 || !tokens.get(1).equals("ResourcePool")) continue;
                    tokens.set(1, "ResourceLinkPool");
                    tokens.set(2, tokens.get(2) + "Link");
                    vPath.set(i, StringUtil.setvString(tokens, "/", null, null));
                }
            }
        } else if (stateDC instanceof JDFDevCaps) {
            if (!(this instanceof JDFIsPresentEvaluation)) {
                return null;
            }
            bElement = true;
            dc = (JDFDevCaps)stateDC;
            vPath = ((JDFDevCaps)dc).getNamePathVector();
            if (vPath != null) {
                for (int i = 0; i < vPath.size(); ++i) {
                    path = vPath.get(i);
                    tokens = StringUtil.tokenize(path, "/", false);
                    if (tokens.size() != 3 || !tokens.get(1).equals("ResourcePool")) continue;
                    tokens.set(1, "ResourceLinkPool");
                    String link = tokens.get(2) + "Link";
                    JDFResourceLink.EnumUsage lu = ((JDFAutoDevCaps)dc).getLinkUsage();
                    if (lu != null) {
                        link = link + "[@Usage=\"" + lu.getName() + "\"]";
                    }
                    tokens.set(2, link);
                    vPath.set(i, StringUtil.setvString(tokens, "/", null, null));
                }
            }
        } else {
            JDFAbstractState state = (JDFAbstractState)stateDC;
            if (state.getListType().equals((Object)JDFAutoBasicPreflightTest.EnumListType.Span)) {
                vPath = state.getNamePathVector(true);
                bElement = true;
            } else {
                KElement kdc = state.getParentNode_KElement();
                if (kdc instanceof IDeviceCapable) {
                    vPath = ((IDeviceCapable)((Object)kdc)).getNamePathVector();
                } else if (kdc instanceof ICapabilityElement) {
                    vPath = ((ICapabilityElement)((Object)kdc)).getNamePathVector();
                }
                attName = state.getName();
            }
        }
        if (vPath != null) {
            for (int i = 0; i < vPath.size(); ++i) {
                String xPath2;
                String xPath = vPath.get(i);
                int slash = xPath.length();
                String finalS = null;
                do {
                    if (!jdf.matchesPath(xPath2 = xPath.substring(0, slash), true)) continue;
                    finalS = "." + xPath.substring(slash);
                } while ((slash = xPath2.lastIndexOf("/")) >= 0 && finalS == null);
                if (finalS != null && !bElement) {
                    finalS = finalS + "/@" + attName;
                }
                if (finalS == null) continue;
                return finalS;
            }
        }
        return null;
    }

    public String getRefTargetNamePath() {
        ICapabilityElement e = this.getRefTarget();
        if (e instanceof JDFAbstractState) {
            return ((JDFAbstractState)e).getNamePath();
        }
        if (e instanceof JDFDevCap) {
            return ((JDFDevCap)e).getNamePath(true);
        }
        if (e instanceof JDFDevCaps) {
            return ((JDFDevCaps)e).getName();
        }
        return null;
    }

    public String getRefTargetName() {
        ICapabilityElement e = this.getRefTarget();
        if (e instanceof JDFAbstractState) {
            return ((JDFAbstractState)e).getName();
        }
        if (e instanceof JDFDevCap) {
            return ((JDFDevCap)e).getName();
        }
        if (e instanceof JDFDevCaps) {
            return ((JDFDevCaps)e).getName();
        }
        return null;
    }

    public void setRefTarget(JDFElement e) {
        JDFDeviceCap deviceCap = (JDFDeviceCap)this.getDeepParent("DeviceCap", 0);
        if (deviceCap == null) {
            throw new JDFException("setRefTarget, called in dangling evaluation");
        }
        if (!(e instanceof JDFAbstractState) && !(e instanceof JDFDevCap)) {
            throw new JDFException("setRefTarget, called for illegal target type");
        }
        String id = e.appendAnchor(null);
        this.setrRef(id);
    }

    public ICapabilityElement getRefTarget() {
        IDeviceCapable deviceCap = this.getDeviceCapable();
        if (deviceCap == null) {
            return null;
        }
        return deviceCap.getTargetCap(this.getrRef());
    }

    public JDFAbstractState getState() {
        ICapabilityElement ic = this.getRefTarget();
        if (ic instanceof JDFAbstractState) {
            return (JDFAbstractState)ic;
        }
        return null;
    }

    public void setrRef(String value) {
        this.setAttribute("rRef", value);
    }

    public String getrRef() {
        return this.getAttribute("rRef", null, "");
    }

    public void setPath(String value) {
        this.setAttribute("Path", value);
    }

    public String getPath() {
        return this.getAttribute("Path", null, "");
    }

    public JDFBasicPreflightTest getCreateBasicPreflightTest() {
        return (JDFBasicPreflightTest)this.getCreateElement("BasicPreflightTest", null, 0);
    }

    @Deprecated
    public JDFBasicPreflightTest getCreateBasicPreflightTest(int iSkip) {
        return (JDFBasicPreflightTest)this.getCreateElement("BasicPreflightTest", "", iSkip);
    }

    public JDFBasicPreflightTest getBasicPreflightTest() {
        return (JDFBasicPreflightTest)this.getElement("BasicPreflightTest", null, 0);
    }

    @Deprecated
    public JDFBasicPreflightTest getBasicPreflightTest(int iSkip) {
        return (JDFBasicPreflightTest)this.getElement("BasicPreflightTest", "", iSkip);
    }

    @Deprecated
    public JDFBasicPreflightTest appendBasicPreflightTest() {
        return (JDFBasicPreflightTest)this.appendElementN("BasicPreflightTest", 1, null);
    }

    public JDFBasicPreflightTest appendBasicPreflightTest(String testName) {
        JDFBasicPreflightTest pft = (JDFBasicPreflightTest)this.appendElementN("BasicPreflightTest", 1, null);
        if (pft == null) {
            return null;
        }
        if (testName != null) {
            pft.setName(testName);
        }
        return pft;
    }

    protected JDFXYPair getTolerance() {
        try {
            return new JDFXYPair(this.getAttribute("Tolerance", null, "0 0"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFEvaluation.getTolerance: Attribute Tolerance is not applicable to create JDFXYPair");
        }
    }

    static {
        JDFEvaluation.atrInfoTable[0] = new AtrInfoTable("rRef", 0x33333333L, AttributeInfo.EnumAttributeType.IDREF, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFEvaluation.elemInfoTable[0] = new ElemInfoTable("BasicPreflightTest", 0x33333333L);
    }
}

