/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFRectangleRange;
import org.cip4.jdflib.datatypes.JDFRectangleRangeList;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;

public class JDFRectangleState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFRectangleState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFRectangleState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFRectangleState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFRectangleState[ --> " + super.toString() + " ]";
    }

    public void setCurrentValue(JDFRectangle value) {
        this.setAttribute("CurrentValue", value.toString(), null);
    }

    public JDFRectangle getCurrentValue() {
        try {
            JDFRectangle r = new JDFRectangle(this.getAttribute("CurrentValue"));
            return r;
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFRectangleState.getCurrentValue: Attribute CURRENTVALUE is not capable to create JDFRectangle");
        }
    }

    public void setDefaultValue(JDFRectangle value) {
        this.setAttribute("DefaultValue", value.toString(), null);
    }

    public JDFRectangle getDefaultValue() {
        try {
            return new JDFRectangle(this.getAttribute("DefaultValue"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFRectangleState.getDefaultValue: Attribute DEFAULTVALUE is not capable to create JDFRectangle");
        }
    }

    public void setAllowedValueList(JDFRectangleRangeList value) {
        this.setAttribute("AllowedValueList", value.toString());
    }

    public JDFRectangleRangeList getAllowedValueList() {
        try {
            String attribute = this.getAttribute("AllowedValueList", null, null);
            return attribute == null ? null : new JDFRectangleRangeList(attribute);
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFRectangleState.getAllowedValueList: Attribute ALLOWEDVALUELIST is not capable to create JDFRectangleRangeList");
        }
    }

    public void setPresentValueList(JDFRectangleRangeList value) {
        this.setAttribute("PresentValueList", value.toString());
    }

    public JDFRectangleRangeList getPresentValueList() {
        if (this.hasAttribute("PresentValueList")) {
            try {
                return new JDFRectangleRangeList(this.getAttribute("PresentValueList"));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFRectangleState.getPresentValueList: Attribute PRESENTVALUELIST is not capable to create JDFRectangleRangeList");
            }
        }
        return this.getAllowedValueList();
    }

    public void setAllowedHWRelation(JDFElement.EnumXYRelation value) {
        this.setAttribute("AllowedHWRelation", value.getName(), null);
    }

    public JDFElement.EnumXYRelation getAllowedHWRelation() {
        return JDFElement.EnumXYRelation.getEnum(this.getAttribute("AllowedHWRelation", null, null));
    }

    public void setPresentHWRelation(JDFElement.EnumXYRelation value) {
        this.setAttribute("PresentHWRelation", value.getName(), null);
    }

    public JDFElement.EnumXYRelation getPresentHWRelation() {
        JDFElement.EnumXYRelation rel = JDFElement.EnumXYRelation.getEnum(this.getAttribute("PresentHWRelation", null, null));
        if (rel == null) {
            return this.getAllowedHWRelation();
        }
        return rel;
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFRectangleRangeList list;
        JDFRectangle rect;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        try {
            rect = new JDFRectangle(value);
        }
        catch (DataFormatException x) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new JDFRectangleRangeList();
            }
            list.append(rect);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new JDFRectangleRangeList();
            }
            list.append(rect);
            this.setPresentValueList(list);
        }
    }

    @Override
    public final boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (this.fitsListType(value)) {
            JDFRectangleRangeList rrl = null;
            try {
                rrl = new JDFRectangleRangeList(value);
            }
            catch (DataFormatException dfe) {
                return false;
            }
            int siz = rrl.size();
            for (int i = 0; i < siz; ++i) {
                boolean bFitsHW;
                JDFRectangle right;
                JDFRectangleRange range = (JDFRectangleRange)rrl.at(i);
                JDFRectangle left = range.getLeft();
                if (left.equals(right = range.getRight())) {
                    bFitsHW = this.fitsHWRelation(left, testlists);
                } else {
                    boolean bl = bFitsHW = this.fitsHWRelation(left, testlists) && this.fitsHWRelation(right, testlists);
                }
                if (bFitsHW) continue;
                return false;
            }
            return this.fitsValueList(rrl, testlists);
        }
        return false;
    }

    private final boolean fitsValueList(JDFRectangleRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFRectangleRangeList list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, list);
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            JDFRectangleRange range = (JDFRectangleRange)rangelist.at(i);
            if (list.isPartOfRange(range)) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsHWRelation(JDFRectangle rect, JDFBaseDataTypes.EnumFitsValue hwrelation) {
        JDFElement.EnumXYRelation relation = hwrelation.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedHWRelation() : this.getPresentHWRelation();
        if (relation == null) {
            return true;
        }
        double width = rect.getUrx() - rect.getLlx();
        double height = rect.getUry() - rect.getLly();
        return relation.evaluateXY(width, height, 1.0E-6, 1.0E-6);
    }

    private final boolean fitsCompleteList(JDFRectangleRangeList value, JDFRectangleRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFRectangleRangeList valueList = new JDFRectangleRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFRectangleRangeList value, JDFRectangleRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFRectangleRangeList value, JDFRectangleRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.RectangleEvaluation;
    }

    static {
        JDFRectangleState.atrInfoTable[0] = new AtrInfoTable("AllowedHWRelation", 0x33333311L, AttributeInfo.EnumAttributeType.XYRelation, null, null);
        JDFRectangleState.atrInfoTable[1] = new AtrInfoTable("AllowedValueList", 0x33333311L, AttributeInfo.EnumAttributeType.RectangleRangeList, null, null);
        JDFRectangleState.atrInfoTable[2] = new AtrInfoTable("CurrentValue", 0x33333311L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFRectangleState.atrInfoTable[3] = new AtrInfoTable("DefaultValue", 0x33333311L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFRectangleState.atrInfoTable[4] = new AtrInfoTable("PresentHWRelation", 0x33333311L, AttributeInfo.EnumAttributeType.XYRelation, null, null);
        JDFRectangleState.atrInfoTable[5] = new AtrInfoTable("PresentValueList", 0x33333311L, AttributeInfo.EnumAttributeType.RectangleRangeList, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFRectangleState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

