/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class DumpDir {
    private File baseDir = null;
    private static HashMap<File, AtomicInteger> listMap = new HashMap();
    private final int maxKeep = 666;
    protected final Log log = LogFactory.getLog(this.getClass());
    public boolean quiet = true;

    int increment() {
        AtomicInteger i = listMap.get(this.baseDir);
        return i.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumpDir(File dir) {
        this.baseDir = dir;
        this.baseDir.mkdirs();
        HashMap<File, AtomicInteger> hashMap = listMap;
        synchronized (hashMap) {
            AtomicInteger index = listMap.get(this.baseDir);
            if (index == null) {
                index = new AtomicInteger(0);
                listMap.put(this.baseDir, index);
            }
            String[] names = this.baseDir.list();
            int max = 0;
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    int l = names[i].length() > 9 ? StringUtil.parseInt(names[i].substring(1, 9), 0) : 0;
                    if (l < max) continue;
                    max = l + 1;
                }
            }
            index.set(max);
        }
    }

    public File getDir() {
        return this.baseDir;
    }

    @Deprecated
    public File newFile(String header) {
        return this.newFile(header, null);
    }

    public File newFile(String header, String ext) {
        int inc = this.increment();
        if (!this.quiet && inc % 1000 == 0) {
            this.log.info((Object)("jmf dump service " + this.baseDir + " - " + inc + " " + new JDFDate().getDateTime()));
        }
        String s = ext == null ? StringUtil.sprintf("m%08i.tmp", "" + inc) : StringUtil.sprintf("m%08i.%s.tmp", "" + inc + "," + ext);
        File f = FileUtil.getFileInDirectory(this.baseDir, new File(s));
        if (header != null) {
            this.newHeader(header, f, true);
        }
        this.cleanup(inc);
        return f;
    }

    @Deprecated
    public File newFileFromStream(String header, InputStream is) {
        return this.newFileFromStream(header, is, null);
    }

    public File newFileFromStream(String header, InputStream is, String ext) {
        File dump = this.newFile(null, ext);
        is = ByteArrayIOStream.getBufferedInputStream(is);
        OutputStream fs = this.newHeader(header, dump, false);
        if (fs != null) {
            try {
                if (is != null) {
                    IOUtils.copy((InputStream)is, (OutputStream)fs);
                }
                fs.flush();
                fs.close();
                if (is != null && is.markSupported()) {
                    is.reset();
                }
            }
            catch (IOException x) {
                this.log.error((Object)"error dumping dump stream", (Throwable)x);
            }
        }
        return dump;
    }

    private OutputStream newHeader(String header, File f, boolean bClose) {
        BufferedOutputStream fs = FileUtil.getBufferedOutputStream(f);
        if (header != null && fs != null) {
            try {
                ((OutputStream)fs).write(header.getBytes());
                ((OutputStream)fs).write("\n------ end of header ----!\n".getBytes());
                if (bClose) {
                    ((OutputStream)fs).flush();
                    ((OutputStream)fs).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(int inc) {
        if (inc % 42 == 0) {
            AtomicInteger atomicInteger = listMap.get(this.baseDir);
            synchronized (atomicInteger) {
                Object[] names = FileUtil.listFilesWithExtension(this.baseDir, "tmp");
                if (names != null && names.length > 666) {
                    Arrays.sort(names);
                    for (int i = 0; i < names.length - 666; ++i) {
                        Object f = names[i];
                        this.cleanupSingle((File)f);
                    }
                }
            }
        }
    }

    void cleanupSingle(File f) {
        if (f != null) {
            f.delete();
            String name = f.getName();
            name = UrlUtil.newExtension(name, "*");
            File[] dirnames = FileUtil.listFilesWithExpression(this.baseDir, name);
            if (dirnames != null) {
                for (File dir : dirnames) {
                    FileUtil.deleteAll(dir);
                }
            }
        }
    }

    public String toString() {
        return "DumpDir " + this.baseDir + " i=" + listMap.get(this.baseDir).get();
    }
}

