/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.ByteArrayIOFileStream;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.net.HTTPDetails;
import org.cip4.jdflib.util.net.ProxyUtil;

class URLWriter {
    static final Log log = LogFactory.getLog(URLWriter.class);
    private final String strUrl;
    private final ByteArrayIOStream stream;
    private final String method;
    private final String contentType;
    private final HTTPDetails details;
    private final IStreamWriter writer;
    private static int nLogged = 0;

    public String toString() {
        return "UrlWriter: " + this.method + " / " + this.contentType + " --> " + this.strUrl;
    }

    public URLWriter(String strUrl, IStreamWriter streamWriter, String method, String contentType, HTTPDetails details) {
        this.strUrl = strUrl;
        this.method = method;
        if (contentType == null) {
            contentType = "text/unknown";
        }
        this.contentType = StringUtil.token(contentType, 0, "\r\n");
        this.details = details;
        this.stream = this.getStream(streamWriter);
        this.writer = this.stream != null ? null : streamWriter;
    }

    public URLWriter(InputStream is, String strUrl, String method, String contentType, HTTPDetails details) {
        this.strUrl = strUrl;
        this.method = method;
        if (contentType == null) {
            contentType = "text/unknown";
        }
        this.contentType = StringUtil.token(contentType, 0, "\r\n");
        this.details = details;
        this.stream = is == null ? null : new ByteArrayIOFileStream(is, 1234567L);
        this.writer = null;
    }

    private ByteArrayIOStream getStream(IStreamWriter inWriter) {
        if (inWriter == null || UrlUtil.isFile(this.strUrl)) {
            return null;
        }
        ByteArrayIOFileStream bufStream = new ByteArrayIOFileStream(1234567L);
        try {
            inWriter.writeStream(bufStream);
        }
        catch (IOException e) {
            return null;
        }
        return bufStream;
    }

    public UrlPart writeToURL() {
        UrlPart urlPart = null;
        UrlPart fallBack = null;
        if (UrlUtil.isFile(this.strUrl)) {
            urlPart = this.writeFile();
        } else {
            URL url = UrlUtil.stringToURL(this.strUrl);
            URI uri = ProxyUtil.getHostURI(url);
            if (uri == null) {
                return null;
            }
            List<Proxy> list = ProxyUtil.getProxiesWithLocal(uri);
            for (Proxy proxy : list) {
                boolean bWantLog;
                urlPart = this.callProxy(proxy, bWantLog = list.size() == 1 || !proxy.equals(Proxy.NO_PROXY));
                if (urlPart == null) continue;
                int responseCode = urlPart.getResponseCode();
                if (UrlUtil.isReturnCodeOK(responseCode)) {
                    return urlPart;
                }
                if (UrlUtil.isRedirect(responseCode) && (this.details == null || this.details.getRedirect() < 42)) {
                    String newLocation = urlPart.getConnection().getHeaderField("Location");
                    if (StringUtil.isEmpty(newLocation) && UrlUtil.isHttp(this.strUrl)) {
                        newLocation = StringUtil.replaceToken(newLocation, 0, ":", "https");
                    }
                    if (newLocation == null) continue;
                    fallBack = urlPart;
                    ByteArrayIOStream.ByteArrayIOInputStream newInput = this.stream == null ? null : this.stream.getInputStream();
                    urlPart = new URLWriter(newInput, newLocation, this.method, this.contentType, HTTPDetails.getRedirect(this.details)).writeToURL();
                    if (urlPart == null) {
                        urlPart = fallBack;
                        continue;
                    }
                    if (!UrlUtil.isReturnCodeOK(urlPart.getResponseCode())) continue;
                    return urlPart;
                }
                fallBack = urlPart;
            }
        }
        return urlPart == null ? fallBack : urlPart;
    }

    private UrlPart writeFile() {
        File f = UrlUtil.urlToFile(this.strUrl);
        if (this.writer != null) {
            f = FileUtil.writeFile(this.writer, f);
        } else if (this.stream != null) {
            FileUtil.streamToFile((InputStream)this.stream.getInputStream(), f);
        }
        try {
            return new UrlPart(f);
        }
        catch (IOException x) {
            return null;
        }
    }

    private UrlPart callProxy(Proxy proxy, boolean bWantLog) {
        block5: {
            URL url = UrlUtil.stringToURL(this.strUrl);
            try {
                URLConnection urlConnection = url.openConnection(proxy);
                urlConnection.setConnectTimeout(UrlUtil.getConnectionTimeout());
                urlConnection.setRequestProperty("Connection", "keep-alive");
                urlConnection.setRequestProperty("Content-Type", this.contentType);
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpUrlConnection = (HttpURLConnection)urlConnection;
                    httpUrlConnection.setRequestMethod(this.method);
                    if (this.details != null) {
                        this.details.applyTo(httpUrlConnection);
                    }
                    this.output(httpUrlConnection);
                    return new UrlPart(httpUrlConnection);
                }
                if (UrlUtil.isFtp(this.strUrl)) {
                    return new UrlPart(urlConnection, false);
                }
            }
            catch (Throwable x) {
                if (!bWantLog || nLogged++ >= 10 && nLogged % 100 != 0) break block5;
                log.warn((Object)(x.getClass().getCanonicalName() + " snafu #" + nLogged + " writing to url: " + this.strUrl + " " + x.getMessage()));
            }
        }
        return null;
    }

    private void output(HttpURLConnection httpURLconnection) throws IOException {
        boolean doOutput = this.writer != null || this.stream != null;
        httpURLconnection.setDoOutput(doOutput);
        if (doOutput) {
            OutputStream out = StreamUtil.getBufferedOutputStream(httpURLconnection.getOutputStream());
            if (this.writer != null) {
                this.writer.writeStream(out);
            } else {
                IOUtils.copy((InputStream)this.stream.getInputStream(), (OutputStream)out);
            }
            out.flush();
            out.close();
        }
    }
}

