/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.JDFDate;

public class FileJanitor {
    private final File baseDir;
    private KillFilter filter;
    boolean logSingle;
    private final Log log;
    boolean delEmpty;

    public void setLogSingle(boolean logSingle) {
        this.logSingle = logSingle;
    }

    public void setDeleteEmptyDir(boolean delEmpty) {
        this.delEmpty = delEmpty;
    }

    public FileJanitor(File baseDir, FileFilter filter) {
        if (filter != null) {
            this.filter = new KillFilter(filter);
        }
        this.baseDir = baseDir;
        this.log = LogFactory.getLog(this.getClass());
        this.logSingle = false;
        this.delEmpty = false;
    }

    public FileJanitor(File baseDir, long age) {
        this(baseDir, null);
        this.filter = new KillFilter(new AgeFilter(age * 1000L));
    }

    public Vector<File> cleanup() {
        return FileUtil.listFilesInTree(this.baseDir, this.filter);
    }

    public String toString() {
        return "FileJanitor " + this.baseDir + " delEmpty=" + this.delEmpty;
    }

    class KillFilter
    implements FileFilter {
        private final FileFilter baseFilter;

        KillFilter(FileFilter f) {
            this.baseFilter = f;
        }

        @Override
        public boolean accept(File file) {
            boolean accept = this.baseFilter.accept(file);
            if (FileJanitor.this.delEmpty && !accept && file.isDirectory() && file.list().length == 0) {
                accept = true;
            }
            if (accept) {
                if (file.isDirectory() && file.list().length > 0) {
                    accept = false;
                }
                if (accept) {
                    if (FileJanitor.this.logSingle) {
                        if (file.isDirectory()) {
                            FileJanitor.this.log.info((Object)("removing empty directory: " + file.getAbsolutePath() + " last touched: " + new JDFDate(file.lastModified()).getFormattedDateTime("dd MMM yyyy HH:mm")));
                        } else {
                            FileJanitor.this.log.info((Object)("removing old file: " + file.getAbsolutePath() + " last touched: " + new JDFDate(file.lastModified()).getFormattedDateTime("dd MMM yyyy HH:mm") + " size=" + file.length()));
                        }
                    }
                    file.delete();
                }
            }
            return accept;
        }
    }

    class AgeFilter
    implements FileFilter {
        final long t0 = System.currentTimeMillis();
        final long age;

        AgeFilter(long age) {
            this.age = age;
        }

        @Override
        public boolean accept(File arg0) {
            return arg0.lastModified() + this.age < this.t0;
        }
    }
}

