/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.net;

import java.net.HttpURLConnection;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class HTTPDetails {
    public static final String BEARER = "Bearer";
    private int chunkSize = defaultChunkSize;
    private boolean bKeepAlive = true;
    private String bearerToken = null;
    private final JDFAttributeMap headers;
    private int redirect = 0;
    private int connectionTimeout = UrlUtil.getConnectionTimeout();
    public static int defaultChunkSize = -1;

    public HTTPDetails() {
        this.headers = new JDFAttributeMap();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public int getRedirect() {
        return this.redirect;
    }

    public void setRedirect(int redirect) {
        this.redirect = redirect;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public boolean isbKeepAlive() {
        return this.bKeepAlive;
    }

    public void setbKeepAlive(boolean bKeepAlive) {
        this.bKeepAlive = bKeepAlive;
    }

    public void applyTo(HttpURLConnection urlCon) {
        if (urlCon != null) {
            if (this.chunkSize > 0) {
                urlCon.setChunkedStreamingMode(this.chunkSize);
            }
            this.setHeader("Connection", this.bKeepAlive ? "keep-alive" : "close");
            if (!StringUtil.isEmpty(this.bearerToken)) {
                this.setHeader("Authorization", "Bearer " + this.bearerToken);
            }
            urlCon.setConnectTimeout(this.getConnectionTimeout());
            for (String key : this.headers.keySet()) {
                urlCon.setRequestProperty(key, this.headers.get(key));
            }
        }
    }

    public void setHeader(String key, String val) {
        if (!StringUtil.isEmpty(key)) {
            if (StringUtil.isEmpty(val)) {
                this.headers.remove(key);
            } else {
                this.headers.put(key, val);
            }
        }
    }

    public static HTTPDetails getRedirect(HTTPDetails details) {
        if (details == null) {
            details = new HTTPDetails();
        }
        details.setRedirect(details.getRedirect() + 1);
        return details;
    }

    public String toString() {
        return "HTTPDetails [chunkSize=" + this.chunkSize + ", bKeepAlive=" + this.bKeepAlive + ", bearerToken=" + this.bearerToken + ", redirect=" + this.redirect + ", connectionTimeout=" + this.connectionTimeout + " headers: " + this.headers.showKeys(null) + "]";
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public VString getHeaders() {
        return this.headers.getKeys();
    }
}

