/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.ByteArrayIOFileStream;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.SkipInputStream;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class ZipReader {
    final InputStream is;
    ByteArrayIOStream bios;
    ZipInputStream zis;
    final Log log = LogFactory.getLog(this.getClass());
    ZipEntry currentEntry;
    String rootEntry;
    int maxBuffer;
    boolean caseSensitive;

    public int getMaxBuffer() {
        return this.maxBuffer;
    }

    public void setMaxBuffer(int maxBuffer) {
        this.maxBuffer = maxBuffer;
    }

    public String getRootEntry() {
        return this.rootEntry;
    }

    public void setRootEntry(String rootEntry) {
        this.rootEntry = StringUtil.getNonEmpty(rootEntry);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public ZipReader(InputStream inStream) {
        this(inStream, 10000000);
    }

    public ZipReader(InputStream inStream, int maxBuffer) {
        this.is = inStream;
        this.maxBuffer = maxBuffer;
        this.zis = new ZipInputStream(this.is);
        this.bios = null;
        this.caseSensitive = true;
    }

    public ZipReader(File file) {
        this(file, 10000000);
    }

    public ZipReader(File file, int maxBuffer) {
        this.maxBuffer = maxBuffer;
        this.zis = null;
        this.is = null;
        this.bios = new ByteArrayIOFileStream(file, maxBuffer, true);
        this.caseSensitive = true;
        this.reset();
        if (file != null) {
            this.setRootEntry(UrlUtil.newExtension(file.getName(), null) + "/");
        }
    }

    public ZipReader(String fileName) {
        this(UrlUtil.urlToFile(fileName));
    }

    public Vector<ZipEntry> getEntries() {
        Vector<ZipEntry> vze = new Vector<ZipEntry>();
        ZipEntry ze = this.getNextEntry();
        while (ze != null) {
            vze.add(ze);
            ze = this.getNextEntry();
        }
        return vze;
    }

    public ZipEntry getNextEntry() {
        try {
            ZipEntry nextEntry;
            this.currentEntry = nextEntry = this.zis.getNextEntry();
            return nextEntry;
        }
        catch (IOException e) {
            this.currentEntry = null;
            return null;
        }
    }

    public int unPack(File dir) {
        if (dir == null) {
            return 0;
        }
        dir.mkdirs();
        if (!dir.isDirectory()) {
            return 0;
        }
        int n = 0;
        ZipEntry ze = this.getNextEntry();
        while (ze != null) {
            boolean b = this.unPack(dir, ze);
            if (b) {
                ++n;
            }
            ze = this.getNextEntry();
        }
        return n;
    }

    public boolean unPack(File dir, ZipEntry ze) {
        if (dir == null || ze == null) {
            return false;
        }
        if (this.currentEntry != ze) {
            this.log.warn((Object)"snafu with entries");
            return false;
        }
        String fileName = ZipReader.getEntryName(ze);
        File file = new File(fileName);
        File newFile = FileUtil.getFileInDirectory(dir, file);
        try {
            if (ze.isDirectory()) {
                newFile.mkdirs();
            } else {
                boolean ok;
                File parent = newFile.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                if (ok = FileUtil.createNewFile(newFile)) {
                    BufferedOutputStream fos = FileUtil.getBufferedOutputStream(newFile);
                    if (fos != null) {
                        IOUtils.copyLarge((InputStream)this.zis, (OutputStream)fos);
                        ((OutputStream)fos).flush();
                        ((OutputStream)fos).close();
                    } else {
                        ok = false;
                    }
                }
                if (!ok) {
                    this.log.error((Object)("Snafu unpacking zip to: " + fileName));
                    this.zis.closeEntry();
                    return false;
                }
            }
            this.zis.closeEntry();
        }
        catch (IOException e) {
            this.log.error((Object)("Snafu unpacking zip to: " + fileName), (Throwable)e);
        }
        return true;
    }

    public static String getEntryName(ZipEntry ze) {
        String fileName = ze == null ? null : ze.getName();
        fileName = StringUtil.replaceChar(fileName, '\\', "/", 0);
        return UrlUtil.cleanDots(fileName);
    }

    public static ZipReader getZipReader(InputStream is) {
        return ZipReader.getZipReader(is, true);
    }

    public static ZipReader getZipReader(InputStream is, boolean bSearch) {
        ByteArrayIOStream keepBuffer = null;
        try {
            ZipReader newReader = new ZipReader(is);
            newReader.buffer();
            keepBuffer = newReader.bios;
            ZipEntry nextEntry = newReader.getNextEntry();
            if (nextEntry != null && StringUtil.getNonEmpty(ZipReader.getEntryName(nextEntry)) != null) {
                newReader.reset();
                return newReader;
            }
        }
        catch (Exception newReader) {
            // empty catch block
        }
        if (bSearch) {
            Vector<ZipReader> v = ZipReader.getZipReaders(keepBuffer == null ? is : keepBuffer.getInputStream(), 1);
            return v != null && v.size() == 1 ? v.get(0) : null;
        }
        return null;
    }

    public static Vector<ZipReader> getZipReaders(InputStream is, int max) {
        if (is == null) {
            return null;
        }
        ByteArrayIOStream.ByteArrayIOInputStream bios = ByteArrayIOStream.getBufferedInputStream(is);
        SkipInputStream sis = new SkipInputStream("PK\u0003\u0004", bios, false);
        boolean nextAvailable = true;
        sis.mark(10000000);
        Vector<ZipReader> v = new Vector<ZipReader>();
        int n = 0;
        while (nextAvailable) {
            try {
                ZipReader newReader = new ZipReader(sis);
                newReader.buffer();
                ZipEntry nextEntry = newReader.getNextEntry();
                if (nextEntry != null && StringUtil.getNonEmpty(ZipReader.getEntryName(nextEntry)) != null) {
                    v.add(newReader);
                    if (++n == max) break;
                    SkipInputStream sis2 = new SkipInputStream("PK\u0005\u0006", bios, false, 0L);
                    sis2.seek(sis.tell());
                    boolean foundEnd = sis2.readToNextTag();
                    if (foundEnd) {
                        sis.seek(sis2.tell());
                    }
                    sis2.close();
                    sis.mark(10000000);
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sis.reset();
            nextAvailable = sis.readToNextTag();
            sis.mark(10000000);
        }
        return v.size() == 0 ? null : v;
    }

    public ZipEntry getEntry(String urlString) {
        this.buffer();
        if (urlString == null) {
            this.log.error((Object)"cannot retrieve null entry");
            return null;
        }
        urlString = UrlUtil.cleanDots(urlString);
        ZipEntry ze = this.getNextEntry();
        String urlUnEscaped = UrlUtil.unEscape(urlString);
        if (urlString.equals(urlUnEscaped)) {
            urlUnEscaped = null;
        }
        while (ze != null) {
            boolean matches;
            String name = ZipReader.getEntryName(ze);
            boolean bl = matches = this.caseSensitive ? urlString.equals(name) : urlString.equalsIgnoreCase(name);
            if (!matches && urlUnEscaped != null) {
                boolean bl2 = matches = this.caseSensitive ? urlUnEscaped.equals(name) : urlUnEscaped.equalsIgnoreCase(name);
            }
            if (!matches && this.rootEntry != null && name.startsWith(this.rootEntry) && !StringUtil.isEmpty(name = StringUtil.rightStr(name, -this.rootEntry.length()))) {
                boolean bl3 = matches = this.caseSensitive ? urlString.equals(name) : urlString.equalsIgnoreCase(name);
                if (!matches && urlUnEscaped != null) {
                    boolean bl4 = matches = this.caseSensitive ? urlUnEscaped.equals(name) : urlUnEscaped.equalsIgnoreCase(name);
                }
            }
            if (!matches && !name.equals(StringUtil.token(name, -1, "/")) && (name = StringUtil.token(name, -1, "/")) != null && name.length() > 0) {
                boolean bl5 = matches = this.caseSensitive ? urlString.equals(name) : urlString.equalsIgnoreCase(name);
                if (!matches && urlUnEscaped != null) {
                    boolean bl6 = matches = this.caseSensitive ? urlUnEscaped.equals(name) : urlUnEscaped.equalsIgnoreCase(name);
                }
            }
            if (matches) {
                return ze;
            }
            ze = this.getNextEntry();
        }
        return null;
    }

    public boolean setEntry(ZipEntry zeSet) {
        this.buffer();
        if (zeSet == null) {
            this.log.error((Object)"cannot set null entry");
            return false;
        }
        ZipEntry ze = this.getNextEntry();
        String setName = zeSet.getName();
        while (ze != null) {
            if (setName.equals(ze.getName())) {
                return true;
            }
            ze = this.getNextEntry();
        }
        return false;
    }

    public ZipEntry getMatchingEntry(String expr, int iSkip) {
        this.buffer();
        ZipEntry ze = this.getNextMatchingEntry(expr);
        int n = 0;
        while (ze != null) {
            if (n >= iSkip) {
                return ze;
            }
            ++n;
            ze = this.getNextMatchingEntry(expr);
        }
        return null;
    }

    public Vector<ZipEntry> getMatchingEntries(String expr, boolean sortName) {
        this.buffer();
        Vector<ZipEntry> vRet = new Vector<ZipEntry>();
        ZipEntry ze = this.getNextMatchingEntry(expr);
        while (ze != null) {
            vRet.add(ze);
            ze = this.getNextMatchingEntry(expr);
        }
        if (sortName) {
            Collections.sort(vRet, new NameComparator());
        }
        return vRet;
    }

    public ZipEntry getNextMatchingEntry(String expr) {
        ZipEntry ze = this.getNextEntry();
        String exprUnEscaped = UrlUtil.unEscape(expr);
        if (expr.equals(exprUnEscaped)) {
            exprUnEscaped = null;
        }
        while (ze != null) {
            boolean matches;
            String name = ZipReader.getEntryName(ze);
            boolean bl = matches = this.caseSensitive ? StringUtil.matchesSimple(name, expr) : StringUtil.matchesIgnoreCase(name, expr);
            if (!matches && exprUnEscaped != null) {
                boolean bl2 = matches = this.caseSensitive ? StringUtil.matchesSimple(name, exprUnEscaped) : StringUtil.matchesIgnoreCase(name, exprUnEscaped);
            }
            if (!matches && this.rootEntry != null && name.startsWith(this.rootEntry) && !StringUtil.isEmpty(name = StringUtil.rightStr(name, -this.rootEntry.length()))) {
                boolean bl3 = matches = this.caseSensitive ? StringUtil.matchesSimple(name, expr) : StringUtil.matchesIgnoreCase(name, expr);
                if (!matches && exprUnEscaped != null) {
                    boolean bl4 = matches = this.caseSensitive ? StringUtil.matchesSimple(name, exprUnEscaped) : StringUtil.matchesIgnoreCase(name, exprUnEscaped);
                }
            }
            if (!matches && !name.equals(StringUtil.token(name, -1, "/")) && (name = StringUtil.token(name, -1, "/")) != null && name.length() > 0) {
                boolean bl5 = matches = this.caseSensitive ? StringUtil.matchesSimple(name, expr) : StringUtil.matchesIgnoreCase(name, expr);
                if (!matches && exprUnEscaped != null) {
                    boolean bl6 = matches = this.caseSensitive ? StringUtil.matchesSimple(name, exprUnEscaped) : StringUtil.matchesIgnoreCase(name, exprUnEscaped);
                }
            }
            if (matches) {
                return ze;
            }
            ze = this.getNextEntry();
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.currentEntry == null ? null : this.zis;
    }

    public XMLDoc getXMLDoc() {
        if (this.currentEntry == null) {
            return null;
        }
        XMLDoc doc = XMLDoc.parseStream(this.zis);
        if (doc != null) {
            doc.setZipReader(this);
        }
        return doc;
    }

    public JDFDoc getJDFDoc() {
        if (this.currentEntry == null) {
            return null;
        }
        JDFDoc doc = JDFDoc.parseStream(this.zis);
        if (doc != null) {
            doc.setZipReader(this);
        }
        return doc;
    }

    public void buffer() {
        if (this.bios == null) {
            this.bios = new ByteArrayIOFileStream(this.is, this.maxBuffer);
        }
        this.reset();
    }

    public void close() {
        if (this.bios != null) {
            this.bios.close();
        }
        if (this.zis != null) {
            try {
                this.zis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void reset() {
        if (this.bios != null) {
            this.zis = new ZipInputStream(this.bios.getInputStream());
        }
    }

    public String toString() {
        return "ZipReader root=" + this.rootEntry;
    }

    public static ZipReader getZipReader(File jarFile) {
        return ZipReader.getZipReader(FileUtil.getBufferedInputStream(jarFile));
    }

    public static ZipReader getZipReader(File jarFile, boolean search) {
        return ZipReader.getZipReader(FileUtil.getBufferedInputStream(jarFile), search);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class NameComparator
    implements Comparator<ZipEntry> {
        private NameComparator() {
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            String s1 = ZipReader.getEntryName(o1);
            String s2 = ZipReader.getEntryName(o2);
            return ContainerUtil.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
        }
    }
}

