/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.ArrayList;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFRectangleRange;
import org.cip4.jdflib.util.StringUtil;

public class JDFRectangleRangeList
extends JDFRangeList {
    public static JDFRectangleRangeList createRectangleRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFRectangleRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFRectangleRangeList() {
    }

    public JDFRectangleRangeList(JDFRectangleRangeList rl) {
        this.rangeList = new ArrayList(rl.rangeList);
    }

    public JDFRectangleRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public boolean inRange(JDFRectangle x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            if (!((JDFRectangleRange)this.rangeList.get(i)).inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString vs = new VString(zappedWS, " ");
        this.rangeList.clear();
        int size = vs.size();
        for (int i = 0; i < size; ++i) {
            if (size - i < 4) {
                throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
            }
            StringBuffer str = new StringBuffer(100);
            str.append(vs.elementAt(i)).append(" ").append(vs.elementAt(++i)).append(" ").append(vs.elementAt(++i)).append(" ");
            String tildeToken = vs.elementAt(++i);
            str.append(tildeToken);
            if (tildeToken.indexOf("~") != -1) {
                if (size - i < 4) {
                    throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
                }
                str.append(" ").append(vs.elementAt(++i)).append(" ").append(vs.elementAt(++i)).append(" ").append(vs.elementAt(++i));
            }
            try {
                JDFRectangleRange r = new JDFRectangleRange(str.toString());
                this.rangeList.add(r);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFRectangleRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFRectangleRange x) {
        this.rangeList.add(x);
    }

    public void append(JDFRectangle x) {
        this.append(new JDFRectangleRange(x));
    }

    public void append(JDFRectangle xMin, JDFRectangle xMax) {
        this.append(new JDFRectangleRange(xMin, xMax));
    }

    @Override
    public boolean isOrdered() {
        int n;
        ArrayList<JDFRectangle> v = this.getOrderedArray();
        int n2 = n = v == null ? 0 : v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFRectangle first = v.get(0);
        JDFRectangle last = v.get(n);
        for (int j = 0; j < n; ++j) {
            JDFRectangle value = v.get(j);
            JDFRectangle nextvalue = v.get(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isLess(last) && value.isLessOrEqual(nextvalue) || first.isGreater(last) && value.isGreaterOrEqual(nextvalue)) continue;
            return false;
        }
        return true;
    }

    protected ArrayList<JDFRectangle> getOrderedArray() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return null;
        }
        ArrayList<JDFRectangle> v = new ArrayList<JDFRectangle>();
        for (int i = 0; i < siz; ++i) {
            JDFRectangleRange r = (JDFRectangleRange)this.rangeList.get(i);
            v.add(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.add(r.getRight());
        }
        return v;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFRectangle last;
        int n;
        ArrayList<JDFRectangle> v = this.getOrderedArray();
        int n2 = n = v == null ? 0 : v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFRectangle first = v.get(0);
        if (first.equals(last = v.get(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFRectangle value = v.get(j);
            JDFRectangle nextvalue = v.get(j + 1);
            if (first.isLess(last) && value.isLess(nextvalue) || first.isGreater(last) && value.isGreater(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

