/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.auto.JDFAutoConventionalPrintingParams;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoMarkObject;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.IWalker;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.resource.process.JDFSeparationSpec;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;

public class XJDFSchemaCreator
extends BaseElementWalker {
    public boolean bSpanAsAttribute = true;
    protected final HashMap<String, ValuedEnum> enumMap;
    File baseDir;
    File output;
    JDFNode jdfRoot;
    Set<String> ignoreNames;

    public XJDFSchemaCreator(File baseDir, File output) {
        super(new XJDFSchemaCreatorWalkerFactory());
        this.baseDir = baseDir;
        this.output = output;
        JDFDoc d1 = new JDFDoc("JDF");
        d1.setInitOnCreate(false);
        this.jdfRoot = d1.getJDFRoot();
        this.createIgnoreNames();
        this.enumMap = new HashMap();
    }

    void createIgnoreNames() {
        if (this.ignoreNames == null) {
            this.ignoreNames = new VString("Audit RefElement AttributeMap Element ResourceLink ResourceLinkPool ResourcePool AncestorPool Ancestor Spawned Merged BusinessInfo Identical Doc DocumentBuilder Exception PartStatus PartAmount AmountPool PlaceHolder Node BindItem DevCap DevCaps DevCapPool DisplayGroupPool FeaturePool CreateLink CreateResource NewComment UpdateJDFCmdParams MoveResource Sheet Surface", null).getSet();
            this.ignoreNames.add("TargetRoute");
            this.ignoreNames.add("Route");
            this.ignoreNames.add("IPPVersion");
            this.ignoreNames.add("PRGroup");
            this.ignoreNames.add("PRGroupOccurrence");
            this.ignoreNames.add("PROccurrence");
            this.ignoreNames.add("ProductionIntent");
            this.ignoreNames.add("ArtDeliveryIntent");
            this.ignoreNames.add("DeliveryIntent");
            this.ignoreNames.add("DropIntent");
            this.ignoreNames.add("DropItemIntent");
        }
    }

    public void create() {
        KElement treeRoot = this.createTree();
        XMLDoc schema = new XMLDoc("xs:schema", "http://www.w3.org/2001/XMLSchema");
        KElement schemaRoot = schema.getRoot();
        this.walkTree(treeRoot, schemaRoot);
        schema.write2File(this.output, 2, false);
    }

    private KElement createTree() {
        Vector<File> files = FileUtil.listFilesInTree(this.baseDir, "*.java");
        XMLDoc tree = new XMLDoc("classes", null);
        KElement treeRoot = tree.getRoot();
        this.addSimpleTypes(treeRoot);
        this.addNewTypes(treeRoot);
        treeRoot.appendElement("XJDF");
        for (int i = 0; i < files.size(); ++i) {
            String name;
            File file = files.get(i);
            File parent = file.getParentFile();
            String parentName = parent.getName();
            if (parentName.equals("auto") || parentName.equals("ifaces") || parentName.equals("goldenticket") || !(name = file.getName()).startsWith("JDF")) continue;
            name = StringUtil.leftStr(name, -5);
            name = StringUtil.rightStr(name, -3);
            treeRoot.getCreateElement(name);
        }
        return treeRoot;
    }

    private void addSimpleTypes(KElement treeRoot) {
        this.putPair(JDFAutoMarkObject.EnumAnchor.getEnum(0), treeRoot);
        this.putPair(JDFElement.EnumNamedColor.getEnum(0), treeRoot);
        this.putPair(JDFElement.EnumNodeStatus.getEnum(0), treeRoot);
        this.putPair(JDFResource.EnumResStatus.getEnum(0), treeRoot);
        this.putPair(JDFElement.EnumOrientation.getEnum(0), treeRoot);
        this.putPair(JDFAutoConventionalPrintingParams.EnumWorkStyle.getEnum(0), treeRoot);
        this.putPair(JDFAutoMedia.EnumFrontCoatings.getEnum(0), treeRoot);
        this.putPair(JDFAutoDeviceInfo.EnumDeviceStatus.getEnum(0), treeRoot);
        this.putPair(JDFAutoBasicPreflightTest.EnumListType.getEnum(0), treeRoot);
        this.putPair(JDFDeviceCap.EnumAvailability.getEnum(0), treeRoot);
        this.putPair(JDFAbstractState.EnumUserDisplay.getEnum(0), treeRoot);
    }

    private void addNewTypes(KElement treeRoot) {
        treeRoot.getCreateElement("Resource");
        treeRoot.getCreateElement("ResourceSet");
        treeRoot.getCreateElement("Parameter");
        treeRoot.getCreateElement("ParameterSet");
        treeRoot.getCreateElement("Intent");
        treeRoot.getCreateElement("ChildProduct");
        treeRoot.getCreateElement("Product");
        treeRoot.getCreateElement("ProductList");
        treeRoot.getCreateElement("TextElement");
        treeRoot.getCreateElement("ElementState");
        treeRoot.getCreateElement("Dependent");
    }

    private void putPair(ValuedEnum en, KElement treeRoot) {
        String name = this.getEnumName(en);
        this.enumMap.put(name, en);
        treeRoot.appendElement(name);
    }

    protected String getEnumName(ValuedEnum valuedEnum) {
        if (valuedEnum == null) {
            return null;
        }
        String s = EnumUtil.getEnumName(valuedEnum).substring(4);
        if ("SourceWorkStyle".equals(s)) {
            s = "WorkStyle";
        }
        if ("BackCoatings".equals(s) || "FrontCoatings".equals(s)) {
            s = "Coatings";
        }
        return "Enum" + s;
    }

    protected String getTypeName(AttributeInfo.EnumAttributeType typ) {
        return typ.getName();
    }

    protected KElement appendSimpleType(KElement baseElem, String typName, String baseType, VString v) {
        KElement typ = baseElem.appendElement("xs:simpleType");
        typ.setAttribute("name", typName);
        typ = typ.appendElement("xs:restriction");
        typ.setAttribute("base", baseType);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                KElement enu = typ.appendElement("xs:enumeration");
                enu.setAttribute("value", v.get(i));
            }
        }
        return typ;
    }

    protected VString getEnumVector(ValuedEnum ve) {
        Class<?> class1 = ve.getClass();
        VString v = EnumUtil.getNamesVector(class1);
        String className = class1.getName();
        int pos = className.indexOf("$Enum");
        if (pos > 0) {
            className = className.substring(pos + 5);
        }
        if ("Status".equals(className) || "NodeStatus".equals(className) || "EndStatus".equals(className)) {
            v.remove(JDFElement.EnumNodeStatus.FailedTestRun.getName());
            v.remove(JDFElement.EnumNodeStatus.Ready.getName());
            v.remove(JDFElement.EnumNodeStatus.TestRunInProgress.getName());
            v.remove(JDFElement.EnumNodeStatus.Spawned.getName());
            v.remove(JDFElement.EnumNodeStatus.Part.getName());
            v.remove(JDFElement.EnumNodeStatus.Pool.getName());
        } else if ("Version".equals(className)) {
            return new VString("2.0", null);
        }
        return v;
    }

    protected class WalkNiCi
    extends WalkResourceElement {
        public WalkNiCi() {
            this.myNodes = new VString("NodeInfo CustomerInfo Preview", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            this.c = JDFResource.EnumResourceClass.Parameter;
            return super.walk(in, out);
        }

        @Override
        public boolean matches(KElement toCheck) {
            String localName = toCheck.getLocalName();
            return localName.equals("NodeInfo") || localName.equals("CustomerInfo") || localName.equals("Preview");
        }
    }

    protected class WalkDependent
    extends WalkElement {
        public WalkDependent() {
            this.myNodes = new VString("Dependent", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            String setName = in.getLocalName();
            this.complexType = this.setComplexType(out, setName);
            this.setXSAttribute(this.complexType, "JobID", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.shortString), true, null);
            this.setXSAttribute(this.complexType, "JobPartID", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.shortString), true, null);
            this.setXSAttribute(this.complexType, "JMFURL", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.URL), false, null);
            return null;
        }
    }

    protected class WalkResourcePhysical
    extends WalkResource {
        @Override
        protected WalkElement.VAttributeDescriptor getKnownAtts() {
            WalkElement.VAttributeDescriptor knownAtts = super.getKnownAtts();
            knownAtts.remove("AmountProduced");
            knownAtts.remove("AmountRequired");
            knownAtts.remove("Amount");
            knownAtts.add(new WalkElement.AttributeDescriptor("AmountGood", AttributeInfo.EnumAttributeType.double_, false, null));
            knownAtts.add(new WalkElement.AttributeDescriptor("AmountWaste", AttributeInfo.EnumAttributeType.double_, false, null));
            return knownAtts;
        }

        public WalkResourcePhysical() {
            this.myNodes = new VString("Resource", null).getSet();
        }
    }

    protected class WalkJobPhase
    extends WalkElement {
        public WalkJobPhase() {
            this.myNodes = new VString("JobPhase", null).getSet();
        }

        @Override
        protected VString getKnownElms() {
            VString knownElms = super.getKnownElms();
            knownElms.remove("JDF");
            return knownElms;
        }
    }

    protected class WalkTest
    extends WalkTerm {
        public WalkTest() {
            this.myNodes = new VString("Test", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            KElement e = super.walk(in, out);
            if (this.complexType != null) {
                this.complexType.setAttribute("substitutionGroup", null);
            }
            return e;
        }
    }

    protected class WalkTerm
    extends WalkElement {
        public WalkTerm() {
            this.myNodes = null;
        }

        @Override
        public boolean matches(KElement e) {
            if (!super.matches(e)) {
                return false;
            }
            String nodeName = e.getNodeName();
            if (this.e2 == null) {
                this.e2 = XJDFSchemaCreator.this.jdfRoot.appendElement(nodeName);
            }
            return this.e2 instanceof JDFTerm;
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            KElement e = super.walk(in, out);
            KElement cc = this.complexElement.appendElement("xs:complexType").appendElement("xs:complexContent");
            this.complexElement.setAttribute("substitutionGroup", "TermType");
            this.complexType.setAttribute("base", "TermType");
            KElement ext = cc.moveElement(this.complexType, null);
            ext.renameElement("xs:extension", null);
            return e;
        }

        @Override
        protected VString getKnownElms() {
            VString v = super.getKnownElms();
            boolean bAdd = false;
            for (int i = v.size() - 1; i >= 0; --i) {
                KElement ee = this.e2.appendElement(v.get(i));
                if (!(ee instanceof JDFTerm)) continue;
                v.remove(i);
                bAdd = true;
            }
            if (bAdd) {
                v.add("TermType");
            }
            return v;
        }
    }

    protected class WalkEvaluation
    extends WalkTerm {
        public WalkEvaluation() {
            this.myNodes = null;
        }

        @Override
        protected void createbaseAttribs() {
            super.createbaseAttribs();
            this.baseAttribs.add("rRef");
        }

        @Override
        public boolean matches(KElement e) {
            String nodeName = e.getNodeName();
            if (this.e2 == null) {
                this.e2 = XJDFSchemaCreator.this.jdfRoot.appendElement(nodeName);
            }
            return this.e2 instanceof JDFEvaluation;
        }

        @Override
        protected WalkElement.VAttributeDescriptor getKnownAtts() {
            WalkElement.VAttributeDescriptor knownAtts = super.getKnownAtts();
            knownAtts.add(new WalkElement.AttributeDescriptor("XPath", AttributeInfo.EnumAttributeType.XPath, true, null));
            knownAtts.add(new WalkElement.AttributeDescriptor("XPathRoot", AttributeInfo.EnumAttributeType.XPath, false, null));
            return knownAtts;
        }
    }

    protected class WalkState
    extends WalkElement {
        public WalkState() {
            this.myNodes = null;
        }

        @Override
        protected void createbaseAttribs() {
            super.createbaseAttribs();
            this.baseAttribs.add("Name");
        }

        @Override
        public boolean matches(KElement e) {
            String nodeName = e.getNodeName();
            if (this.e2 == null) {
                this.e2 = XJDFSchemaCreator.this.jdfRoot.appendElement(nodeName);
            }
            return this.e2 instanceof JDFAbstractState || "ElementState".equals(nodeName);
        }

        @Override
        protected WalkElement.VAttributeDescriptor getKnownAtts() {
            WalkElement.VAttributeDescriptor knownAtts = super.getKnownAtts();
            knownAtts.add(new WalkElement.AttributeDescriptor("XPath", AttributeInfo.EnumAttributeType.XPath, true, null));
            knownAtts.add(new WalkElement.AttributeDescriptor("XPathRoot", AttributeInfo.EnumAttributeType.XPath, false, null));
            knownAtts.add(new WalkElement.AttributeDescriptor("DescriptiveName", AttributeInfo.EnumAttributeType.string, false, null));
            if (knownAtts.get("MinOccurs") == null) {
                knownAtts.add(new WalkElement.AttributeDescriptor("MinOccurs", AttributeInfo.EnumAttributeType.integer, false, null));
            }
            if (knownAtts.get("MaxOccurs") == null) {
                knownAtts.add(new WalkElement.AttributeDescriptor("MaxOccurs", AttributeInfo.EnumAttributeType.integer, false, null));
            }
            return knownAtts;
        }
    }

    protected class WalkTextElement
    extends WalkElement {
        public WalkTextElement() {
            this.myNodes = new VString("TextElement", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            String name = in.getLocalName();
            XJDFSchemaCreator.this.appendSimpleType(out, name, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.string), null);
            return null;
        }
    }

    private static class XJDFSchemaCreatorWalkerFactory
    extends BaseWalkerFactory {
        private XJDFSchemaCreatorWalkerFactory() {
        }

        @Override
        public IWalker getWalker(KElement toCheck) {
            for (BaseWalker w : this.vBaseWalker) {
                w.prepareWalk(toCheck, null);
                if (!w.matches(toCheck)) continue;
                return w;
            }
            return null;
        }
    }

    protected class WalkChildProduct
    extends WalkElement {
        public WalkChildProduct() {
            this.myNodes = new VString("ChildProduct", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            String setName = in.getLocalName();
            this.complexType = this.setComplexType(out, setName);
            this.setXSAttribute(this.complexType, "ChildRef", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.IDREF), true, null);
            this.setXSAttribute(this.complexType, "Amount", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.integer), false, null);
            this.setXSAttribute(this.complexType, "ProductUsage", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NMTOKEN), false, null);
            return null;
        }
    }

    protected class WalkEnumerationType
    extends WalkElement {
        public WalkEnumerationType() {
            this.myNodes = null;
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            String setName = in.getLocalName();
            this.complexType = this.setSimpleType(out, setName);
            return null;
        }

        protected KElement setSimpleType(KElement out, String name) {
            ValuedEnum ve = XJDFSchemaCreator.this.enumMap.get(name);
            KElement typ = XJDFSchemaCreator.this.appendSimpleType(out, name, "xs:string", XJDFSchemaCreator.this.getEnumVector(ve));
            return typ;
        }

        @Override
        public void prepareWalk(KElement e, KElement trackElem) {
            super.prepareWalk(e, trackElem);
            if (this.myNodes == null) {
                this.myNodes = new VString(ContainerUtil.getKeyVector(XJDFSchemaCreator.this.enumMap)).getSet();
            }
        }
    }

    protected class WalkNode
    extends WalkElement {
        public WalkNode() {
            this.myNodes = new VString("XJDF", null).getSet();
        }

        @Override
        protected void createbaseAttribs() {
            super.createbaseAttribs();
            JDFNodeInfo ni = (JDFNodeInfo)XJDFSchemaCreator.this.jdfRoot.addResource("NodeInfo", null);
            this.baseAttribs.addAll(ni.knownAttributes().getSet());
            this.baseAttribs.add("StatusDetails");
            this.baseAttribs.add("Type");
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            this.complexType = this.setComplexType(out, "XJDF");
            this.e2 = XJDFSchemaCreator.this.jdfRoot.appendElement("JDF");
            this.setGeneric(this.complexType, true);
            this.setXSElement(this.complexType, "ProductList");
            this.setXSElement(this.complexType, "ResourceSet");
            this.setXSAttribute(this.complexType, "Types", AttributeInfo.EnumAttributeType.NMTOKENS, true);
            this.setXSAttribute(this.complexType, "CommentURL", AttributeInfo.EnumAttributeType.URL, false);
            super.walk(in, out);
            return null;
        }

        @Override
        protected WalkElement.VAttributeDescriptor getKnownAtts() {
            WalkElement.VAttributeDescriptor knownAtts = super.getKnownAtts();
            WalkElement.AttributeDescriptor ad = knownAtts.get("Version");
            ad.setRequired(true);
            return knownAtts;
        }
    }

    protected class WalkResource
    extends WalkElement {
        public WalkResource() {
            this.myNodes = new VString("Resource Parameter Intent", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            this.e2.deleteNode();
            String name = in.getLocalName();
            JDFResource.EnumResourceClass clazz = JDFResource.EnumResourceClass.getEnum(name);
            if (clazz == null) {
                clazz = JDFResource.EnumResourceClass.Quantity;
            }
            this.e2 = XJDFSchemaCreator.this.jdfRoot.addResource(name, clazz, null, null, null, null, null);
            this.complexType = this.setComplexType(out, name);
            super.walk(in, out);
            this.setXSElement(this.complexType, name + "Type");
            this.setXSElement(this.complexType, "Part");
            this.setGeneric(this.complexType, true);
            this.createSubstitutionBase(out, name);
            return null;
        }

        @Override
        protected WalkElement.VAttributeDescriptor getKnownAtts() {
            WalkElement.VAttributeDescriptor knownAtts = super.getKnownAtts();
            knownAtts.remove("Locked");
            knownAtts.remove("Class");
            knownAtts.remove("PartIDKeys");
            knownAtts.remove("PartUsage");
            knownAtts.remove("PipePartIDKeys");
            return knownAtts;
        }
    }

    protected class WalkProduct
    extends WalkElement {
        public WalkProduct() {
            this.myNodes = new VString("Product", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            String setName = in.getLocalName();
            this.complexType = this.setComplexType(out, setName);
            this.setGeneric(this.complexType, true);
            this.setXSElement(this.complexType, "ChildProduct");
            this.setXSElement(this.complexType, "Intent");
            this.setXSAttribute(this.complexType, "Amount", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.integer), false, null);
            this.setXSAttribute(this.complexType, "ProductID", XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.shortString), false, null);
            return null;
        }
    }

    protected class WalkProductList
    extends WalkElement {
        public WalkProductList() {
            this.myNodes = new VString("ProductList", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            String setName = in.getLocalName();
            this.complexType = this.setComplexType(out, setName);
            this.setXSAttribute(this.complexType, "RootProducts", AttributeInfo.EnumAttributeType.IDREFS, true);
            this.setGeneric(this.complexType, false);
            this.setXSElement(this.complexType, "Product");
            return null;
        }
    }

    protected class WalkResSet
    extends WalkElement {
        public WalkResSet() {
            this.myNodes = new VString("ResourceSet ParameterSet", null).getSet();
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            String setName = in.getLocalName();
            this.complexType = this.setComplexType(out, setName);
            this.setXSElement(this.complexType, StringUtil.leftStr(setName, -3));
            this.setXSElement(this.complexType, "Dependent");
            this.setGeneric(this.complexType, true);
            this.setXSAttribute(this.complexType, "Name", AttributeInfo.EnumAttributeType.NMTOKEN, true);
            this.setXSAttribute(this.complexType, "Usage", null, false, JDFResourceLink.EnumUsage.getEnum(0));
            this.setXSAttribute(this.complexType, "ProcessUsage", AttributeInfo.EnumAttributeType.NMTOKEN, false);
            return null;
        }
    }

    protected class WalkResourceElement
    extends WalkElement {
        JDFResource.EnumResourceClass c;

        public WalkResourceElement() {
            this.c = null;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement ret = super.walk(jdf, xjdf);
            KElement cc = this.complexElement.appendElement("xs:complexType").appendElement("xs:complexContent");
            if (JDFResource.EnumResourceClass.Parameter.equals((Object)this.c)) {
                this.complexElement.setAttribute("substitutionGroup", "ParameterType");
                this.complexType.setAttribute("base", "ParameterType");
            } else if (JDFResource.EnumResourceClass.Intent.equals((Object)this.c)) {
                this.complexElement.setAttribute("substitutionGroup", "IntentType");
                this.complexType.setAttribute("base", "IntentType");
            } else {
                this.complexElement.setAttribute("substitutionGroup", "ResourceType");
                this.complexType.setAttribute("base", "ResourceType");
            }
            KElement ext = cc.moveElement(this.complexType, null);
            ext.renameElement("xs:extension", null);
            return ret;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b = this.e2 instanceof JDFResource;
            if (b) {
                JDFResource resource = (JDFResource)this.e2;
                resource.init();
                this.c = resource.getResourceClass();
                if (this.c == null) {
                    b = false;
                    this.e2.deleteNode();
                    this.e2 = null;
                }
            }
            return b;
        }

        @Override
        protected void createbaseAttribs() {
            super.createbaseAttribs();
            JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
            JDFResource intRes = dummyResPool.appendResource("intent", JDFResource.EnumResourceClass.Intent, null);
            JDFResource physRes = dummyResPool.appendResource("physical", JDFResource.EnumResourceClass.Consumable, null);
            JDFResource paramRes = dummyResPool.appendResource("param", JDFResource.EnumResourceClass.Parameter, null);
            JDFPart part = (JDFPart)dummyResPool.appendElement("Part");
            this.baseAttribs.addAll(paramRes.knownAttributes());
            this.baseAttribs.addAll(physRes.knownAttributes());
            this.baseAttribs.addAll(intRes.knownAttributes());
            this.baseAttribs.addAll(part.knownAttributes());
            this.baseAttribs.add("QualityControlResult");
            this.baseAttribs.add("SourceResource");
        }
    }

    protected class WalkDeviceCap
    extends WalkElement {
        public WalkDeviceCap() {
            this.myNodes = new VString("DeviceCap", null).getSet();
        }

        @Override
        protected void createbaseAttribs() {
            super.createbaseAttribs();
            this.baseAttribs.add("GenericAttributes");
            this.baseAttribs.add("ExecutionPolicy");
            this.baseAttribs.add("CombinedMethod");
            this.baseAttribs.add("Types");
            this.baseAttribs.add("TypeExpression");
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            KElement walk = super.walk(in, out);
            this.setXSElement(this.complexType, "ElementState");
            this.createSubstitutionBase(out, "Term");
            return walk;
        }
    }

    protected class WalkRoot
    extends WalkElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            xjdf.setAttribute("targetNamespace", "http://www.CIP4.org/JDFSchema_1_1");
            xjdf.setAttribute("xmlns", "http://www.CIP4.org/JDFSchema_1_1");
            this.appendSimpleTypes(xjdf);
            return xjdf;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().equals("classes");
        }

        protected void appendSimpleTypes(KElement schemaRoot) {
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.boolean_), "xs:boolean", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.string), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.shortString), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.string), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NMTOKEN), "xs:NMTOKEN", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NMTOKENS), "xs:NMTOKENS", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.ID), "xs:ID", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.IDREF), "xs:IDREF", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.IDREFS), "xs:IDREFS", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.JDFJMFVersion), "xs:string", new VString("2.0", null));
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.language), "xs:string", null);
            this.appendSimpleTypeList(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.languages), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.language));
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.hexBinary), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.dateTime), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.DateTimeRangeList), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.PDFPath), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.duration), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.DurationRangeList), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.rectangle), "xs:double", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.RectangleRangeList), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.integer), "xs:integer", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.IntegerRangeList), "xs:integer", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.IntegerRange), "xs:integer", null);
            this.appendSimpleTypeList(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.IntegerList), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.integer));
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.double_), "xs:double", null);
            this.appendSimpleTypeList(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.double_));
            this.appendSimpleTypeList(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberRangeList), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.double_));
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.shape), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.ShapeRangeList), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.URI), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.URL), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.URI), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.XPath), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.RegExp), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.XYPair), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.XYPairRangeList), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.XYRelation), "xs:NMTOKEN", new VString("gt ge ne eq lt le", null));
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.matrix), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.Any), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.LabColor), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.RGBColor), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.CMYKColor), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.TransferFunction), XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NumberList), null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NameRangeList), "xs:string", null);
            XJDFSchemaCreator.this.appendSimpleType(schemaRoot, XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.unbounded), "xs:string", null);
        }
    }

    protected class WalkElement
    extends BaseWalker {
        protected KElement complexType;
        protected KElement complexElement;
        protected Set<String> baseAttribs;
        protected Set<String> baseElms;
        protected Set<String> refElms;
        protected Set<String> refsElms;
        protected Set<String> myNodes;
        protected KElement e2;

        public WalkElement() {
            super(XJDFSchemaCreator.this.getFactory());
            this.complexType = null;
            this.complexElement = null;
            this.baseAttribs = null;
            this.baseElms = null;
            this.refElms = null;
            this.refsElms = null;
            this.myNodes = null;
        }

        protected void createbaseAttribs() {
            JDFElement foobar = (JDFElement)XJDFSchemaCreator.this.jdfRoot.getCreateElement("fooBar");
            this.baseAttribs = foobar.knownAttributes().getSet();
            this.baseAttribs.add("xmlns");
            this.baseAttribs.add("SettingsPolicy");
            this.baseAttribs.add("MustHonorExceptions");
            this.baseAttribs.add("BestEffortExceptions");
            this.baseAttribs.add("OperatorInterventionExceptions");
            this.baseAttribs.add("SpawnIDs");
            this.baseAttribs.add("SpawnID");
            this.baseAttribs.add("SpawnStatus");
            this.baseAttribs.add("Sorting");
            this.baseAttribs.add("SortAmount");
            this.baseAttribs.add("NamedFeatures");
            this.baseAttribs.add("Template");
            this.baseAttribs.add("xsi:type");
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            int i;
            String name = in.getLocalName();
            if (this.e2 == null) {
                this.e2 = XJDFSchemaCreator.this.jdfRoot.appendElement(name);
            }
            if (this.complexType == null) {
                this.complexType = this.setComplexType(out, name);
            }
            if (this.baseElms == null) {
                this.createbaseElms();
            }
            if (this.baseAttribs == null) {
                this.createbaseAttribs();
            }
            VAttributeDescriptor knownAtts = this.getKnownAtts();
            VString knownElms = this.getKnownElms();
            if (knownAtts.size() + knownElms.size() == 0) {
                this.complexType.deleteNode();
                return null;
            }
            for (i = 0; i < knownElms.size(); ++i) {
                this.setXSElement(this.complexType, knownElms.get(i));
            }
            for (i = 0; i < knownAtts.size(); ++i) {
                AttributeDescriptor ad = (AttributeDescriptor)knownAtts.get(i);
                this.setXSAttribute(ad);
            }
            return null;
        }

        protected KElement setXSAttribute(AttributeDescriptor ad) {
            ValuedEnum valuedEnum = ad.getValuedEnum();
            String typ = XJDFSchemaCreator.this.getTypeName(ad.getTyp());
            String name = ad.getName();
            String enumName = XJDFSchemaCreator.this.getEnumName(valuedEnum);
            if (valuedEnum != null && XJDFSchemaCreator.this.enumMap.containsKey(enumName)) {
                typ = enumName;
                valuedEnum = null;
            }
            return this.setXSAttribute(this.complexType, name, typ, ad.isRequired(), valuedEnum);
        }

        private VAttributeDescriptor getKnownAttsBase() {
            AttributeDescriptor desc;
            VAttributeDescriptor vDesc = new VAttributeDescriptor();
            if (!(this.e2 instanceof JDFElement)) {
                return vDesc;
            }
            JDFElement je = (JDFElement)this.e2;
            AttributeInfo ai = je.getAttributeInfo();
            VString knownAtts = ai.knownAttribs();
            for (int i = knownAtts.size() - 1; i >= 0; --i) {
                String attName = knownAtts.get(i);
                if (this.baseAttribs.contains(attName) || XJDFSchemaCreator.this.ignoreNames.contains(attName) || ai.getLastVersion(attName).getValue() <= JDFElement.EnumVersion.Version_1_4.getValue()) continue;
                desc = new AttributeDescriptor(this.getNewName(attName));
                ValuedEnum ve = ai.getAttributeEnum(attName);
                AttributeInfo.EnumAttributeType typ = ai.getAttributeType(attName);
                desc.setValuedEnum(ve);
                desc.setTyp(typ);
                vDesc.add(desc);
            }
            VString knownRefs = je.knownElements();
            for (int i = 0; i < knownRefs.size(); ++i) {
                desc = null;
                String elmName = this.getNewName(knownRefs.get(i));
                if (this.baseAttribs.contains(elmName) || XJDFSchemaCreator.this.ignoreNames.contains(elmName)) continue;
                if (this.refsElms.contains(elmName)) {
                    desc = new AttributeDescriptor(elmName + "Refs");
                    desc.setTyp(AttributeInfo.EnumAttributeType.IDREFS);
                } else if (this.isRefElem(elmName)) {
                    desc = new AttributeDescriptor(elmName + "Ref");
                    desc.setTyp(AttributeInfo.EnumAttributeType.IDREF);
                }
                if (desc == null) continue;
                vDesc.add(desc);
            }
            return vDesc;
        }

        private boolean isRefElem(String elmName) {
            return this.refElms.contains(elmName) || elmName.endsWith("Params");
        }

        protected String getNewName(String string) {
            if ("ColorPool".equals(string)) {
                return "Color";
            }
            return string;
        }

        private VString getKnownElmsBase() {
            VString ret = new VString();
            if (!(this.e2 instanceof JDFElement)) {
                return ret;
            }
            JDFElement je = (JDFElement)this.e2;
            VString knownElms = je.knownElements();
            for (int i = knownElms.size() - 1; i >= 0; --i) {
                String elmName = knownElms.get(i);
                if (this.baseElms.contains(elmName) || this.isRefElem(elmName) || this.refsElms.contains(elmName) || je.getLastVersion(elmName, true).getValue() < JDFElement.EnumVersion.Version_1_4.getValue() || XJDFSchemaCreator.this.ignoreNames.contains(elmName)) continue;
                ret.add(this.getNewName(elmName));
            }
            return ret;
        }

        protected void createbaseElms() {
            JDFElement foobar = (JDFElement)XJDFSchemaCreator.this.jdfRoot.getCreateElement("fooBar");
            this.baseElms = foobar.knownElements().getSet();
            this.baseElms.add("Identical");
            this.baseElms.add("QualityControlResult");
            this.baseElms.add("JMF");
            this.refElms = new HashSet<String>();
            this.refElms.add("ExposedMedia");
            this.refElms.add("RunList");
            this.refElms.add("Media");
            this.refElms.add("FileSpec");
            this.refElms.add("Component");
            this.refElms.add("PageList");
            this.refElms.add("ContentList");
            this.refElms.add("ContentData");
            this.refElms.add("BinderySignature");
            this.refElms.add("DieLayout");
            this.refElms.add("ColorMeasurementConditions");
            this.refElms.add("ApprovalParams");
            this.refElms.add("ApprovalPerson");
            this.refElms.add("IdentificationField");
            this.refElms.add("QualityControlResult");
            this.refElms.add("Tool");
            this.refElms.add("Layout");
            this.refElms.add("Color");
            this.refElms.add("ColorPool");
            this.refElms.add("Device");
            this.refElms.add("ExternalImpositionTemplate");
            this.refsElms = new HashSet<String>();
            this.refsElms.add("SourceResource");
        }

        @Override
        public boolean matches(KElement e) {
            String nodeName = e.getLocalName();
            return this.myNodes == null || this.myNodes.contains(nodeName) && !XJDFSchemaCreator.this.ignoreNames.contains(nodeName);
        }

        @Override
        public void finalizeWalk(KElement e, KElement trackElem) {
            if (this.e2 != null) {
                this.e2.deleteNode();
            }
            this.e2 = null;
            this.complexType = null;
            super.finalizeWalk(e, trackElem);
        }

        @Override
        public void prepareWalk(KElement e, KElement trackElem) {
            super.prepareWalk(e, trackElem);
            this.complexType = null;
            this.e2 = XJDFSchemaCreator.this.jdfRoot.getCreateElement(e.getLocalName());
        }

        protected void setXSAttribute(KElement root, String attName, AttributeInfo.EnumAttributeType typ, boolean required) {
            KElement att = root.getChildWithAttribute("xs:attribute", "name", null, attName, 0, true);
            if (att == null) {
                att = root.appendElement("xs:attribute");
            }
            att.setAttribute("use", required ? "required" : "optional");
            att.setAttribute("name", attName);
            String typName = typ.getName();
            att.setAttribute("type", typName);
        }

        protected KElement setXSAttribute(KElement root, String attName, String typName, boolean required, ValuedEnum ve) {
            boolean bList;
            KElement att = root.appendElement("xs:attribute");
            att.setAttribute("use", required ? "required" : "optional");
            att.setAttribute("name", attName);
            boolean bl = bList = typName != null && (typName.equals(XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NMTOKENS)) || typName.startsWith("enumerations"));
            if ((typName == null || typName.startsWith("enumeration")) && XJDFSchemaCreator.this.enumMap.get(typName = typName == null ? "_" + attName : typName + "_" + attName) == null) {
                typName = typName.startsWith("enumerations") ? XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NMTOKENS) : XJDFSchemaCreator.this.getTypeName(AttributeInfo.EnumAttributeType.NMTOKEN);
            }
            if (ve != null) {
                if (bList) {
                    KElement list = this.appendSimpleTypeList(att, null, null);
                    XJDFSchemaCreator.this.appendSimpleType(list, null, "xs:string", XJDFSchemaCreator.this.getEnumVector(ve));
                }
            } else {
                att.setAttribute("type", typName);
            }
            return att;
        }

        protected void setGeneric(KElement complexType, boolean bID) {
            this.setXSElement(complexType, "GeneralID");
            this.setXSElement(complexType, "Comment");
            if (bID) {
                this.setXSAttribute(complexType, "ID", AttributeInfo.EnumAttributeType.ID, true);
            }
            this.setXSAttribute(complexType, "DescriptiveName", AttributeInfo.EnumAttributeType.string, false);
        }

        protected KElement setComplexType(KElement out, String name) {
            KElement compType;
            String typeForName = this.getTypeForName(name);
            if (typeForName != null) {
                this.complexElement = out.appendElement("xs:element");
                this.complexElement.setAttribute("name", name);
            } else {
                this.complexElement = null;
            }
            boolean bLocal = name.equals(typeForName);
            if (bLocal) {
                compType = this.complexElement.appendElement("xs:complexType");
            } else {
                compType = out.appendElement("xs:complexType");
                if (typeForName != null) {
                    compType.setAttribute("name", typeForName);
                } else {
                    compType.setAttribute("name", name);
                }
            }
            KElement root = this.complexElement != null ? this.complexElement : compType;
            root.setXMLComment(" ** Complex type definition for " + name + " ** ", true);
            return compType;
        }

        protected void setXSElement(KElement root, String elmName) {
            KElement seq = root.getElement("xs:sequence");
            if (seq == null) {
                KElement att = root.getElement("xs:attribute");
                seq = root.insertBefore("xs:sequence", att, null);
            }
            seq.setAttribute("minOccurs", "0");
            seq.setAttribute("maxOccurs", "unbounded");
            KElement choice = seq.getCreateElement("xs:choice");
            KElement elem = choice.appendElement("xs:element");
            elem.setAttribute("minOccurs", "0");
            boolean bRef = elmName.equals(this.getTypeForName(elmName));
            if (bRef) {
                elem.setAttribute("ref", this.getTypeForName(elmName));
            } else {
                elem.setAttribute("name", elmName);
                elem.setAttribute("type", this.getTypeForName(elmName));
            }
        }

        protected String getTypeForName(String elmName) {
            if ("FolderSuperStructureWebPath".equals(elmName)) {
                return "ProductionSubPath";
            }
            if ("PostPressComponentPath".equals(elmName)) {
                return "ProductionSubPath";
            }
            if ("PrintingUnitWebPath".equals(elmName)) {
                return "ProductionSubPath";
            }
            if ("ExtendedAddress".equals(elmName)) {
                return "TextElement";
            }
            if ("OrganizationalUnit".equals(elmName)) {
                return "TextElement";
            }
            if ("ProductionSubPath".equals(elmName)) {
                return null;
            }
            return elmName;
        }

        protected AttributeDescriptor getSpanAttDesc(String s) {
            KElement e = this.e2.appendElement(s);
            AttributeDescriptor desc = null;
            if (e instanceof JDFSpanBase && XJDFSchemaCreator.this.bSpanAsAttribute) {
                desc = new AttributeDescriptor(s);
                AttributeInfo ai = ((JDFElement)e).getAttributeInfo();
                desc.setTyp(ai.getAttributeType("Actual"));
                desc.setValuedEnum(ai.getAttributeEnum("Actual"));
            } else if (e instanceof JDFSeparationList) {
                desc = new AttributeDescriptor(s);
                desc.setTyp(AttributeInfo.EnumAttributeType.NMTOKENS);
            } else if (e instanceof JDFSeparationSpec) {
                desc = new AttributeDescriptor("SeparationNames");
                desc.setTyp(AttributeInfo.EnumAttributeType.NMTOKENS);
            }
            return desc;
        }

        protected VAttributeDescriptor getKnownAtts() {
            VAttributeDescriptor va = this.getKnownAttsBase();
            VString vElem = this.getKnownElmsBase();
            for (int i = vElem.size() - 1; i >= 0; --i) {
                String s = (String)((Vector)vElem).get(i);
                AttributeDescriptor spanAttDesc = this.getSpanAttDesc(s);
                if (spanAttDesc == null) continue;
                va.add(spanAttDesc);
            }
            return va;
        }

        protected VString getKnownElms() {
            VString vElem = this.getKnownElmsBase();
            for (int i = vElem.size() - 1; i >= 0; --i) {
                String s = vElem.get(i);
                if (this.getSpanAttDesc(s) == null) continue;
                vElem.remove(i);
            }
            return vElem;
        }

        protected void createSubstitutionBase(KElement out, String name) {
            KElement e = out.appendElement("xs:element");
            e.setAttribute("name", name + "Type");
            e.setAttribute("type", name + "Type");
            e.setAttribute("abstract", true, null);
            e.setXMLComment("** abstract type for substitution only ** ", true);
            e = out.appendElement("xs:complexType");
            e.setAttribute("name", name + "Type");
        }

        protected KElement appendSimpleTypeList(KElement schemaRoot, String typeName, String baseType) {
            KElement typ = schemaRoot.appendElement("xs:simpleType");
            typ.setAttribute("name", typeName);
            KElement list = typ.appendElement("xs:list");
            list.setAttribute("itemType", baseType);
            return list;
        }

        protected class AttributeDescriptor {
            String name;
            AttributeInfo.EnumAttributeType typ;
            boolean required;
            ValuedEnum valuedEnum;

            public AttributeDescriptor(String name, AttributeInfo.EnumAttributeType typ, boolean required, ValuedEnum valuedEnum) {
                this.name = name;
                this.typ = typ;
                this.required = required;
                this.valuedEnum = valuedEnum;
            }

            public AttributeDescriptor(String attName) {
                this.name = attName;
                this.typ = null;
                this.required = false;
                this.valuedEnum = null;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public AttributeInfo.EnumAttributeType getTyp() {
                return this.typ;
            }

            public void setTyp(AttributeInfo.EnumAttributeType typ) {
                this.typ = typ;
            }

            public boolean isRequired() {
                return this.required;
            }

            public void setRequired(boolean required) {
                this.required = required;
            }

            public ValuedEnum getValuedEnum() {
                return this.valuedEnum;
            }

            public void setValuedEnum(ValuedEnum valuedEnum) {
                this.valuedEnum = valuedEnum;
            }

            public String toString() {
                return "AttributeDescriptor: " + this.name + " " + (Object)((Object)this.typ) + " " + this.required;
            }

            public boolean equals(Object obj) {
                if (obj instanceof AttributeDescriptor) {
                    return this.name.equals(((AttributeDescriptor)obj).name);
                }
                return this.name.equals(obj);
            }

            public int hashCode() {
                return this.name.hashCode();
            }
        }

        protected class VAttributeDescriptor
        extends Vector<AttributeDescriptor> {
            private static final long serialVersionUID = 1L;

            protected VAttributeDescriptor() {
            }

            public void remove(String s) {
                AttributeDescriptor ad = this.get(s);
                if (ad != null) {
                    this.remove(ad);
                }
            }

            public AttributeDescriptor get(String s) {
                for (int i = 0; i < this.size(); ++i) {
                    AttributeDescriptor ad = (AttributeDescriptor)this.get(i);
                    if (!ad.equals(s)) continue;
                    return ad;
                }
                return null;
            }
        }
    }

    protected class WalkIgnore
    extends WalkElement {
        @Override
        public boolean matches(KElement e) {
            String localName = e.getLocalName();
            boolean b = XJDFSchemaCreator.this.ignoreNames.contains(localName);
            b = b || this.myNodes.contains(localName);
            b = b || localName.startsWith("IDP");
            b = b || this.e2 instanceof JDFSeparationList;
            b = b || this.e2 instanceof JDFSeparationSpec;
            b = b || this.e2 instanceof JDFColorPool;
            b = b || XJDFSchemaCreator.this.bSpanAsAttribute && this.e2 instanceof JDFSpanBase;
            return b;
        }

        public WalkIgnore() {
            XJDFSchemaCreator.this.createIgnoreNames();
            this.myNodes = XJDFSchemaCreator.this.ignoreNames;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            return null;
        }
    }
}

