/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.MyMutex;

public class OrderedTaskQueue
extends Thread {
    final Vector<TaskRunner> queue;
    final AtomicInteger idle;
    final Log log;
    MyMutex mutex;
    int started;
    int done;
    long sumQueue;
    long sumRun;
    TaskRunner currentRunning;
    static Map<String, OrderedTaskQueue> theMap = new HashMap<String, OrderedTaskQueue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrderedTaskQueue getCreateQueue(String name) {
        name = OrderedTaskQueue.getThreadName(name);
        Map<String, OrderedTaskQueue> map = theMap;
        synchronized (map) {
            OrderedTaskQueue orderedTaskQueue = theMap.get(name);
            if (orderedTaskQueue == null) {
                orderedTaskQueue = new OrderedTaskQueue(name);
                theMap.put(name, orderedTaskQueue);
            }
            orderedTaskQueue.idle.set(0);
            return orderedTaskQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDown(String name) {
        name = OrderedTaskQueue.getThreadName(name);
        Map<String, OrderedTaskQueue> map = theMap;
        synchronized (map) {
            OrderedTaskQueue orderedTaskQueue = theMap.get(name);
            if (orderedTaskQueue != null) {
                orderedTaskQueue.shutDown();
            }
        }
    }

    OrderedTaskQueue(String name) {
        super(name);
        this.setDaemon(true);
        this.log = LogFactory.getLog(this.getClass());
        this.queue = new Vector();
        this.mutex = new MyMutex();
        this.done = 0;
        this.started = 0;
        this.sumQueue = 0L;
        this.sumRun = 0L;
        this.idle = new AtomicInteger(0);
        this.start();
    }

    static String getThreadName(String name) {
        return name == null ? "OrderedTaskQueue" : "OrderedTaskQueue_" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownAll() {
        int size = theMap.size();
        if (size > 0) {
            LogFactory.getLog(OrderedTaskQueue.class).info((Object)("shutting down " + size + " ordered queues"));
            Map<String, OrderedTaskQueue> map = theMap;
            synchronized (map) {
                Collection<String> v = ContainerUtil.getKeyArray(theMap);
                if (v != null) {
                    for (String key : v) {
                        theMap.get(key).shutDown();
                    }
                }
            }
        } else {
            LogFactory.getLog(OrderedTaskQueue.class).info((Object)("skipping shut down of " + size + " ordered queues"));
        }
    }

    public void shutDown() {
        this.idle.set(-1);
        theMap.remove(this.getName());
        ThreadUtil.notifyAll(this.mutex);
    }

    public boolean interruptCurrent(int minAge) {
        TaskRunner cr = this.currentRunning;
        if (cr != null && cr.getRunTime() < (long)minAge) {
            return false;
        }
        int n = 0;
        while (cr != null && cr == this.currentRunning) {
            this.interrupt();
            if (ThreadUtil.sleep(++n) && n <= 10) continue;
        }
        return cr == null || cr != this.currentRunning;
    }

    public int size() {
        return this.queue.size();
    }

    public int getDone() {
        return this.done;
    }

    public boolean isLive() {
        return this.idle.get() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queue(Runnable task) {
        if (this.idle.get() < 0) {
            this.log.error((Object)"cannot queue task in stopped queue");
            return false;
        }
        Vector<TaskRunner> vector = this.queue;
        synchronized (vector) {
            this.queue.add(new TaskRunner(task));
        }
        this.idle.set(0);
        ThreadUtil.notifyAll(this.mutex);
        return true;
    }

    @Override
    public void run() {
        do {
            try {
                this.runTasks();
            }
            catch (Throwable e) {
                this.log.error((Object)"whazzup queueing ordered task ", e);
            }
            if (this.idle.get() < 0) {
                ThreadUtil.notifyAll(this.mutex);
                this.mutex = null;
                break;
            }
            if (this.idle.incrementAndGet() <= 3) continue;
            this.shutDown();
        } while (ThreadUtil.wait(this.mutex, 100000));
    }

    private void runTasks() {
        while (this.idle.get() >= 0) {
            this.currentRunning = this.getFirstTask();
            if (this.currentRunning == null) break;
            this.runTask(this.currentRunning);
            this.currentRunning = null;
        }
    }

    void runTask(TaskRunner r) {
        this.idle.set(0);
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskRunner getFirstTask() {
        Vector<TaskRunner> vector = this.queue;
        synchronized (vector) {
            if (this.queue.size() > 0) {
                this.idle.set(0);
                return this.queue.remove(0);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "OrderedTaskQueue " + this.getName() + " " + this.idle + " queue: " + this.queue;
    }

    public long getAvQueue() {
        return this.done == 0 ? 0L : this.sumQueue / (long)this.done;
    }

    public long getSumQueue() {
        return this.sumQueue;
    }

    public long getAvRun() {
        return this.done == 0 ? 0L : this.sumRun / (long)this.done;
    }

    public long getSumRun() {
        return this.sumRun;
    }

    class TaskRunner
    implements Runnable {
        long tQueue;
        long tStart;
        long tEnd;
        Runnable theTask;
        Thread myThread;

        TaskRunner(Runnable r) {
            this.theTask = r;
            this.tQueue = System.currentTimeMillis();
            this.tStart = 0L;
            this.tEnd = 0L;
            this.myThread = null;
        }

        void interrupt() {
            if (this.myThread != null) {
                try {
                    this.myThread.interrupt();
                    OrderedTaskQueue.this.log.info((Object)("Interrupted " + this.toString()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            this.tStart = System.currentTimeMillis();
            this.myThread = Thread.currentThread();
            ++OrderedTaskQueue.this.started;
            OrderedTaskQueue.this.sumQueue += this.getWaitTime();
            try {
                this.theTask.run();
            }
            catch (Throwable x) {
                OrderedTaskQueue.this.log.error((Object)("Exception caught while running " + this.theTask), x);
            }
            finally {
                this.tEnd = System.currentTimeMillis();
                OrderedTaskQueue.this.sumRun += this.getRunTime();
                ++OrderedTaskQueue.this.done;
                this.myThread = null;
                OrderedTaskQueue.this.idle.set(0);
            }
        }

        public long getWaitTime() {
            return this.tStart == 0L ? System.currentTimeMillis() - this.tQueue : this.tStart - this.tQueue;
        }

        public long getStartTime() {
            return this.tStart;
        }

        public long getRunTime() {
            return this.tStart == 0L ? 0L : (this.tEnd == 0L ? System.currentTimeMillis() - this.tStart : this.tEnd - this.tStart);
        }

        public String toString() {
            return "TaskRunner :" + this.getWaitTime() + " / " + this.getRunTime() + "\n" + this.theTask;
        }
    }
}

