/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkIntentResource;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.util.StringUtil;

public class WalkMedia
extends WalkIntentResource {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll();
    }

    @Override
    public VString getElementNames() {
        return new VString("Media", null);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("MediaSetCount");
        map.remove("PrePrinted");
        String mediaType = map.get("MediaType");
        if (mediaType == null || JDFAutoMedia.EnumMediaType.Unknown.getName().equals(mediaType)) {
            map.put("MediaType", (ValuedEnum)JDFAutoMedia.EnumMediaType.Other);
        }
        this.updateGrade(map, "Grade", "ISOPaperSubstrate");
        this.updateGrade(map, "BackGrade", "BackISOPaperSubstrate");
        this.updateFluteGrain("FluteDirection", map);
        this.updateFluteGrain("GrainDirection", map);
        map.renameKey("FrontCoatings", "Coating");
        map.renameKey("FrontCoatings", "CoatingDetail");
        map.renameKey("FrontGlossValue", "GlossValue");
        super.updateAttributes(map);
    }

    private void updateGrade(JDFAttributeMap map, String oldGrade, String newGrade) {
        int igrade;
        JDFAutoMedia.EnumISOPaperSubstrate ips;
        String grade = map.remove(oldGrade);
        if (map.getNonEmpty(newGrade) == null && (ips = JDFMedia.getIsoPaperFromGrade(igrade = StringUtil.parseInt(grade, 0))) != null) {
            map.put(newGrade, ips.getName());
        }
    }

    private void updateFluteGrain(String att, JDFAttributeMap map) {
        String value = map.getNonEmpty(att);
        if (JDFAutoMedia.EnumGrainDirection.LongEdge.getName().equals(value)) {
            JDFXYPair dim = JDFXYPair.createXYPair(map.get("Dimension"));
            value = dim != null ? (dim.getX() > dim.getY() ? JDFAutoMedia.EnumGrainDirection.XDirection.getName() : JDFAutoMedia.EnumGrainDirection.YDirection.getName()) : null;
        } else if (JDFAutoMedia.EnumGrainDirection.ShortEdge.getName().equals(value)) {
            JDFXYPair dim = JDFXYPair.createXYPair(map.get("Dimension"));
            value = dim != null ? (dim.getX() < dim.getY() ? JDFAutoMedia.EnumGrainDirection.XDirection.getName() : JDFAutoMedia.EnumGrainDirection.YDirection.getName()) : null;
        }
        map.remove(att);
        map.putNotNull(att, value);
    }
}

