/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.HashSet;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.util.StringUtil;

public class WalkMessage
extends WalkJDFElement {
    private static final HashSet<JDFMessage.EnumType> badtypes = WalkMessage.fillBadTypes();

    private static HashSet<JDFMessage.EnumType> fillBadTypes() {
        HashSet<JDFMessage.EnumType> s = new HashSet<JDFMessage.EnumType>();
        s.add(JDFMessage.EnumType.CloseQueue);
        s.add(JDFMessage.EnumType.FlushResources);
        s.add(JDFMessage.EnumType.HoldQueue);
        s.add(JDFMessage.EnumType.Events);
        s.add(JDFMessage.EnumType.KnownControllers);
        s.add(JDFMessage.EnumType.KnownJDFServices);
        s.add(JDFMessage.EnumType.ModifyNode);
        s.add(JDFMessage.EnumType.NewJDF);
        s.add(JDFMessage.EnumType.NodeInfo);
        s.add(JDFMessage.EnumType.Occupation);
        s.add(JDFMessage.EnumType.OpenQueue);
        s.add(JDFMessage.EnumType.QueueEntryStatus);
        s.add(JDFMessage.EnumType.RepeatMessages);
        s.add(JDFMessage.EnumType.RequestForAuthentication);
        s.add(JDFMessage.EnumType.ResumeQueue);
        s.add(JDFMessage.EnumType.SubmissionMethods);
        s.add(JDFMessage.EnumType.Track);
        s.add(JDFMessage.EnumType.UpdateJDF);
        return s;
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFMessage m2;
        JDFMessage m = (JDFMessage)jdf;
        if (this.jdfToXJDF.isTypeSafeMessage() && (m2 = this.makeTypesafe(m)) == null) {
            return null;
        }
        return super.walk(jdf, xjdf);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        super.updateAttributes(map);
        map.remove("Version");
        map.remove("MaxVersion");
        if (this.jdfToXJDF.isTypeSafeMessage()) {
            map.renameKey("SenderID", "DeviceID");
            map.remove("Type");
            map.remove("Acknowledged");
            map.remove("AcknowledgeType");
            map.remove("AcknowledgeURL");
            map.remove("Format");
            map.remove("LastRepeat");
            map.remove("Template");
        }
    }

    JDFMessage makeTypesafe(JDFMessage m) {
        String type;
        JDFMessage.EnumFamily family = this.getNewFamily(m);
        String string = type = family == null ? null : this.getMessageType(m);
        if (type == null) {
            return null;
        }
        m.renameElement(this.getFamilyName(family) + type, null);
        return m;
    }

    String getFamilyName(JDFMessage.EnumFamily family) {
        return family.getName();
    }

    String getMessageType(JDFMessage m) {
        JDFMessage.EnumType type = m.getEnumType();
        boolean zappType = this.isZappType(type);
        if (zappType) {
            this.log.warn((Object)("Removing unsupported message Type: " + m.getType()));
        }
        return zappType ? null : type.getName();
    }

    boolean isZappType(JDFMessage.EnumType type) {
        return type == null || badtypes.contains((Object)type);
    }

    JDFMessage.EnumFamily getNewFamily(JDFMessage m) {
        String type = m.getType();
        if (StringUtil.isEmpty(type)) {
            return null;
        }
        JDFMessage.EnumFamily family = m.getFamily();
        if (this.jdfToXJDF.isAbstractMessage()) {
            if (JDFMessage.EnumFamily.Command.equals((Object)family) || JDFMessage.EnumFamily.Registration.equals((Object)family)) {
                family = JDFMessage.EnumFamily.Query;
            }
            if (JDFMessage.EnumFamily.Acknowledge.equals((Object)family)) {
                family = JDFMessage.EnumFamily.Response;
            }
        }
        return family;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFMessage;
    }
}

