/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.auto.JDFAutoDigitalPrintingParams;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFInterpretingParams;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFDigitalPrintingParams;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.resource.process.JDFTile;
import org.cip4.jdflib.resource.process.prepress.JDFColorSpaceConversionParams;
import org.cip4.jdflib.resource.process.prepress.JDFInk;
import org.cip4.jdflib.resource.process.prepress.JDFRenderingParams;

public class WideFormatGoldenTicket
extends MISGoldenTicket {
    public WideFormatGoldenTicket(WideFormatGoldenTicket previous, VJDFAttributeMap _vparts) {
        super(previous.misICSLevel, previous.theVersion, previous.jmfICSLevel);
        this.grayBox = false;
        this.partIDKeys = new VString(previous.partIDKeys);
        this.vParts = _vparts == null ? new VJDFAttributeMap(previous.vParts) : _vparts;
        this.icsLevel = previous.icsLevel;
        this.nCols = previous.nCols;
        this.workStyle = previous.workStyle;
        this.thePreviousNode = previous.theNode;
        this.theParentNode = previous.theParentNode;
        this.bUsageCounter = this.icsLevel == 3;
    }

    @Override
    protected void fillCatMaps() {
        super.fillCatMaps();
        this.catMap.put("DPW.WideFormat", new VString("Interpreting ColorSpaceConversion Rendering Tiling DigitalPrinting", null));
        this.setCategory("DPW.WideFormat");
    }

    public WideFormatGoldenTicket(MISGoldenTicket parent) {
        super(parent);
        this.grayBox = false;
        this.bUsageCounter = this.icsLevel == 3;
    }

    public WideFormatGoldenTicket(int _icsLevel) {
        this(_icsLevel, null);
    }

    public WideFormatGoldenTicket(int _icsLevel, JDFElement.EnumVersion version) {
        super(1, version, 2);
        this.grayBox = false;
        this.icsLevel = _icsLevel;
        this.bUsageCounter = _icsLevel == 3;
    }

    @Override
    public void init() {
        String icsTag = "DPW_L" + this.icsLevel + "-" + this.theVersion.getName();
        this.theNode.appendAttribute("ICSVersions", icsTag, null, " ", true);
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("Wide Format Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        super.init();
        this.setActivePart(this.vParts, true);
        this.initDocumentRunList();
        this.initOutputComponent();
        this.initInterpretingParams();
        this.initRenderingParams();
        this.initUsageCounter();
        this.initTile();
        this.initPaperMedia();
        this.initDigitalPrintingParams(null);
        this.initColorantControl();
        this.initColorspaceConversion();
        this.initInk();
    }

    protected void initInk() {
        JDFInk ink = (JDFInk)this.theNode.getCreateResource("Ink", JDFResourceLink.EnumUsage.Input, 0);
        ink.setUnit("l");
        ink.setFamily("InkJet");
        for (String col : this.cols) {
            JDFInk sep = (JDFInk)ink.addPartition(JDFResource.EnumPartIDKey.Separation, col);
            sep.setInkName("Inkjet " + col);
        }
    }

    private void initColorspaceConversion() {
        JDFColorSpaceConversionParams cscp = (JDFColorSpaceConversionParams)this.theNode.getCreateResource("ColorSpaceConversionParams", JDFResourceLink.EnumUsage.Input, 0);
    }

    private JDFTile initTile() {
        JDFTile tile = (JDFTile)this.theNode.getCreateResource("Tile", JDFResourceLink.EnumUsage.Input, 0);
        tile.setCTM(JDFMatrix.getUnitMatrix());
        tile.setClipBox(new JDFRectangle(0.0, 0.0, 444.0, 666.0));
        return tile;
    }

    private JDFInterpretingParams initInterpretingParams() {
        JDFInterpretingParams interpretingParams = (JDFInterpretingParams)this.theNode.getCreateResource("InterpretingParams", JDFResourceLink.EnumUsage.Input, 0);
        return interpretingParams;
    }

    private JDFRenderingParams initRenderingParams() {
        JDFRenderingParams renderingParams = (JDFRenderingParams)this.theNode.getCreateResource("RenderingParams", JDFResourceLink.EnumUsage.Input, 0);
        return renderingParams;
    }

    private JDFDigitalPrintingParams initDigitalPrintingParams(JDFMedia m) {
        JDFDigitalPrintingParams digiParams = (JDFDigitalPrintingParams)this.theNode.getCreateResource("DigitalPrintingParams", JDFResourceLink.EnumUsage.Input, 0);
        digiParams.setSides(JDFAutoDigitalPrintingParams.EnumSides.OneSidedFront);
        digiParams.setPageDelivery(JDFAutoDigitalPrintingParams.EnumPageDelivery.SameOrderFaceUp);
        if (m != null) {
            digiParams.refElement(m);
        }
        return digiParams;
    }

    @Override
    public void execute(VJDFAttributeMap parts, boolean outputAvailable, boolean bFirst) {
        this.setActivePart(null, bFirst);
        super.execute(null, outputAvailable, bFirst);
    }

    @Override
    protected JDFRunList initDocumentRunList() {
        JDFRunList rl = super.initDocumentRunList();
        this.theNode.getLink((JDFResource)rl, JDFResourceLink.EnumUsage.Input).setProcessUsage(JDFNode.EnumProcessUsage.Document);
        return rl;
    }

    @Override
    protected JDFMedia initPaperMedia() {
        super.initPaperMedia();
        this.paperMedia.setDimensionCM(new JDFXYPair(200, 0));
        this.paperMedia.setPrintingTechnology("Latex");
        this.paperMedia.setUnit("m2");
        this.paperMedia.setMediaType(JDFAutoMedia.EnumMediaType.Vinyl);
        this.paperMedia.setMediaTypeDetails("Backlit");
        this.paperMedia.setDescriptiveName("the vinyl to print on");
        this.paperMedia.removeAttribute("Weight");
        this.theNode.ensureLink(this.paperMedia, JDFResourceLink.EnumUsage.Input, null);
        return this.paperMedia;
    }

    @Override
    protected void initJDF() {
        super.initJDF();
        this.theNode.setGeneralID("preset", "acrylprinting");
    }

    @Override
    protected JDFComponent initOutputComponent() {
        JDFComponent comp = super.initOutputComponent();
        comp.setDescriptiveName("The wide format ouput component");
        return comp;
    }

    @Override
    protected VString getCols() {
        return new VString("Black,Cyan,Magenta,Yellow,White", ",");
    }
}

