/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFNumberRange;
import org.cip4.jdflib.datatypes.JDFNumberRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.util.StringUtil;

public class JDFNumberEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[3];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFNumberEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFNumberEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFNumberEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFNumberEvaluation[ --> " + super.toString() + " ]";
    }

    public void setValueList(JDFNumberRangeList value) {
        this.setAttribute("ValueList", value.toString(), null);
    }

    public JDFNumberRangeList getValueList() {
        try {
            return new JDFNumberRangeList(this.getAttribute("ValueList", "", null));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFNumberEvaluation.setValueList: Attribute VALUELIST not applicable to create a JDFNumberRangeList");
        }
    }

    public void setTolerance(JDFXYPair value) {
        this.setAttribute("Tolerance", value.toString(), null);
    }

    @Override
    public JDFXYPair getTolerance() {
        return super.getTolerance();
    }

    public void setValueMod(JDFXYPair value) {
        this.setAttribute("ValueMod", value.toString(), null);
    }

    public JDFXYPair getValueMod() {
        try {
            return new JDFXYPair(this.getAttribute("ValueMod"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFNumberEvaluation.setValueMod: Attribute AllowedValueMod is not applicable to create JDFXYPair");
        }
    }

    @Override
    public boolean fitsValue(String value) {
        if (!this.fitsListType(value)) {
            return false;
        }
        JDFNumberRangeList rangelist = null;
        try {
            rangelist = new JDFNumberRangeList(value);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            if (this.fitsValueMod((JDFNumberRange)rangelist.at(i))) continue;
            return false;
        }
        return this.fitsValueList(rangelist);
    }

    private final boolean fitsListType(String value) {
        JDFNumberRangeList rangelist;
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        try {
            rangelist = new JDFNumberRangeList(value);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (JDFException e) {
            return false;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            return StringUtil.isNumber(value);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.RangeList) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.List) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return rangelist.isList();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedList)) {
            return rangelist.isList() && rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            return rangelist.isList() && rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedList)) {
            return rangelist.isList() && rangelist.isUniqueOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedRangeList)) {
            return rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueRangeList)) {
            return rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedRangeList)) {
            return rangelist.isUniqueOrdered();
        }
        throw new JDFException("JDFNumberEvaluation.fitsListType illegal ListType attribute");
    }

    private final boolean fitsValueList(JDFNumberRangeList rangelist) {
        if (!this.hasAttribute("ValueList")) {
            return true;
        }
        JDFNumberRangeList valuelist = this.getValueList();
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, valuelist);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, valuelist);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, valuelist);
        }
        if (this.hasAttribute("Tolerance")) {
            valuelist = this.fitsTolerance(valuelist);
        }
        return !valuelist.isPartOfRange(rangelist);
    }

    private final boolean fitsValueMod(JDFNumberRange range) {
        double pt;
        double nt;
        double right;
        if (!this.hasAttribute("ValueMod")) {
            return true;
        }
        JDFXYPair mod = this.getValueMod();
        double left = range.getLeft();
        if (left != (right = range.getRight())) {
            return false;
        }
        double elem = left;
        double divi = mod.getX();
        double shift = mod.getY();
        if (divi == 0.0) {
            return false;
        }
        if (this.hasAttribute("Tolerance")) {
            nt = this.getTolerance().getX();
            pt = this.getTolerance().getY();
        } else {
            pt = 1.0E-6;
            nt = 1.0E-6;
        }
        double n = elem - divi * (double)((int)(elem / divi)) - shift;
        if (Math.abs(n) < pt || Math.abs(n) > divi - nt) {
            return true;
        }
        double m = n - divi * (double)((int)(n / divi));
        return Math.abs(m) < pt || Math.abs(m) > divi - nt;
    }

    public final JDFNumberRangeList fitsTolerance(JDFNumberRangeList origRangeList) {
        double nt = this.getTolerance().getX();
        double pt = this.getTolerance().getY();
        if (nt == 0.0 && pt == 0.0) {
            return origRangeList;
        }
        JDFNumberRangeList rangeList = new JDFNumberRangeList(origRangeList);
        JDFNumberRangeList tolRangeList = new JDFNumberRangeList();
        int size = rangeList.size();
        for (int i = 0; i < size; ++i) {
            JDFNumberRange range = (JDFNumberRange)rangeList.at(i);
            JDFNumberRange r = new JDFNumberRange();
            r.setLeft(range.getLeft() - nt);
            r.setRight(range.getRight() + pt);
            tolRangeList.append(r);
        }
        return tolRangeList;
    }

    private final boolean fitsCompleteList(JDFNumberRangeList value, JDFNumberRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFNumberRangeList valueList = new JDFNumberRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFNumberRangeList value, JDFNumberRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFNumberRangeList value, JDFNumberRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    static {
        JDFNumberEvaluation.atrInfoTable[0] = new AtrInfoTable("Tolerance", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, "0 0");
        JDFNumberEvaluation.atrInfoTable[1] = new AtrInfoTable("ValueList", 0x33333333L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFNumberEvaluation.atrInfoTable[2] = new AtrInfoTable("ValueMod", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, null);
    }
}

