/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.JDFXYPairRange;
import org.cip4.jdflib.datatypes.JDFXYPairRangeList;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;

public class JDFXYPairState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[11];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFXYPairState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFXYPairState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFXYPairState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFXYPairState[ --> " + super.toString() + " ]";
    }

    public void setCurrentValue(JDFXYPair value) {
        this.setAttribute("CurrentValue", value.toString(), null);
    }

    public JDFXYPair getCurrentValue() {
        try {
            return new JDFXYPair(this.getAttribute("CurrentValue"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFXYPairState.getCurrentValue: Attribute CURRENTVALUE is not capable to create JDFXYPair");
        }
    }

    public void setDefaultValue(JDFXYPair value) {
        this.setAttribute("DefaultValue", value.toString(), null);
    }

    public JDFXYPair getDefaultValue() {
        try {
            return new JDFXYPair(this.getAttribute("DefaultValue"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFXYPairState.getDefaultValue: Attribute DEFAULTVALUE is not capable to create JDFXYPair");
        }
    }

    public void setAllowedValueList(JDFXYPairRangeList value) {
        this.setAttribute("AllowedValueList", value.toString(), null);
    }

    public JDFXYPairRangeList getAllowedValueList() {
        try {
            String attribute = this.getAttribute("AllowedValueList", null, null);
            return attribute == null ? null : new JDFXYPairRangeList(attribute);
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFXYPairState.getAllowedValueList: Attribute ALLOWEDVALUELIST is not applicable to create JDFXYPairRangeList");
        }
    }

    public void setPresentValueList(JDFXYPairRangeList value) {
        this.setAttribute("PresentValueList", value.toString(), null);
    }

    public JDFXYPairRangeList getPresentValueList() {
        if (this.hasAttribute("PresentValueList")) {
            try {
                return new JDFXYPairRangeList(this.getAttribute("PresentValueList"));
            }
            catch (DataFormatException dfe) {
                throw new JDFException("JDFXYPairState.getPresentValueList: Attribute PRESENTVALUELIST is not applicable to create JDFXYPairRangeList");
            }
        }
        return this.getAllowedValueList();
    }

    public void setAllowedValueMax(JDFXYPair value) {
        this.setAttribute("AllowedValueMax", value.toString(), null);
    }

    public JDFXYPair getAllowedValueMax() {
        try {
            return new JDFXYPair(this.getAttribute("AllowedValueMax"));
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFXYPairState.getAllowedValueMax: Attribute ALLOWEDVALUEMAX is not applicable to create JDFXYPair");
        }
    }

    public void setPresentValueMax(JDFXYPair value) {
        this.setAttribute("PresentValueMax", value.toString(), null);
    }

    public JDFXYPair getPresentValueMax() {
        if (this.hasAttribute("PresentValueMax")) {
            try {
                return new JDFXYPair(this.getAttribute("PresentValueMax"));
            }
            catch (DataFormatException dfe) {
                throw new JDFException("JDFXYPairState.setAllowedValueMin: Attribute PRESENTVALUEMAX is not applicable to create JDFXYPair");
            }
        }
        return this.getAllowedValueMax();
    }

    public void setAllowedValueMin(JDFXYPair value) {
        this.setAttribute("AllowedValueMin", value.toString(), null);
    }

    public JDFXYPair getAllowedValueMin() {
        try {
            return new JDFXYPair(this.getAttribute("AllowedValueMin"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFXYPairState.setAllowedValueMin: Attribute ALLOWEDVALUEMIN is not applicable to create JDFXYPair");
        }
    }

    public void setPresentValueMin(JDFXYPair value) {
        this.setAttribute("PresentValueMin", value.toString(), null);
    }

    public JDFXYPair getPresentValueMin() {
        if (this.hasAttribute("PresentValueMin")) {
            try {
                return new JDFXYPair(this.getAttribute("PresentValueMin"));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFXYPairState.getPresentValueMin: Attribute PRESENTVALUEMIN is not applicable to create JDFXYPair");
            }
        }
        return this.getAllowedValueMin();
    }

    public void setAllowedXYRelation(JDFElement.EnumXYRelation value) {
        this.setAttribute("AllowedXYRelation", value.getName(), null);
    }

    public JDFElement.EnumXYRelation getAllowedXYRelation() {
        return JDFElement.EnumXYRelation.getEnum(this.getAttribute("AllowedXYRelation", null, null));
    }

    public void setPresentXYRelation(JDFElement.EnumXYRelation value) {
        this.setAttribute("PresentXYRelation", value.getName(), null);
    }

    public JDFElement.EnumXYRelation getPresentXYRelation() {
        JDFElement.EnumXYRelation avail = JDFElement.EnumXYRelation.getEnum(this.getAttribute("PresentXYRelation", null, null));
        if (avail == null) {
            return this.getAllowedXYRelation();
        }
        return avail;
    }

    public String getUnitType() {
        return this.getAttribute("UnitType");
    }

    public void setUnitType(String value) {
        this.setAttribute("UnitType", value);
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFXYPairRangeList list;
        JDFXYPair rect;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        try {
            rect = new JDFXYPair(value);
        }
        catch (DataFormatException x) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new JDFXYPairRangeList();
            }
            list.append(rect);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new JDFXYPairRangeList();
            }
            list.append(rect);
            this.setPresentValueList(list);
        }
    }

    @Override
    public boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (!this.fitsListType(value)) {
            return false;
        }
        JDFXYPairRangeList rangelist = null;
        try {
            rangelist = new JDFXYPairRangeList(value);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            boolean bFitsXY;
            JDFXYPair right;
            JDFXYPairRange range = (JDFXYPairRange)rangelist.at(i);
            JDFXYPair left = range.getLeft();
            if (left.equals(right = range.getRight())) {
                bFitsXY = this.fitsXYRelation(left, testlists);
            } else {
                boolean bl = bFitsXY = this.fitsXYRelation(left, testlists) && this.fitsXYRelation(right, testlists);
            }
            if (bFitsXY) continue;
            return false;
        }
        return this.fitsValueList(rangelist, testlists);
    }

    private final boolean fitsValueList(JDFXYPairRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFXYPairRangeList list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, list);
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            JDFXYPairRange range = (JDFXYPairRange)rangelist.at(i);
            if (list.isPartOfRange(range)) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsXYRelation(JDFXYPair xypair, JDFBaseDataTypes.EnumFitsValue xyrelation) {
        JDFElement.EnumXYRelation relation = xyrelation.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedXYRelation() : this.getPresentXYRelation();
        if (relation == null) {
            return true;
        }
        double x = xypair.getX();
        double y = xypair.getY();
        return relation.evaluateXY(x, y, 1.0E-6, 1.0E-6);
    }

    private final boolean fitsCompleteList(JDFXYPairRangeList value, JDFXYPairRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFXYPairRangeList valueList = new JDFXYPairRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFXYPairRangeList value, JDFXYPairRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFXYPairRangeList value, JDFXYPairRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.XYPairEvaluation;
    }

    static {
        JDFXYPairState.atrInfoTable[0] = new AtrInfoTable("AllowedValueList", 0x33333331L, AttributeInfo.EnumAttributeType.XYPairRangeList, null, null);
        JDFXYPairState.atrInfoTable[1] = new AtrInfoTable("AllowedValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFXYPairState.atrInfoTable[2] = new AtrInfoTable("AllowedValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFXYPairState.atrInfoTable[3] = new AtrInfoTable("AllowedXYRelation", 0x33333311L, AttributeInfo.EnumAttributeType.XYRelation, null, null);
        JDFXYPairState.atrInfoTable[4] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFXYPairState.atrInfoTable[5] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFXYPairState.atrInfoTable[6] = new AtrInfoTable("PresentValueList", 0x33333331L, AttributeInfo.EnumAttributeType.XYPairRangeList, null, null);
        JDFXYPairState.atrInfoTable[7] = new AtrInfoTable("PresentValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFXYPairState.atrInfoTable[8] = new AtrInfoTable("PresentValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFXYPairState.atrInfoTable[9] = new AtrInfoTable("PresentXYRelation", 0x33333311L, AttributeInfo.EnumAttributeType.XYRelation, null, null);
        JDFXYPairState.atrInfoTable[10] = new AtrInfoTable("UnitType", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFXYPairState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

