/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class RollingFile
extends File {
    private final AtomicInteger pos;
    private final String base;
    private final String ext;
    private int digits;
    protected final Log log;
    private static final long serialVersionUID = 1521423479897L;

    public RollingFile(String pathname, String baseName) {
        super(pathname);
        this.ext = UrlUtil.extension(baseName);
        this.base = UrlUtil.prefix(baseName);
        this.digits = 6;
        this.pos = new AtomicInteger(this.calcPos());
        this.log = LogFactory.getLog(this.getClass());
        this.mkdirs();
    }

    protected int calcPos() {
        File[] list = this.readAll();
        int p = 0;
        if (list == null) {
            return p;
        }
        for (File f : list) {
            int n;
            String name = f.getName();
            name = UrlUtil.newExtension(name, null);
            if (this.base != null) {
                name = name.substring(this.base.length());
            }
            if ((n = StringUtil.parseInt(name, -1)) <= p) continue;
            p = n;
        }
        return p;
    }

    public File[] readAll() {
        String expression = this.getFileExpression();
        Object[] list = FileUtil.listFilesWithExpression(this, expression);
        if (list != null) {
            Arrays.sort(list);
        }
        return list;
    }

    protected String getFileExpression() {
        String expression = "(.)*";
        if (this.base != null) {
            expression = this.base + expression;
        }
        if (this.ext != null) {
            expression = expression + "." + this.ext;
        }
        return expression;
    }

    public File getNewFile() {
        File file = FileUtil.getFileInDirectory(this, new File(this.getNewFileName()));
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException x) {
                file = null;
            }
        }
        return file;
    }

    protected String getNewFileName() {
        String exp = this.getFileExpression();
        exp = StringUtil.replaceString(exp, "(.)*", "%0" + this.digits + "i");
        exp = StringUtil.sprintf(exp, "" + this.pos.incrementAndGet());
        return exp;
    }

    public void setDigits(int digits) {
        this.digits = digits;
    }
}

