/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.net;

import java.io.InputStream;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.net.HTTPDetails;
import org.cip4.jdflib.util.thread.WaitTimeout;

public class UrlCheck {
    private String method;
    private final String url;
    private UrlWait wait;
    private InputStream stream;
    private boolean buffer;
    private HTTPDetails det;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isBuffer() {
        return this.buffer;
    }

    public UrlCheck(String url) {
        this(url, UrlUtil.HEAD);
    }

    public UrlCheck(String url, String method) {
        this.url = url;
        this.wait = null;
        this.method = method;
        this.stream = null;
        this.buffer = false;
    }

    public UrlPart ping(int waitMillis) {
        this.startPing(waitMillis);
        UrlPart p = this.getPing();
        return p;
    }

    public UrlPart getPing() {
        UrlPart p = this.wait == null ? null : (UrlPart)this.wait.getWaitedObject();
        return p;
    }

    public void startPing(int waitMillis) {
        this.wait = new UrlWait(waitMillis);
    }

    public int pingRC(int waitMillis) {
        UrlPart p = this.ping(waitMillis);
        return p == null ? -1 : p.getResponseCode();
    }

    public int getPingRC() {
        UrlPart p = this.getPing();
        return p == null ? -1 : p.getResponseCode();
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
        if (stream != null) {
            this.method = UrlUtil.POST;
        }
    }

    public void setBuffer(boolean buffer) {
        this.buffer = buffer;
    }

    public String toString() {
        return "UrlCheck [method=" + this.method + ", url=" + this.url + ", wait=" + this.wait + ", buffer=" + this.buffer + " " + (this.det == null ? "" : this.det);
    }

    public HTTPDetails getHTTPDetails() {
        return this.det;
    }

    public void setHTTPDetails(HTTPDetails details) {
        this.det = details;
    }

    private class UrlWait
    extends WaitTimeout<UrlPart> {
        UrlWait(int millis) {
            super(millis);
            this.start();
        }

        @Override
        protected UrlPart handle() {
            UrlPart p = UrlUtil.writeToURL(UrlCheck.this.url, UrlCheck.this.stream, UrlCheck.this.method, null, UrlCheck.this.det);
            if (p != null && UrlCheck.this.buffer) {
                p.buffer();
            }
            return p;
        }
    }
}

