/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.PartitionMap;
import org.cip4.jdflib.util.ContainerUtil;

public class PartitionGetter {
    private static final String[] NON_EVIL = new String[]{"Run", "SignatureName", "SheetName", "Side", "Separation"};
    private final JDFResource resourceRoot;
    private boolean strictPartVersion;
    private boolean followIdentical;
    private final PartitionMap leafMap;
    private final JDFAttributeMap localPartMap;

    JDFAttributeMap getPartitionFromMap(JDFAttributeMap partMap, JDFResource.EnumPartUsage partUsage) {
        JDFAttributeMap ret;
        if (partMap == null) {
            return new JDFAttributeMap();
        }
        if (partMap.isEmpty()) {
            return partMap;
        }
        if (this.hasGap(partMap, null)) {
            return null;
        }
        JDFResource mapRes = this.leafMap.get(partMap);
        JDFAttributeMap jDFAttributeMap = ret = mapRes == null ? null : partMap;
        if (ret == null) {
            ret = this.checkPV(partMap, partUsage);
        }
        if (ret == null) {
            if (partUsage == null) {
                partUsage = this.resourceRoot.getPartUsage();
            }
            if (!JDFResource.EnumPartUsage.Explicit.equals((Object)partUsage)) {
                ret = this.getImplicitPartitionFromMap(partMap, partUsage);
                if (JDFResource.EnumPartUsage.Sparse.equals((Object)partUsage) && this.leafMap.get(ret).getDirectPartition(0) != null) {
                    ret = null;
                }
            }
        }
        return ret;
    }

    JDFAttributeMap checkPV(JDFAttributeMap partMap, JDFResource.EnumPartUsage partUsage) {
        JDFAttributeMap onlyMap = null;
        if (this.containsEvil(partMap) && !this.leafMap.hasMissingKeys(partMap)) {
            for (JDFAttributeMap map : this.leafMap.keySet()) {
                if (!JDFPart.subPartMap(map, partMap, this.strictPartVersion)) continue;
                if (onlyMap != null) {
                    onlyMap.remove("PartVersion");
                    return JDFResource.EnumPartUsage.Explicit.equals((Object)partUsage) || this.leafMap.get(onlyMap) == null ? null : onlyMap;
                }
                onlyMap = map.clone();
            }
        }
        return onlyMap;
    }

    boolean containsEvil(JDFAttributeMap partMap) {
        int s = partMap.size();
        for (String key : NON_EVIL) {
            if (partMap.containsKey(key)) {
                --s;
            }
            if (s != 0) continue;
            return false;
        }
        if (partMap.containsKey("PartVersion") && !this.strictPartVersion || !this.leafMap.getPartIDKeys().contains("PartVersion")) {
            --s;
        }
        return s == 0;
    }

    boolean hasSparseLeaf(JDFAttributeMap current, JDFAttributeMap partMap) {
        partMap = partMap.clone();
        partMap.reduceMap(this.leafMap.getPartIDKeys());
        partMap.removeKeys(current.keySet());
        return !partMap.isEmpty();
    }

    JDFAttributeMap getImplicitPartitionFromMap(JDFAttributeMap partMap, JDFResource.EnumPartUsage partUsage) {
        if (!this.resourceRoot.hasNonEmpty_KElement("PartIDKeys")) {
            return new JDFAttributeMap();
        }
        int size = partMap.size();
        if (size > 1 || this.leafMap.hasMissingKeys(partMap)) {
            JDFAttributeMap reducedMap = partMap.clone();
            StringArray partIDKeys = this.resourceRoot.getPartIDKeyList();
            reducedMap.reduceMap(partIDKeys);
            for (int i = partIDKeys.size(); i >= 0; --i) {
                if (i < partIDKeys.size()) {
                    reducedMap.remove(partIDKeys.get(i));
                }
                if (reducedMap.size() == size) continue;
                size = reducedMap.size();
                JDFResource mapRes = this.leafMap.get(reducedMap);
                if (mapRes != null) {
                    return reducedMap;
                }
                JDFAttributeMap pv = this.checkPV(reducedMap, partUsage);
                if (pv == null) continue;
                return pv;
            }
        }
        return new JDFAttributeMap();
    }

    public String toString() {
        return "PartitionGetter strict=" + this.strictPartVersion + " " + this.localPartMap + "\n" + this.resourceRoot.toString();
    }

    public boolean isFollowIdentical() {
        return this.followIdentical;
    }

    public void setFollowIdentical(boolean followIdentical) {
        this.followIdentical = followIdentical;
    }

    public PartitionGetter(JDFResource jdfResource) {
        this.resourceRoot = jdfResource.getResourceRoot();
        this.strictPartVersion = false;
        this.followIdentical = true;
        this.leafMap = this.resourceRoot.getPartitionMapper();
        this.localPartMap = jdfResource.getPartMap();
    }

    public VElement getPartitionVector(VJDFAttributeMap vm, JDFResource.EnumPartUsage partUsage) {
        if ((vm = this.getCompletePartMapVector(vm)) == null) {
            return null;
        }
        VJDFAttributeMap vMap = this.getPartitionMaps(vm, partUsage);
        VElement v = new VElement();
        for (JDFAttributeMap map : vMap) {
            JDFResource jdfResource = this.leafMap.get(map);
            if (jdfResource == null) continue;
            v.add(jdfResource);
        }
        return v;
    }

    public VJDFAttributeMap getPartitionMaps(VJDFAttributeMap vm, JDFResource.EnumPartUsage partUsage) {
        if (vm != null && this.resourceRoot.getImplicitPartitions() != null) {
            VJDFAttributeMap vmNew = new VJDFAttributeMap();
            for (JDFAttributeMap map : vm) {
                JDFAttributeMap removeImplicitPartions = this.removeImplicitPartions(map.clone(), partUsage);
                if (removeImplicitPartions == null || removeImplicitPartions.isEmpty()) continue;
                vmNew.add(removeImplicitPartions);
            }
            vmNew.unify();
            vm = vmNew;
        }
        VJDFAttributeMap v = new VJDFAttributeMap();
        if (ContainerUtil.getNonEmpty(vm) == null) {
            v.add(new JDFAttributeMap());
        } else {
            for (JDFAttributeMap map : vm) {
                JDFAttributeMapArray next = this.getPartitionMaps(map, partUsage, true);
                v.addAll(next);
            }
        }
        v.unify();
        return v;
    }

    VElement getPartitionLeafVector(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        VElement v = this.getPartitionVector(m, partUsage);
        VElement vNew = new VElement();
        for (KElement e : v) {
            JDFResource r = (JDFResource)e;
            List<JDFResource> vr = r.getLeafArray(false);
            vNew.addAll(vr);
        }
        vNew.unify();
        return vNew;
    }

    public VElement getPartitionVector(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        if ((m = this.getCompletePartMap(m, false)) == null) {
            return null;
        }
        JDFAttributeMapArray vMap = this.getPartitionMaps(m, partUsage, true);
        VElement v = new VElement();
        for (JDFAttributeMap map : vMap) {
            v.add(this.leafMap.get(map));
        }
        return v;
    }

    JDFAttributeMapArray getPartitionMaps(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage, boolean updateIdentical) {
        if (partUsage == null) {
            partUsage = this.resourceRoot.getPartUsage();
        }
        if (m != null) {
            m = this.removeImplicitPartions(m, partUsage);
        }
        JDFAttributeMap fast = this.getPartitionFromMap(m, JDFResource.EnumPartUsage.Explicit);
        if (updateIdentical && fast != null) {
            fast = this.updateIdentical(fast);
        }
        JDFAttributeMapArray v = fast != null ? new JDFAttributeMapArray(fast) : this.specialSearch(m, partUsage);
        return v;
    }

    JDFAttributeMapArray specialSearch(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        int maxSize = 1 + this.lastPos(m, this.resourceRoot.getPartIDKeys(), true);
        JDFAttributeMapArray v = new JDFAttributeMapArray();
        JDFAttributeMapArray vExp = JDFResource.EnumPartUsage.Implicit.equals((Object)partUsage) && !this.resourceRoot.getPartIDKeyList().contains("PartVersion") ? new JDFAttributeMapArray() : null;
        for (JDFAttributeMap map : this.leafMap.keySet()) {
            if (map.size() > maxSize) continue;
            if (JDFPart.subPartMap(map, m, this.strictPartVersion)) {
                v.add(map);
                if (vExp == null) continue;
                vExp.add(map);
                continue;
            }
            if (JDFResource.EnumPartUsage.Implicit.equals((Object)partUsage) && JDFPart.overlapPartMap(map, m, this.strictPartVersion)) {
                v.add(map);
                continue;
            }
            if (!JDFResource.EnumPartUsage.Sparse.equals((Object)partUsage) || !JDFPart.overlapPartMap(map, m, this.strictPartVersion) || this.leafMap.get(map).getDirectPartition(0) != null) continue;
            v.add(map);
        }
        if (!ContainerUtil.isEmpty(vExp)) {
            v = vExp;
        }
        v.unify();
        if (JDFResource.EnumPartUsage.Implicit.equals((Object)partUsage)) {
            this.removeImplicitDuplicates(v);
        }
        return v;
    }

    void removeImplicitDuplicates(JDFAttributeMapArray v) {
        block0: for (int i = v.size() - 1; i >= 0; --i) {
            for (int j = i - 1; j >= 0; --j) {
                if (v.get(j).subMap(v.get(i))) {
                    v.remove(i);
                    continue block0;
                }
                if (!v.get(i).subMap(v.get(j))) continue;
                v.remove(j);
                --i;
            }
        }
    }

    private JDFAttributeMap updateIdentical(JDFAttributeMap fast) {
        if (fast != null && this.isFollowIdentical()) {
            JDFAttributeMap idMap;
            JDFResource r = this.leafMap.get(fast);
            JDFAttributeMap jDFAttributeMap = idMap = r == null ? null : r.getIdenticalMap();
            if (idMap != null) {
                return idMap;
            }
        }
        return fast;
    }

    private JDFAttributeMap removeImplicitPartions(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        if (m == null || m.isEmpty()) {
            return m;
        }
        Vector<JDFResource.EnumPartIDKey> v = this.resourceRoot.getImplicitPartitions();
        m = new JDFAttributeMap(m);
        if (v != null) {
            for (JDFResource.EnumPartIDKey e : v) {
                m.remove(e.getName());
            }
        }
        if (!JDFResource.EnumPartUsage.Explicit.equals((Object)partUsage)) {
            m.reduceMap(this.leafMap.getPartIDKeys());
        }
        return m;
    }

    public JDFResource getPartition(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        JDFAttributeMap map2;
        JDFAttributeMap map0 = this.getCompletePartMap(m, false);
        if (map0 == null) {
            return null;
        }
        JDFAttributeMap map = this.getPartitionImpl(map0, partUsage);
        if (map != null && !map.equals(map2 = this.updateIdentical(map))) {
            map = this.getPartitionImpl(map2, partUsage);
        }
        return map == null ? null : this.leafMap.get(map);
    }

    JDFAttributeMap getPartitionImpl(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        if (m.isEmpty()) {
            return m;
        }
        if (this.leafMap.get(m) != null) {
            return m;
        }
        if (partUsage == null) {
            partUsage = this.resourceRoot.getPartUsage();
        }
        if ((m = this.removeImplicitPartions(m, partUsage)).isEmpty()) {
            return m;
        }
        JDFAttributeMap partitionFromMap = this.getPartitionFromMap(m, partUsage);
        if (partitionFromMap == null || !m.equals(partitionFromMap) && !JDFPart.getFastparts().containsAll(partitionFromMap.keySet())) {
            partitionFromMap = this.reducePartMap(m, partUsage);
        }
        return partitionFromMap;
    }

    JDFAttributeMap reducePartMap(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        JDFAttributeMap partitionFromMap = null;
        JDFAttributeMapArray vMap = this.getPartitionMaps(m, partUsage, false);
        if (vMap != null) {
            if (vMap.size() == 1) {
                partitionFromMap = vMap.get(0);
            } else if (vMap.size() > 1) {
                if (JDFResource.EnumPartUsage.Explicit.equals((Object)partUsage)) {
                    partitionFromMap = null;
                } else {
                    partitionFromMap = vMap.getCommonMap();
                    StringArray partIDKeys = this.resourceRoot.getPartIDKeyList();
                    int lastPos = this.lastPos(partitionFromMap, partIDKeys, false) - 1;
                    int firstPos = this.firstPos(partitionFromMap, partIDKeys);
                    for (int i = Math.max(firstPos, lastPos); i < partIDKeys.size(); ++i) {
                        partitionFromMap.remove(partIDKeys.get(i));
                    }
                }
            }
        }
        return partitionFromMap;
    }

    int firstPos(JDFAttributeMap partitionFromMap, List<String> partIDKeys) {
        int firstPos = 0;
        for (String key : partIDKeys) {
            if (partitionFromMap.get(key) == null) break;
            ++firstPos;
        }
        return firstPos;
    }

    protected JDFResource getDeepPart(JDFAttributeMap m, JDFResource.EnumPartUsage partUsage) {
        JDFResource retRes = null;
        StringArray partIDKeys = this.resourceRoot.getPartIDKeyList();
        VElement vRes = this.getPartitionVector(m, partUsage);
        if (vRes != null) {
            int siz = vRes.size();
            if (siz == 0) {
                return retRes;
            }
            if (siz == 1) {
                retRes = (JDFResource)vRes.elementAt(0);
            } else {
                JDFResource e = (JDFResource)vRes.elementAt(0);
                if (e.isResourceRoot()) {
                    return e;
                }
                e = (JDFResource)e.getParentNode();
                do {
                    int i = 0;
                    for (i = siz - 1; i > 0; --i) {
                        if (e.isAncestor(vRes.elementAt(i))) continue;
                        e = (JDFResource)e.getParentNode();
                        break;
                    }
                    if (i != 0) continue;
                    retRes = e;
                    break;
                } while (e != this.resourceRoot);
                if (e.isResourceRoot()) {
                    return e;
                }
            }
        }
        if (retRes == null) {
            return null;
        }
        int retSize = -1;
        JDFResource loopRes = retRes;
        Set<String> vKeys = m.keySet();
        do {
            JDFAttributeMap returnMap = loopRes.getPartMap(partIDKeys);
            returnMap.reduceMap(vKeys);
            if (returnMap.size() < retSize) {
                return retRes;
            }
            if (retSize == -1) {
                retSize = returnMap.size();
            }
            if (loopRes == this.resourceRoot || loopRes.isResourceRoot()) {
                return loopRes;
            }
            retRes = loopRes;
        } while ((loopRes = (JDFResource)loopRes.getParentNode()) != null);
        throw new JDFException("JDFResource::GetDeepPart ran into null element while searching tree, ID=" + this.resourceRoot.getID());
    }

    private List<String> reorderPartKeys(List<String> vPartKeys) {
        if (vPartKeys == null || vPartKeys.isEmpty()) {
            return this.resourceRoot.getPartIDKeys();
        }
        StringArray vPartIDKeys = new StringArray((Collection<String>)vPartKeys);
        StringArray vExistingPartKeys = this.resourceRoot.getPartIDKeyList();
        StringArray vTmpPartIDKeys = new StringArray();
        if (vExistingPartKeys != null && !vExistingPartKeys.isEmpty()) {
            int i;
            boolean allIn = true;
            for (int i2 = 0; allIn && i2 < vPartIDKeys.size(); ++i2) {
                if (vExistingPartKeys.contains(vPartIDKeys.get(i2))) continue;
                allIn = false;
            }
            if (allIn) {
                return vExistingPartKeys;
            }
            int n = vExistingPartKeys.size();
            if (vPartIDKeys.size() < n) {
                n = vPartIDKeys.size();
            }
            for (i = 0; i < n; ++i) {
                String partKey = vExistingPartKeys.get(i);
                if (!vPartIDKeys.contains(partKey)) {
                    throw new JDFException("reorderPartKeys: reordering incompatible partitions for ID=" + this.resourceRoot.getID() + ". Key: " + partKey + " " + vPartIDKeys);
                }
                vTmpPartIDKeys.add(partKey);
                vPartIDKeys.remove(partKey);
            }
            for (i = 0; i < vPartIDKeys.size(); ++i) {
                vTmpPartIDKeys.add(vPartIDKeys.get(i));
            }
            vPartIDKeys = vTmpPartIDKeys;
        }
        return vPartIDKeys;
    }

    public JDFResource getCreatePartition(JDFAttributeMap partMap, VString vPartKeys) {
        int s;
        if ((partMap = this.getCompletePartMap(partMap, true)) == null || partMap.isEmpty()) {
            return this.resourceRoot.getResourceRoot();
        }
        JDFResource r = this.getPartition(partMap, JDFResource.EnumPartUsage.Explicit);
        if (r != null) {
            return r;
        }
        r = this.getPartition(partMap, JDFResource.EnumPartUsage.Implicit);
        JDFAttributeMap thisMap = r.getPartMap();
        StringArray localKeys = thisMap.getKeyList();
        if (thisMap.size() == partMap.size()) {
            return r;
        }
        List<String> vPartIDKeys = this.updatePartIDKeys(partMap, vPartKeys);
        this.resourceRoot.setPartIDKeyList(vPartIDKeys);
        int n = s = vPartIDKeys == null ? 0 : vPartIDKeys.size();
        if (s < partMap.size()) {
            throw new JDFException("GetCreatePartition: " + this.resourceRoot.getNodeName() + " ID=" + this.resourceRoot.getID() + "insufficient partIDKeys " + this.leafMap.getPartIDKeys() + " for " + partMap);
        }
        JDFAttributeMap map = thisMap;
        for (int i = localKeys.size(); i < partMap.size(); ++i) {
            String value;
            String key = vPartIDKeys == null ? null : vPartIDKeys.get(i);
            String string = value = key == null ? null : partMap.get(key);
            if (value == null) {
                throw new JDFException("GetCreatePartition: " + this.resourceRoot.getNodeName() + " ID=" + this.resourceRoot.getID() + " attempting to fill non-matching partIDKeys: " + key + " valid keys: Current PartIDKeys: " + this.resourceRoot.getPartIDKeys() + " complete map: " + partMap);
            }
            r = (JDFResource)r.appendElementRaw(this.resourceRoot.getNodeName(), this.resourceRoot.getNamespaceURI());
            r.init();
            r.setAttribute(key, value);
            map = map.clone();
            map.put(key, value);
            this.leafMap.put(map, r);
        }
        return r;
    }

    List<String> updatePartIDKeys(JDFAttributeMap partMap, List<String> vPartKeys) {
        int size;
        int lastPos = 1 + this.lastPos(partMap, vPartKeys, false);
        int n = size = vPartKeys == null ? 0 : vPartKeys.size();
        if (vPartKeys != null && lastPos < size) {
            vPartKeys = new StringArray(vPartKeys);
            while (lastPos < size) {
                vPartKeys.remove(lastPos);
                --size;
            }
        }
        List<String> vPartIDKeys = this.reorderPartKeys(vPartKeys);
        StringArray newKeys = partMap.getKeyList();
        if (vPartIDKeys != null) {
            newKeys.removeAll(vPartIDKeys);
        }
        if (newKeys.size() == 1) {
            vPartIDKeys = (List<String>)ContainerUtil.addAll(vPartIDKeys, newKeys);
        } else if (newKeys.size() > 1) {
            vPartIDKeys = this.expandKeysFromNode(partMap, vPartIDKeys);
        }
        return vPartIDKeys;
    }

    JDFResource addPartition(JDFResource.EnumPartIDKey partType, String value) {
        String parentPart;
        int posOfType;
        JDFResource parent = this.getPartition(this.localPartMap, JDFResource.EnumPartUsage.Explicit);
        if (parent.isResourceElement()) {
            throw new JDFException("Attempting to add partition to resource element: " + parent.buildXPath(null, 1));
        }
        if (partType == null) {
            throw new JDFException("Attempting to add null partition to resource: " + parent.buildXPath(null, 1));
        }
        List<String> partIDKeys = this.leafMap.getPartIDKeys();
        int n = posOfType = partIDKeys == null ? -1 : partIDKeys.indexOf(partType.getName());
        if (posOfType < 0) {
            if (!parent.isLeaf()) {
                throw new JDFException("addPartition: adding inconsistent partition ID=" + this.resourceRoot.getID() + " - parent must be a leaf");
            }
        } else if (posOfType == 0) {
            if (!parent.isResourceRootRoot()) {
                throw new JDFException("addPartition: adding inconsistent partition ID=" + this.resourceRoot.getID() + " - must be root");
            }
        } else if (partIDKeys != null && !parent.hasAttribute_KElement(parentPart = partIDKeys.get(posOfType - 1), null, false)) {
            throw new JDFException("addPartition: adding inconsistent partition  ID=" + this.resourceRoot.getID() + "- parent must have partIDKey: " + parentPart);
        }
        if (partIDKeys == null || !partIDKeys.contains(partType.getName())) {
            this.resourceRoot.addPartIDKey(partType);
        }
        JDFAttributeMap map = parent.getPartMap();
        map.put(partType.getName(), value);
        JDFAttributeMap m = this.getPartitionFromMap(map, JDFResource.EnumPartUsage.Explicit);
        if (m != null) {
            throw new JDFException("addPartition: adding duplicate partition for ID=" + this.resourceRoot.getID() + " " + (Object)((Object)partType) + "=" + value);
        }
        JDFResource p = (JDFResource)parent.appendElementRaw(this.resourceRoot.getNodeName(), this.resourceRoot.getNamespaceURI());
        p.init();
        p.setPartIDKey(partType, value);
        return p;
    }

    public VElement createPartitions(VJDFAttributeMap vPartMap, VString vPartIDKeys) {
        VElement v = new VElement();
        if (vPartMap != null) {
            List<String> currentPartIDKeys = this.resourceRoot.getPartIDKeys();
            currentPartIDKeys = (List)ContainerUtil.appendUnique(currentPartIDKeys, vPartIDKeys);
            VJDFAttributeMap newMaps = this.updateCreate(vPartMap, currentPartIDKeys);
            for (JDFAttributeMap partMap : newMaps) {
                v.add(this.getCreatePartition(partMap, vPartIDKeys));
            }
        }
        return v;
    }

    private VJDFAttributeMap updateCreate(VJDFAttributeMap vPartMap, List<String> vPartIDKeys) {
        VJDFAttributeMap newMap = new VJDFAttributeMap();
        for (JDFAttributeMap map : vPartMap) {
            for (JDFAttributeMap key : this.leafMap.keySet()) {
                JDFAttributeMap next;
                if (!key.overlapMap(map) || this.hasGap(next = map.getOrMap(key), vPartIDKeys)) continue;
                newMap.add(next);
            }
        }
        newMap.unify();
        return newMap;
    }

    boolean hasGap(JDFAttributeMap next, List<String> vPartIDKeys) {
        if (vPartIDKeys == null) {
            vPartIDKeys = this.resourceRoot.getPartIDKeys();
        }
        return this.lastPos(next, vPartIDKeys, false) > next.size() - 1;
    }

    int lastPos(JDFAttributeMap next, List<String> vPartIDKeys, boolean newIsGap) {
        int last = -1;
        if (vPartIDKeys != null) {
            Set keys = next.keySet();
            for (String pik : keys) {
                int nextlast = vPartIDKeys.indexOf(pik);
                if (newIsGap && nextlast == -1) {
                    nextlast = Math.max(vPartIDKeys.size(), next.size());
                }
                last = Math.max(last, nextlast);
            }
        }
        return last;
    }

    private List<String> expandKeysFromNode(JDFAttributeMap partMap, List<String> vPartIDKeys) {
        int partKeySize;
        JDFNode n = this.resourceRoot.getParentJDF();
        if (n == null) {
            return vPartIDKeys;
        }
        VString nodeKeys = n.getPartIDKeys(partMap);
        int nodeKeySize = nodeKeys.size();
        int n2 = partKeySize = vPartIDKeys != null ? vPartIDKeys.size() : 0;
        if (nodeKeySize <= partKeySize) {
            return vPartIDKeys;
        }
        if (vPartIDKeys != null) {
            Iterator nodeKeysIterator = nodeKeys.iterator();
            Iterator<String> vPartIDKeysIterator = vPartIDKeys.iterator();
            while (vPartIDKeysIterator.hasNext()) {
                if (vPartIDKeysIterator.next().equals(nodeKeysIterator.next())) continue;
                return vPartIDKeys;
            }
        }
        return nodeKeys;
    }

    public void setStrictPartVersion(boolean strictPartVersion) {
        this.strictPartVersion = strictPartVersion;
    }

    JDFAttributeMap getCompletePartMap(JDFAttributeMap partMap, boolean create) {
        if (this.localPartMap.isEmpty()) {
            return partMap == null ? this.localPartMap : partMap;
        }
        if (partMap != null && !partMap.isEmpty()) {
            if (!JDFPart.overlapPartMap(this.localPartMap, partMap, this.strictPartVersion)) {
                if (create) {
                    throw new JDFException("Incompatible part maps: local: " + this.localPartMap.showKeys(null) + " request: " + partMap.showKeys(null) + " ID=" + this.resourceRoot.getID());
                }
                return null;
            }
            JDFAttributeMap clone = partMap.clone();
            clone.putAll(this.localPartMap);
            return clone;
        }
        return this.localPartMap;
    }

    VJDFAttributeMap getCompletePartMapVector(VJDFAttributeMap vm) {
        if (vm == null) {
            vm = new VJDFAttributeMap();
        }
        if (vm.isEmpty()) {
            vm.add(new JDFAttributeMap());
        }
        if (this.localPartMap.isEmpty()) {
            return vm;
        }
        VJDFAttributeMap newMap = new VJDFAttributeMap();
        for (JDFAttributeMap m : vm) {
            JDFAttributeMap completePartMap = this.getCompletePartMap(m, false);
            if (completePartMap == null) continue;
            newMap.add(completePartMap);
        }
        return newMap.size() > 0 ? newMap : null;
    }
}

