/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.Collection;
import java.util.List;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.ifaces.IXJDFSplit;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.process.JDFColor;

public class XJDFToJDFConverter
extends XJDFToJDFImpl {
    protected IXJDFSplit splitter = null;
    private static StringArray resLinkAttribs;
    public static final String SIG = "Sig_";

    public static StringArray getResLinkAttribs() {
        if (resLinkAttribs == null) {
            resLinkAttribs = new StringArray(new String[]{"ProcessUsage", "Amount", "ActualAmount", "MaxAmount", "MinAmount", "CombinedProcessIndex"});
        }
        return resLinkAttribs;
    }

    public XJDFToJDFConverter(JDFDoc template) {
        super(template);
    }

    @Override
    public JDFDoc convert(KElement xjdf) {
        JDFDoc d = null;
        if (this.needSplit(xjdf)) {
            Collection<XJDFHelper> vSplit = this.splitter.splitXJDF(new XJDFHelper(xjdf));
            if (vSplit == null || vSplit.size() == 0) {
                this.log.error((Object)"no xjdf elements returned by splitter");
            } else {
                for (XJDFHelper h : vSplit) {
                    d = super.convert(h.getRoot());
                    this.setCreateProduct(false);
                }
            }
        } else {
            d = super.convert(xjdf);
        }
        if (d != null) {
            this.mapActualColors(d);
        }
        return d;
    }

    void mapActualColors(JDFDoc d) {
        KElement root = d.getRoot();
        List<JDFColor> vc = root.getChildArrayByClass(JDFColor.class, true, 0);
        if (vc != null) {
            for (JDFColor c : vc) {
                this.fixColor(root, c);
            }
        }
    }

    void fixColor(KElement root, JDFColor c) {
        c.removeChildrenByClass(JDFPart.class);
        String actual = c.getActualColorName();
        String name = c.getName();
        if (!name.equals(actual)) {
            c.setName(actual);
            VElement v = root.getChildrenByTagName(null, null, new JDFAttributeMap("Separation", name), false, true, 0);
            for (KElement e : v) {
                e.setAttribute("Separation", actual);
            }
            VElement w = root.getChildrenByTagName("SeparationSpec", null, new JDFAttributeMap("Name", name), false, true, 0);
            for (KElement e : w) {
                e.setAttribute("Name", actual);
            }
        }
    }

    public JDFDoc convert(XJDFHelper helper) {
        KElement e = helper == null ? null : helper.getRoot();
        return e == null ? null : this.convert(e);
    }

    protected boolean needSplit(KElement xjdf) {
        return this.splitter != null && XJDFHelper.isXJDF(xjdf);
    }

    public void setSplitter(IXJDFSplit splitter) {
        this.splitter = splitter;
    }
}

