/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.mime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.URLReader;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.BodyPartHelper;
import org.cip4.jdflib.util.mime.MimeHelper;
import org.cip4.jdflib.util.mime.MimeWriter;

public class MimeReader
extends MimeHelper {
    public MimeReader() {
    }

    public MimeReader(Multipart mp) {
        super(mp);
    }

    public MimeReader(InputStream mimeStream) {
        this.theMultipart = this.getMultiPart(mimeStream);
    }

    public MimeReader(MimeWriter writer) {
        this.theMultipart = writer.getMultiPart();
    }

    public MimeReader(String url) {
        this.theMultipart = this.getMultiPart(url);
    }

    private Multipart getMultiPart(InputStream mimeStream) {
        if (mimeStream == null) {
            return null;
        }
        try {
            mimeStream = StreamUtil.getBufferedInputStream(mimeStream);
            MimeMessage mimeMessage = new MimeMessage(null, mimeStream);
            MimeMultipart mp = new MimeMultipart(mimeMessage.getDataHandler().getDataSource());
            return mp;
        }
        catch (MessagingException e) {
            this.log.info((Object)"Snafu reading mime", (Throwable)e);
            return null;
        }
    }

    private Multipart getMultiPart(String fileName) {
        File f = UrlUtil.urlToFile(fileName);
        try {
            ByteArrayIOStream bis = new ByteArrayIOStream(f);
            Multipart mp = this.getMultiPart(bis.getInputStream());
            bis.close();
            return mp;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public JDFDoc getJDFDoc(InputStream stream, int index) {
        XMLDoc xmlDoc = this.getXMLDoc(stream, index);
        return xmlDoc == null ? null : new JDFDoc(xmlDoc);
    }

    public XMLDoc getXMLDoc(InputStream stream, int index) {
        ByteArrayIOStream.ByteArrayIOInputStream bis = ByteArrayIOStream.getBufferedInputStream(stream);
        bis.mark(42);
        Multipart mp = this.getMultiPart(bis);
        if (mp != null) {
            this.theMultipart = mp;
            BodyPartHelper bph = this.getBodyPartHelper(index);
            if (bph != null) {
                return bph.getXMLDoc();
            }
        }
        if (index == 0) {
            bis.seek(0L);
            return XMLDoc.parseStream(bis);
        }
        return null;
    }

    public InputStream getURLInputStream(String urlString) {
        BodyPartHelper bp = this.getPartHelperByCID(urlString);
        if (bp == null) {
            bp = this.getPartHelperByLocalName(urlString);
        }
        if (bp != null) {
            return bp.getInputStream();
        }
        return new URLReader(urlString).getURLInputStream();
    }

    public String getFileName(String url) {
        BodyPartHelper bp = this.getPartHelperByCID(url);
        if (bp != null) {
            return bp.getFileName();
        }
        return UrlUtil.urlToFileName(url);
    }
}

