/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.HashMap;
import java.util.Vector;
import javax.mail.BodyPart;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ParentNode;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.zip.ZipReader;
import org.w3c.dom.Element;

public class DocumentXMLImpl
extends DocumentImpl {
    private static final long serialVersionUID = 1L;
    private static boolean bStaticStrictNSCheck = true;
    private boolean ignoreNSDefault;
    private boolean strictNSCheck;
    public XMLDoc m_validationResult = null;
    protected long initialMem;
    boolean bGlobalDirtyPolicy = true;
    protected String m_OriginalFileName = null;
    protected BodyPart m_Bodypart = null;
    protected ZipReader m_ZipReader = null;
    protected final HashMap<String, String> nsMap;

    public static boolean isStaticStrictNSCheck() {
        return bStaticStrictNSCheck;
    }

    public static void setStaticStrictNSCheck(boolean staticStrictNSCheck) {
        bStaticStrictNSCheck = staticStrictNSCheck;
    }

    public boolean isStrictNSCheck() {
        return this.strictNSCheck;
    }

    public void setStrictNSCheck(boolean strictNSCheck) {
        this.strictNSCheck = strictNSCheck;
    }

    public long getDocMemoryUsed() {
        Runtime rt = Runtime.getRuntime();
        long mem = rt.totalMemory() - rt.freeMemory();
        if (mem < this.initialMem) {
            this.initialMem = mem;
        }
        return mem - this.initialMem;
    }

    public DocumentXMLImpl clone() {
        DocumentXMLImpl clon;
        try {
            clon = (DocumentXMLImpl)((Object)super.clone());
        }
        catch (CloneNotSupportedException x) {
            clon = new DocumentXMLImpl();
        }
        clon.m_Bodypart = this.m_Bodypart;
        clon.m_OriginalFileName = this.m_OriginalFileName;
        clon.docElement = ((KElement)this.docElement).cloneRoot(new XMLDoc(clon));
        clon.ownerDocument = clon;
        clon.firstChild = clon.docElement;
        clon.nsMap.clear();
        clon.setNSMap(this);
        return clon;
    }

    void setNSMap(DocumentXMLImpl documentJDFImpl) {
        Vector<String> keys;
        if (documentJDFImpl == null) {
            return;
        }
        this.nsMap.putAll(documentJDFImpl.nsMap);
        Element e = this.getDocumentElement();
        if (e != null && (keys = ContainerUtil.getKeyVector(this.nsMap)) != null) {
            for (int i = 0; i < keys.size(); ++i) {
                String prefix = keys.get(i);
                this.setRootNSAttribute(prefix, this.nsMap.get(prefix));
            }
        }
    }

    public DocumentXMLImpl() {
        Runtime rt = Runtime.getRuntime();
        this.initialMem = rt.totalMemory() - rt.freeMemory();
        this.nsMap = new HashMap();
        this.ignoreNSDefault = false;
        this.strictNSCheck = bStaticStrictNSCheck;
    }

    public Element createElement(String qualifiedName) {
        String namespaceURI = null;
        String localPart = KElement.xmlnsLocalName(qualifiedName);
        return this.createElementNS(namespaceURI, qualifiedName, localPart);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        String localPart = KElement.xmlnsLocalName(qualifiedName);
        return this.createElementNS(namespaceURI, qualifiedName, localPart);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName, String localPart) {
        return new KElement((CoreDocumentImpl)this, namespaceURI, qualifiedName, localPart);
    }

    KElement factoryCreate(ParentNode parent, String qualifiedName) {
        return (KElement)this.createElement(qualifiedName);
    }

    KElement factoryCreate(ParentNode parent, String namespaceURI, String qualifiedName) {
        return (KElement)this.createElementNS(namespaceURI, qualifiedName);
    }

    public String toString() {
        Element rootElement = this.getDocumentElement();
        if (rootElement != null) {
            return super.toString() + rootElement.toString();
        }
        return super.toString();
    }

    public boolean isIgnoreNSDefault() {
        return this.ignoreNSDefault;
    }

    public void setIgnoreNSDefault(boolean _setIgnoreNSDefault) {
        this.ignoreNSDefault = _setIgnoreNSDefault;
    }

    public String getNamespaceURIFromPrefix(String prefix) {
        if (this.ignoreNSDefault) {
            return null;
        }
        if (prefix == null) {
            prefix = ":";
        }
        return this.nsMap.get(prefix);
    }

    public void setNamespaceURIFromPrefix(String prefix, String strNamespaceURI) {
        String old;
        if (StringUtil.getNonEmpty(prefix) == null) {
            prefix = ":";
        }
        if ((old = this.nsMap.get(prefix)) == null) {
            this.setRootNSAttribute(prefix, strNamespaceURI);
            this.nsMap.put(prefix, strNamespaceURI);
        }
    }

    private void setRootNSAttribute(String prefix, String strNamespaceURI) {
        KElement element;
        String qualifiedName = "xmlns";
        if (!":".equals(prefix)) {
            qualifiedName = qualifiedName + ":" + prefix;
        }
        if ((element = (KElement)this.getDocumentElement()) != null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", qualifiedName, strNamespaceURI);
        }
    }

    public boolean isDirty() {
        return this.changes > 0;
    }

    public void clearDirty() {
        this.changes = 0;
    }
}

