/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAudit;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFAudit
extends JDFAutoAudit
implements Comparator<JDFAudit> {
    private static final String LIB_VERSION = "lib.version";
    private static final String LIB_NAME = "lib.name";
    private static final String m_libAgentName = "CIP4 JDF Writer Java";
    private static final String m_libAgentVersion = "2.1.7 BLD 018";
    private static final long serialVersionUID = 1L;
    private static String m_strAgentName = JDFAudit.readBuildProperty("lib.name");
    private static String m_strAgentVersion = JDFAudit.readBuildProperty("lib.version");
    private static String m_strAuthor = null;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[1];

    static String readBuildProperty(String key) {
        Properties props = new Properties();
        String def = LIB_NAME.equals(key) ? m_libAgentName : (LIB_VERSION.equals(key) ? m_libAgentVersion : "n. a.");
        try {
            InputStream s = JDFAudit.class.getResourceAsStream("/org/cip4/jdflib/build.properties");
            if (s == null) {
                return def;
            }
            props.load(s);
        }
        catch (IOException e) {
            return def;
        }
        String property = props.getProperty(key, def);
        return property.startsWith("@") || property.isEmpty() ? def : property;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFAudit(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFAudit[ -->" + super.toString() + "]";
    }

    @Override
    public int compare(JDFAudit a1, JDFAudit a2) {
        JDFDate d1 = a1.getTimeStamp();
        JDFDate d2 = a2.getTimeStamp();
        return ContainerUtil.compare(d1, d2);
    }

    @Deprecated
    public void setSeverity(EnumSeverity s) {
        this.setAttribute("Severity", s.getName(), null);
    }

    @Deprecated
    public EnumSeverity getSeverity() {
        return EnumSeverity.getEnum(this.getAttribute("Severity", null, null));
    }

    @Override
    public void setStatus(JDFElement.EnumNodeStatus s) {
        this.setAttribute("Status", s == null ? null : s.getName(), null);
    }

    @Deprecated
    public void setEndStatus(JDFElement.EnumNodeStatus s) {
        this.setAttribute("EndStatus", s.getName(), null);
    }

    protected JDFElement.EnumNodeStatus getEndStatus() {
        return JDFElement.EnumNodeStatus.getEnum(this.getAttribute("EndStatus", null, null));
    }

    public EnumAuditType getAuditType() {
        String nam = this.getLocalName();
        return EnumAuditType.getEnum(nam);
    }

    @Deprecated
    public JDFElement.EnumNodeStatus getPhase() {
        if (!this.getNodeName().equals("PhaseTime")) {
            return null;
        }
        return super.getStatus();
    }

    @Deprecated
    public void setPart(JDFAttributeMap m) {
        super.setPartMap(m);
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public JDFAttributeMapArray getPartMapArray() {
        return super.getPartMapArray();
    }

    public void setRef(JDFAudit previous) {
        if (previous != null) {
            String id = previous.appendAnchor(null);
            this.setrefID(id);
        }
    }

    @Deprecated
    public void setBy(String by) {
        if (by == null || by.equals("")) {
            return;
        }
        this.setAttribute("Author", by, "");
    }

    public void updateAgent(String by) {
        if (!StringUtil.isEmpty(by)) {
            this.setAgentName(this.getAgentName() + ": " + by);
        }
    }

    public static String software() {
        return m_strAgentName + " " + m_strAgentVersion;
    }

    @Override
    public boolean init() {
        JDFElement.EnumVersion auditVersion = this.getVersion(true);
        this.setAttributeNameTimeStamp("TimeStamp", null);
        if (auditVersion == null || auditVersion.getValue() >= JDFElement.EnumVersion.Version_1_2.getValue()) {
            this.setAgentName(m_strAgentName);
            this.setAgentVersion(m_strAgentVersion);
        }
        if (m_strAuthor != null) {
            if (EnumUtil.aLessThanB(this.getVersion(true), JDFElement.EnumVersion.Version_1_4)) {
                this.setAuthor(m_strAuthor);
            } else {
                this.getCreateEmployee(0).setDescriptiveName(m_strAuthor);
            }
        }
        if (!(auditVersion != null && auditVersion.getValue() < JDFElement.EnumVersion.Version_1_3.getValue() || this.isXJDF())) {
            this.appendAnchor(null);
        }
        return super.init();
    }

    @Override
    public String getIDPrefix() {
        return "a";
    }

    @Deprecated
    public void setTimeStamp() {
        this.setTimeStamp(null);
    }

    @Deprecated
    public JDFDate getTimeStampDate() {
        return this.getTimeStamp();
    }

    public JDFAuditPool getAuditPool() {
        return (JDFAuditPool)this.getDeepParent("AuditPool", 0);
    }

    public JDFAudit createUpdateAudit() {
        JDFAuditPool pool = this.getAuditPool();
        if (pool == null) {
            return null;
        }
        JDFAudit copy = (JDFAudit)pool.copyElement(this, null);
        copy.removeAttribute("ID");
        copy.removeAttribute("AgentName");
        copy.removeAttribute("AgentVersion");
        copy.init();
        copy.setRef(this);
        return copy;
    }

    public JDFAudit getUpdatedPreviousAudit() {
        String refID = this.getrefID();
        if (StringUtil.getNonEmpty(refID) == null) {
            return null;
        }
        JDFAuditPool pool = this.getAuditPool();
        if (pool == null) {
            throw new JDFException("Updating audit that is not in an audit pool");
        }
        return (JDFAudit)pool.getChildWithAttribute(null, "ID", null, refID, 0, true);
    }

    public static synchronized String getStaticAgentName() {
        if (m_strAgentName == null) {
            m_strAgentName = JDFAudit.readBuildProperty(LIB_NAME);
        }
        return StringUtil.getNonEmpty(m_strAgentName);
    }

    public static synchronized void setStaticAgentName(String agentName) {
        m_strAgentName = agentName == null ? "" : agentName;
    }

    public static synchronized String getStaticAuthor() {
        return m_strAuthor;
    }

    public static synchronized void setStaticAuthor(String author) {
        m_strAuthor = author;
    }

    public static synchronized String getStaticAgentVersion() {
        if (m_strAgentVersion == null) {
            m_strAgentVersion = JDFAudit.readBuildProperty(LIB_VERSION);
        }
        return StringUtil.getNonEmpty(m_strAgentVersion);
    }

    public static synchronized void setStaticAgentVersion(String agentVersion) {
        m_strAgentVersion = agentVersion == null ? "" : agentVersion;
    }

    public JDFEmployee getCreateEmployee(int iSkip) {
        return (JDFEmployee)this.getCreateElement_KElement("Employee", null, iSkip);
    }

    public JDFEmployee getEmployee(int iSkip) {
        return (JDFEmployee)this.getElement("Employee", null, iSkip);
    }

    public Collection<JDFEmployee> getAllEmployee() {
        Vector<JDFEmployee> v = new Vector<JDFEmployee>();
        for (JDFEmployee kElem = (JDFEmployee)this.getFirstChildElement("Employee", null); kElem != null; kElem = (JDFEmployee)kElem.getNextSiblingElement("Employee", null)) {
            v.add(kElem);
        }
        return v;
    }

    public JDFEmployee appendEmployee() throws JDFException {
        return (JDFEmployee)this.appendElement("Employee", null);
    }

    static {
        JDFAudit.elemInfoTable[0] = new ElemInfoTable("Employee", 0x33331111L);
    }

    public static final class EnumSeverity
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumSeverity Event = new EnumSeverity("Event");
        public static final EnumSeverity Information = new EnumSeverity("Information");
        public static final EnumSeverity Warning = new EnumSeverity("Warning");
        public static final EnumSeverity Error = new EnumSeverity("Error");
        public static final EnumSeverity Fatal = new EnumSeverity("Fatal");

        private EnumSeverity(String name) {
            super(name, m_startValue++);
        }

        public static EnumSeverity getEnum(String enumName) {
            return (EnumSeverity)EnumSeverity.getEnum(EnumSeverity.class, (String)enumName);
        }

        public static EnumSeverity getEnum(int enumValue) {
            return (EnumSeverity)EnumSeverity.getEnum(EnumSeverity.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumSeverity.getEnumMap(EnumSeverity.class);
        }

        public static List getEnumList() {
            return EnumSeverity.getEnumList(EnumSeverity.class);
        }

        public static Iterator iterator() {
            return EnumSeverity.iterator(EnumSeverity.class);
        }
    }

    public static class EnumAuditType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumAuditType Created = new EnumAuditType("Created");
        public static final EnumAuditType Modified = new EnumAuditType("Modified");
        public static final EnumAuditType Deleted = new EnumAuditType("Deleted");
        public static final EnumAuditType Spawned = new EnumAuditType("Spawned");
        public static final EnumAuditType Merged = new EnumAuditType("Merged");
        public static final EnumAuditType Notification = new EnumAuditType("Notification");
        public static final EnumAuditType PhaseTime = new EnumAuditType("PhaseTime");
        public static final EnumAuditType ResourceAudit = new EnumAuditType("ResourceAudit");
        public static final EnumAuditType ProcessRun = new EnumAuditType("ProcessRun");

        protected EnumAuditType(String name) {
            super(name, m_startValue++);
        }

        public static EnumAuditType getEnum(String enumName) {
            return (EnumAuditType)EnumAuditType.getEnum(EnumAuditType.class, (String)enumName);
        }

        public static EnumAuditType getEnum(int enumValue) {
            return (EnumAuditType)EnumAuditType.getEnum(EnumAuditType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumAuditType.getEnumMap(EnumAuditType.class);
        }

        public static List getEnumList() {
            return EnumAuditType.getEnumList(EnumAuditType.class);
        }

        public static Iterator iterator() {
            return EnumAuditType.iterator(EnumAuditType.class);
        }
    }
}

