/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.StringUtil;

public class XMLCompareWalker
extends BaseElementWalker {
    final Map<String, MyPair<String, String>> theMap = new HashMap<String, MyPair<String, String>>();
    private boolean first;
    private double precision;
    private int method = 1;
    private final KElement e2;
    private final KElement e1;
    private final Set<String> ignore;
    private final Set<String> ignoreValue;

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public Map<String, MyPair<String, String>> compare() {
        this.theMap.clear();
        this.first = true;
        this.walkTree(this.e1, this.e2);
        this.first = false;
        this.walkTree(this.e2, this.e1);
        return this.theMap;
    }

    public XMLCompareWalker(KElement e1, KElement e2) {
        super(new BaseWalkerFactory());
        this.e1 = e1;
        this.e2 = e2;
        this.precision = -1.0;
        this.ignore = new HashSet<String>();
        this.ignoreValue = new HashSet<String>();
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public void addIgnore(Collection<String> keys, boolean valueOnly) {
        if (keys != null) {
            for (String key : keys) {
                this.addIgnore(key, valueOnly);
            }
        }
    }

    public void addIgnore(String key, boolean valueOnly) {
        if (!StringUtil.isEmpty(key)) {
            if (valueOnly) {
                this.ignoreValue.add(key);
            } else {
                this.ignore.add(key);
            }
        }
    }

    public class WalkAll
    extends BaseWalker {
        public WalkAll() {
            super(XMLCompareWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String myPath = e.buildRelativeXPath(e.getParentNode_KElement(), XMLCompareWalker.this.method);
            KElement eNew = trackElem == null ? null : trackElem.getXPathElement(myPath);
            VString keys = e.getAttributeVector();
            for (String key : keys) {
                MyPair<String, String> diff = this.myCompare(key, e.getAttribute(key), eNew == null ? null : eNew.getNonEmpty(key));
                if (diff == null) continue;
                String ret = e.buildRelativeXPath(XMLCompareWalker.this.first ? XMLCompareWalker.this.e1.getParentNode_KElement() : eNew.getParentNode_KElement(), XMLCompareWalker.this.method) + "/@" + key;
                XMLCompareWalker.this.theMap.put(ret, diff);
            }
            return eNew;
        }

        MyPair<String, String> myCompare(String key, String attribute, String attribute2) {
            if (this.wantKey(key)) {
                boolean ok;
                boolean bl = this.wantValue(key) ? StringUtil.equals(attribute, attribute2, XMLCompareWalker.this.precision) : (ok = StringUtil.isEmpty(attribute) == StringUtil.isEmpty(attribute2));
                if (!ok) {
                    return XMLCompareWalker.this.first ? new MyPair<String, String>(attribute, attribute2) : new MyPair<String, String>(attribute2, attribute);
                }
            }
            return null;
        }

        boolean wantKey(String key) {
            return !XMLCompareWalker.this.ignore.contains(key);
        }

        boolean wantValue(String key) {
            return !XMLCompareWalker.this.ignoreValue.contains(key);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return true;
        }
    }
}

