/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.util.StringUtil;

public class MiscConsumableMaker {
    private final ResourceHelper ph;
    private ResourceHelper miscPart;

    MiscConsumableMaker(ResourceHelper ph) {
        this.ph = ph;
        this.miscPart = null;
    }

    public ResourceHelper create(String consumableType, String processUsage) {
        XJDFHelper helper = this.ph.getXJDF();
        if (helper == null) {
            return null;
        }
        if (processUsage == null) {
            processUsage = consumableType;
        }
        SetHelper miscSet = helper.getCreateSet("MiscConsumable", JDFResourceLink.EnumUsage.Input, processUsage);
        this.miscPart = miscSet.getCreateVPartition(this.ph.getPartMapVector(), true);
        this.miscPart.getResource().setAttribute("Type", consumableType);
        return this.miscPart;
    }

    public String toString() {
        return "MiscConsumableMaker [misc=" + this.miscPart + "]";
    }

    public void setColor(String color) {
        if (this.miscPart != null && StringUtil.hasContent(color)) {
            this.miscPart.getCreateResource().setAttribute("Color", StringUtil.normalize(color));
        }
    }

    public void setColor(JDFElement.EnumNamedColor color) {
        if (this.miscPart != null && color != null) {
            this.miscPart.getCreateResource().setAttribute("Color", color.getName());
        }
    }

    public void setColorDetails(String color) {
        if (this.miscPart != null && StringUtil.hasContent(color)) {
            this.miscPart.getCreateResource().setAttribute("ColorDetails", StringUtil.normalize(color));
        }
    }

    public void setTypeDetails(String details) {
        if (this.miscPart != null && StringUtil.hasContent(details)) {
            this.miscPart.getCreateResource().setAttribute("TypeDetails", StringUtil.normalize(details));
        }
    }

    public void setBrand(String brand) {
        if (this.miscPart != null && StringUtil.hasContent(brand)) {
            this.miscPart.setBrand(StringUtil.normalize(brand));
        }
    }
}

