/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXJDFResource;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.resource.process.JDFColorPool;

public class WalkXJDFColorResource
extends WalkXJDFResource {
    @Override
    protected String getJDFResName(SetHelper sh) {
        return "ColorPool";
    }

    @Override
    protected KElement createPartition(JDFResource jdfRes, JDFAttributeMap partmap, JDFNode theNode) {
        JDFColorPool colorPool = (JDFColorPool)jdfRes;
        String sep = partmap.getNonEmpty("Separation");
        if (sep == null) {
            this.log.warn((Object)"Ignoring color with no separation");
            return null;
        }
        KElement col = colorPool.getChildWithAttribute("Color", "Name", null, sep, 0, true);
        if (col != null) {
            return null;
        }
        JDFColor rPart = colorPool.appendColorWithName(sep, null);
        JDFResourceLink rll = theNode.getLink((JDFResource)colorPool, null);
        if (rll != null) {
            rll.removeChildren("Part", null, null);
        }
        colorPool.removeFromAttribute("PartIDKeys", "Separation", null, " ", -1);
        return rPart;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return ResourceHelper.isAsset(toCheck, "Color");
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        KElement rPart = super.walk(e, trackElem);
        if (rPart != null) {
            rPart.removeAttribute("Status");
        }
        return rPart;
    }
}

