/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.List;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPhaseTime;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.ISignalAudit;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.jmf.JDFStatusQuParams;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFModulePhase;
import org.cip4.jdflib.resource.process.JDFMISDetails;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;

public class JDFPhaseTime
extends JDFAutoPhaseTime
implements ISignalAudit {
    private static final long serialVersionUID = 1L;

    public JDFPhaseTime(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPhaseTime(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPhaseTime(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPhaseTime[  --> " + super.toString() + " ]";
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.ResourceLinkPool, nMax);
    }

    public void setLinks(VElement vRL) {
        JDFResourceLink rl;
        int i;
        if (vRL == null) {
            return;
        }
        int size = vRL.size();
        if (size == 0) {
            return;
        }
        for (i = 0; i < size; ++i) {
            rl = (JDFResourceLink)vRL.elementAt(i);
            this.removeChildren(rl.getLocalName(), rl.getNamespaceURI(), null);
        }
        for (i = 0; i < size; ++i) {
            rl = (JDFResourceLink)vRL.elementAt(i);
            this.copyElement(rl, null);
        }
    }

    public JDFResourceLink getLink(int iSkip) {
        int n = 0;
        for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!(e instanceof JDFResourceLink) || n++ < iSkip) continue;
            return (JDFResourceLink)e;
        }
        return null;
    }

    public VElement getLinkVector() {
        VElement vRet = new VElement();
        for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!(e instanceof JDFResourceLink)) continue;
            vRet.add(e);
        }
        return vRet.size() == 0 ? null : vRet;
    }

    public String getDeviceID() {
        JDFDevice d = this.getDevice(0);
        if (d == null) {
            return null;
        }
        return StringUtil.getNonEmpty(d.getDeviceID());
    }

    public VString getDeviceIDs() {
        List<JDFDevice> vd = this.getChildArrayByClass(JDFDevice.class, false, 0);
        if (vd == null) {
            return null;
        }
        VString ret = new VString();
        for (JDFDevice d : vd) {
            ret.add(d.getDeviceID());
        }
        return ret;
    }

    public void setDeviceID(String deviceID) {
        this.getCreateDevice(0).setDeviceID(deviceID);
    }

    public JDFDuration getDuration() {
        JDFDate dStart = this.getStart();
        JDFDate dEnd = this.getEnd();
        if (dStart == null || dEnd == null) {
            return null;
        }
        int dur = (int)((dEnd.getTimeInMillis() - dStart.getTimeInMillis()) / 1000L);
        if (dur < 0) {
            dur = 0;
        }
        return new JDFDuration(dur);
    }

    public VElement setModules(VString moduleIDs, VString moduleTypes) {
        if (moduleIDs == null || moduleIDs.size() == 0) {
            return null;
        }
        if (moduleTypes == null || moduleTypes.size() == 0 || moduleTypes.size() != moduleIDs.size()) {
            throw new IllegalArgumentException("Inconsistent vector lengths");
        }
        VElement v = new VElement();
        for (int i = 0; i < moduleIDs.size(); ++i) {
            JDFModulePhase modulePhase = this.getCreateModulePhase(i);
            v.add(modulePhase);
            modulePhase.setModuleID(moduleIDs.get(i));
            modulePhase.setModuleType(moduleTypes.get(i));
        }
        return v;
    }

    @Override
    public JDFJMF toSignalJMF() {
        JDFDevice dev;
        JDFJMF newJMF = JDFJMF.createJMF(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Status);
        JDFSignal s = newJMF.getSignal(0);
        s.copyElement(this.getEmployee(0), null);
        JDFStatusQuParams sqp = s.appendStatusQuParams();
        JDFDeviceInfo di = s.appendDeviceInfo();
        JDFJobPhase jp = di.appendJobPhase();
        JDFNode parentJDF = this.getParentJDF();
        if (parentJDF != null) {
            sqp.setJobID(parentJDF.getJobID(true));
            sqp.setJobPartID(StringUtil.getNonEmpty(parentJDF.getJobPartID(false)));
            jp.setJobID(parentJDF.getJobID(true));
            jp.setJobPartID(StringUtil.getNonEmpty(parentJDF.getJobPartID(false)));
        }
        if ((dev = this.getDevice(0)) != null) {
            di.setDevice(dev, true);
        }
        di.setDeviceStatus(JDFElement.EnumNodeStatus.getDeviceStatus(this.getStatus()));
        jp.setStatus(this.getStatus());
        jp.copyAttribute("StatusDetails", this);
        JDFMISDetails md = this.getMISDetails();
        if (md != null) {
            jp.copyElement(md, null);
        }
        VJDFAttributeMap vP = this.getPartMapVector();
        jp.setPartMapVector(vP);
        s.setTime(this.getEnd());
        jp.setPhaseStartTime(this.getStart());
        return newJMF;
    }

    @Override
    public int compare(JDFAudit a1, JDFAudit a2) {
        JDFDate d1 = a1 instanceof JDFPhaseTime ? ((JDFPhaseTime)a1).getEnd() : a1.getTimeStamp();
        JDFDate d2 = a2 instanceof JDFPhaseTime ? ((JDFPhaseTime)a2).getEnd() : a2.getTimeStamp();
        return ContainerUtil.compare(d1, d2);
    }

    public void setPhase(JDFJobPhase phase) {
        if (phase != null) {
            JDFJMF jmf = (JDFJMF)phase.getDeepParent("JMF", 0);
            JDFDeviceInfo devInfo = (JDFDeviceInfo)phase.getParentNode_KElement();
            this.setStatusDetails(phase.getStatusDetails());
            this.setStatus(phase.getStatus());
            this.setPartMapVector(phase.getPartMapVector());
            this.copyElements(devInfo.getChildElementVector("Employee", null), null);
            this.copyElements(phase.getChildElementVector("Activity", null), null);
            this.copyElement(phase.getMISDetails(), null);
            this.setEnd(jmf.getTimeStamp());
            this.setStart(phase.getPhaseStartTime());
        }
    }
}

