/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Vector;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StatusCounter;

public class MultiModuleStatusCounter {
    private final Vector<StatusCounter> counters = new Vector();

    public void addModule(StatusCounter sc) {
        if (sc != null) {
            this.counters.add(sc);
        }
    }

    public void removeModule(StatusCounter sc) {
        if (sc != null) {
            this.counters.remove(sc);
        }
    }

    public JDFDoc getStatusResponse() {
        if (this.counters.size() == 0) {
            return null;
        }
        StatusCounter root = this.counters.elementAt(0);
        JDFDoc d = new JDFDoc("JMF");
        JDFJMF jmf = d.getJMFRoot();
        jmf.copyInto(root.getDocJMFPhaseTime().getJMFRoot(), false);
        JDFDeviceInfo di = jmf.getResponse(0).getDeviceInfo(0);
        for (int i = 1; i < this.counters.size(); ++i) {
            StatusCounter counter = this.counters.elementAt(i);
            JDFDoc docJMFPhaseTime = counter.getDocJMFPhaseTime();
            if (docJMFPhaseTime == null) continue;
            JDFDeviceInfo di2 = docJMFPhaseTime.getJMFRoot().getResponse(0).getDeviceInfo(0);
            VElement phases = di2.getChildElementVector("JobPhase", null, null, true, -1, false);
            for (int j = 0; j < phases.size(); ++j) {
                di.copyElement(phases.elementAt(j), null);
            }
            di.setDeviceStatus(this.getDeviceStatus());
        }
        return d;
    }

    public JDFAutoDeviceInfo.EnumDeviceStatus getDeviceStatus() {
        int counterSize = this.counters.size();
        if (counterSize == 0) {
            return JDFAutoDeviceInfo.EnumDeviceStatus.Idle;
        }
        JDFAutoDeviceInfo.EnumDeviceStatus maxStatus = null;
        for (int i = 0; i < counterSize; ++i) {
            maxStatus = (JDFAutoDeviceInfo.EnumDeviceStatus)EnumUtil.max(maxStatus, this.counters.elementAt(i).getStatus());
        }
        return maxStatus;
    }
}

