/**
 * The CIP4 Software License, Version 1.0
 *
 * Copyright (c) 2001-2014 The International Cooperation for the Integration of 
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of 
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of 
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior written
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration 
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software 
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG 
 * copyright (c) 1999-2001, Agfa-Gevaert N.V. 
 *  
 * For more information on The International Cooperation for the 
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *  
 * 
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.JDFResourceLink.EnumUsage;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.StrippingConverter;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFLayoutPreparationParams;
import org.cip4.jdflib.util.StringUtil;

/**
 * @author Dr. Rainer Prosi, Heidelberger Druckmaschinen AG
 * 
 * June 7, 2009
 */
public class WalkLayoutPrep extends WalkResource
{
	/**
	 * 
	 */
	public WalkLayoutPrep()
	{
		super();
	}

	/**
	 * @see org.cip4.jdflib.elementwalker.BaseWalker#matches(org.cip4.jdflib.core.KElement)
	 * @param toCheck
	 * @return true if matches
	 */
	@Override
	public boolean matches(final KElement toCheck)
	{
		return (toCheck instanceof JDFLayoutPreparationParams);
	}

	/**
	 * @see WalkElement#walk(org.cip4.jdflib.core.KElement, org.cip4.jdflib.core.KElement) version fixing routine
	 * for JDF uses heuristics to modify this element and its children to be compatible with a given version in general, it will be able to move from low to
	 * high versions but potentially fail when attempting to move from higher to lower versions
	 */
	@Override
	public KElement walk(final KElement e1, final KElement trackElem)
	{
		final JDFLayoutPreparationParams lpp = (JDFLayoutPreparationParams) e1;
		if (lpp.isResourceRoot() && this.fixVersion.bLayoutPrepToStripping)
		{
			VElement rls = lpp.getLinksAndRefs(true, false);
			if (rls == null)
			{
				return null;
			}
			rls.unify();
			VElement vn = new VElement();
			for (int i = 0; i < rls.size(); i++)
			{
				JDFResourceLink rl = (JDFResourceLink) rls.get(i);
				vn.add(rl.getParentJDF());
			}
			vn.unify();
			if (vn.size() <= 0)
				return null;

			JDFNode node = (JDFNode) vn.get(0);
			final StrippingConverter sc = lpp.convertToStripping(node);
			// the new elements are NOT in the original and must therefore be called individually
			new FixVersionImpl(this.fixVersion).walkTree(sc.getAssembly(), null);
			new FixVersionImpl(this.fixVersion).walkTree(sc.getStrippingParams(), null);
			new FixVersionImpl(this.fixVersion).walkTree(sc.getBinderySignature(), null);
			for (int i = 1; i < vn.size(); i++)
			{
				JDFNode n = (JDFNode) vn.get(i);
				n.linkResource(sc.getAssembly(), EnumUsage.Input, null);
				n.linkResource(sc.getStrippingParams(), EnumUsage.Input, null);
			}

			for (int i = 0; i < rls.size(); i++)
			{
				rls.get(i).deleteNode();
			}
			return null; // stop here, we zapped lpp
		}
		return super.walk(e1, trackElem);
	}

	/**
	 * @see org.cip4.jdflib.elementwalker.BaseWalker#getElementNames()
	 */
	@Override
	public VString getElementNames()
	{
		return StringUtil.tokenize(ElementName.LAYOUTPREPARATIONPARAMS, null, false);
	}

}