/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Collection;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFNumberList;
import org.cip4.jdflib.datatypes.JDFXYPair;

public class JDFTransferFunction
extends JDFNumList {
    public static final String UNIT = "0 0 1 1";
    private static final long serialVersionUID = 1L;
    private double[] cache;

    public static JDFTransferFunction getUnit() {
        return JDFTransferFunction.createTransferFunction(UNIT);
    }

    public static JDFTransferFunction createTransferFunction(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFTransferFunction(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFTransferFunction() {
        this.cache = null;
    }

    public JDFTransferFunction(String s) throws DataFormatException {
        super(s);
        this.cache = null;
    }

    @Deprecated
    public JDFTransferFunction(Vector v) throws DataFormatException {
        super(v);
        this.cache = null;
    }

    public JDFTransferFunction(JDFNumList nl) throws DataFormatException {
        super(nl.toString());
        this.cache = null;
    }

    public JDFTransferFunction(JDFTransferFunction tf) {
        this.addAll(tf);
        this.cache = tf.cache;
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() % 2 != 0) {
            throw new DataFormatException("Data format exception!");
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public boolean isUnit() {
        return this.size() == 4 && this.doubleAt(0) == 0.0 && this.doubleAt(1) == 0.0 && this.doubleAt(2) == 1.0 && this.doubleAt(3) == 1.0;
    }

    public void add(JDFXYPair xy) {
        this.add((Object)xy.getX());
        this.add((Object)xy.getY());
    }

    public void add(Double x, Double y) {
        this.add(x);
        this.add(y);
    }

    public void add(double x, double y) {
        this.cache = null;
        this.add((Object)x);
        this.add((Object)y);
    }

    public void set(double x0, double dx, Vector<Double> v) {
        this.clear();
        if (v != null) {
            double x = x0;
            for (Double d : v) {
                this.add((Object)x);
                this.add(d);
                x += dx;
            }
        }
    }

    public double getX(int index) {
        return this.doubleAt(2 * index);
    }

    public JDFXYPair getXRange() {
        return new JDFXYPair(this.getX(0), this.getX(this.numPoints() - 1));
    }

    public double getY(int index) {
        return this.doubleAt(2 * index + 1);
    }

    public double getFastValue(double x) {
        double dX;
        int iX;
        JDFXYPair r = this.getXRange();
        double x0 = r.getX();
        double d = r.getY() - x0;
        int FAST_POINTS = 100;
        if (this.cache == null) {
            double d1 = d / 100.0;
            this.cache = new double[102];
            for (int i = 0; i <= 100; ++i) {
                this.cache[i] = this.getValue(x0 + (double)i * d1);
            }
            this.cache[101] = this.getValue(r.getY());
        }
        if ((iX = (int)(dX = (x - x0) * 100.0 / d)) < 0) {
            return this.cache[0];
        }
        if (iX >= 100) {
            return this.cache[100];
        }
        double mx = dX - (double)iX;
        if (mx < 1.0E-6) {
            return this.cache[iX];
        }
        if (mx > 0.999999) {
            return this.cache[iX + 1];
        }
        return this.cache[iX] + mx * (this.cache[iX + 1] - this.cache[iX]);
    }

    public double getValue(double x) {
        int indexX1;
        int indexX0 = this.getPos(x, false);
        if (indexX0 == (indexX1 = this.getPos(x, true))) {
            return this.getY(indexX0);
        }
        double range = this.getX(indexX1) - this.getX(indexX0);
        if (range <= 0.0) {
            return this.getY(indexX0);
        }
        double rx = x - this.getX(indexX0);
        double y0 = this.getY(indexX0);
        double y1 = this.getY(indexX1);
        return y0 + (y1 - y0) * (rx / range);
    }

    public int numPoints() {
        return this.size() / 2;
    }

    int getPos(double x, boolean upper) {
        int numPoints = this.numPoints();
        for (int i = 0; i < numPoints; ++i) {
            double x2 = this.getX(i);
            if (x2 > x) {
                return upper ? i : i - 1;
            }
            if (x2 != x) continue;
            return i;
        }
        return -1;
    }

    public void add(String s) throws DataFormatException {
        JDFXYPair xyp = JDFXYPair.createXYPair(s);
        if (xyp == null) {
            throw new DataFormatException("Invalid string: " + s);
        }
        this.add(xyp);
    }

    public void add(JDFTransferFunction tf) {
        this.addAll(tf);
        this.cache = null;
    }

    @Override
    public synchronized boolean add(Object e) {
        this.cache = null;
        return super.add(e);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Object> c) {
        this.cache = null;
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.cache = null;
        super.clear();
    }

    public void resetCache() {
        this.cache = null;
    }

    public static JDFTransferFunction multiply(JDFTransferFunction tf1, JDFTransferFunction tf2) {
        if (tf1 == null || tf1.isUnit()) {
            return tf2;
        }
        if (tf2 != null && !tf2.isUnit()) {
            JDFTransferFunction tfRet = new JDFTransferFunction(tf1);
            tfRet.multiply(tf2);
            return tfRet;
        }
        return tf1;
    }

    public void multiply(JDFTransferFunction tf) {
        if (tf != null) {
            JDFNumberList xPoints = new JDFNumberList();
            int j = 0;
            for (int i = 0; i < this.numPoints(); ++i) {
                while (j < tf.numPoints() && tf.getX(j) <= this.getX(i)) {
                    if (tf.getX(j) < this.getX(i)) {
                        xPoints.add(tf.getX(j));
                    }
                    ++j;
                }
                xPoints.add(this.getX(i));
            }
            JDFTransferFunction t = new JDFTransferFunction();
            for (int i = 0; i < xPoints.size(); ++i) {
                double x = xPoints.doubleAt(i);
                double y = this.getValue(x) * tf.getValue(x);
                if (x > 0.0) {
                    y /= x;
                }
                t.add(x, y);
            }
            this.clear();
            this.addAll(t);
        }
    }
}

