/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.ifaces.IElementConverter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.UrlUtil;

public class URLExtractor
extends BaseElementWalker
implements IElementConverter {
    protected final File dir;
    protected final String baseURL;
    protected Set<UrlUtil.URLProtocol> protocols;
    protected final String currentURL;
    protected final Set<String> saved;
    protected boolean deleteFile;
    private boolean wantLog;

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public Set<String> getSaved() {
        return this.saved;
    }

    public URLExtractor(File dumpDir, String currentURL, String baseURL) {
        super(new BaseWalkerFactory());
        this.dir = dumpDir;
        this.baseURL = baseURL;
        this.currentURL = currentURL;
        this.saved = new HashSet<String>();
        this.protocols = null;
        this.setDeleteFile(false);
        this.setWantLog(false);
    }

    public void setWantLog(boolean bWant) {
        this.wantLog = bWant;
    }

    public void addProtocol(UrlUtil.URLProtocol protocol) {
        if (this.protocols == null) {
            this.protocols = new HashSet<UrlUtil.URLProtocol>();
        }
        this.protocols.add(protocol);
    }

    @Override
    public KElement convert(KElement e) {
        this.walkTree(e, null);
        return e;
    }

    @Override
    public String toString() {
        return super.toString() + "\n " + this.protocols + " baseURL: " + this.baseURL + " currentURL: " + this.currentURL + " dir: " + this.dir + " delete: " + this.deleteFile;
    }

    public class WalkURL
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            UrlUtil.URLProtocol protocol;
            IURLSetter urlSetter = (IURLSetter)((Object)e);
            String url = StringUtil.getNonEmpty(urlSetter.getURL());
            if (url == null) {
                return e;
            }
            if (URLExtractor.this.baseURL != null && url.startsWith(URLExtractor.this.baseURL)) {
                return e;
            }
            if (URLExtractor.this.protocols != null && !URLExtractor.this.protocols.contains((Object)(protocol = UrlUtil.getProtocol(url)))) {
                return e;
            }
            boolean fileOK = this.checkFile(url);
            if (!fileOK) {
                return e;
            }
            boolean bOverwrite = !URLExtractor.this.saved.contains(url);
            File newFile = UrlUtil.moveToDir(urlSetter, URLExtractor.this.dir, URLExtractor.this.currentURL, bOverwrite, URLExtractor.this.deleteFile);
            for (int i = 1; i < 4 && newFile == null && !URLExtractor.this.saved.contains(url) && !UrlUtil.isRelativeURL(url); ++i) {
                if (!ThreadUtil.sleep(4200)) {
                    return null;
                }
                newFile = UrlUtil.moveToDir(urlSetter, URLExtractor.this.dir, URLExtractor.this.currentURL, bOverwrite, URLExtractor.this.deleteFile);
                this.log.warn((Object)("attempting download # " + i + " of URL " + url));
            }
            if (newFile != null) {
                if (URLExtractor.this.baseURL != null) {
                    String s = UrlUtil.isRelativeURL(url) ? url : UrlUtil.escape(newFile.getName(), false, false);
                    String urlWithDirectory = UrlUtil.getURLWithDirectory(URLExtractor.this.baseURL, s);
                    urlSetter.setURL(urlWithDirectory);
                }
                if (URLExtractor.this.wantLog && bOverwrite) {
                    this.log.info((Object)((URLExtractor.this.deleteFile ? "moved" : "copied ") + url + " to " + urlSetter.getURL()));
                }
            } else if (URLExtractor.this.wantLog) {
                this.log.warn((Object)((URLExtractor.this.deleteFile ? "could not move " : "could not copy ") + url + " to " + URLExtractor.this.dir));
            }
            URLExtractor.this.saved.add(url);
            return e;
        }

        protected boolean checkFile(String url) {
            if (!UrlUtil.isFile(url) && !UrlUtil.isUNC(url)) {
                return true;
            }
            File f = UrlUtil.urlToFile(url);
            if (URLExtractor.this.currentURL != null && UrlUtil.isRelativeURL(url)) {
                f = FileUtil.cleanDots(new File(URLExtractor.this.currentURL, f.getPath()));
            }
            if (f != null) {
                if (!f.exists()) {
                    File parentDir = f.getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        this.log.warn((Object)("No such parent directory: " + parentDir));
                    } else if (parentDir != null && !parentDir.canRead()) {
                        this.log.warn((Object)("Cannot read parent directory: " + parentDir));
                    }
                    this.log.warn((Object)("No such file: " + f));
                    return false;
                }
                if (!f.canRead()) {
                    this.log.warn((Object)("Cannot read file: " + f));
                    return false;
                }
                if (f.isDirectory()) {
                    this.log.warn((Object)("Cannot copy directory: " + f));
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof IURLSetter;
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(URLExtractor.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return e;
        }
    }
}

