/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDPart;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDropIntent;
import org.cip4.jdflib.resource.intent.JDFDropItemIntent;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.util.StringUtil;

public class WalkProduct
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdfProduct, KElement trackElem) {
        JDFNode theNode = (JDFNode)trackElem;
        JDFNode root = theNode.getRoot();
        ProductHelper productHelper = new ProductHelper(xjdfProduct);
        if ("Product".equals(theNode.getType())) {
            JDFNode tmp = root.getChildJDFNode(xjdfProduct.getAttribute("ID"), false);
            if (tmp != null) {
                theNode = tmp;
            } else if (!this.xjdfToJDFImpl.firstproductInList) {
                ProductHelper parent = productHelper.getParent();
                String id = parent == null ? null : parent.getID();
                JDFNode jDFNode = tmp = id == null ? null : root.getChildJDFNode(id, false);
                theNode = tmp != null ? tmp.addProduct() : theNode.addProduct();
            }
        } else {
            theNode = this.xjdfToJDFImpl.createProductRoot();
        }
        this.xjdfToJDFImpl.firstproductInList = false;
        this.copyToNode(xjdfProduct, theNode);
        JDFComponent c = this.fixComponent(theNode, xjdfProduct);
        if (productHelper.isRootProduct() && this.xjdfToJDFImpl.xjdf.getSet("DeliveryParams", 0) == null && new ProductHelper(xjdfProduct).getIntent("DeliveryIntent") == null) {
            this.updateDeliveryIntent(xjdfProduct, theNode, c);
        }
        return theNode;
    }

    private void updateDeliveryIntent(KElement xjdfProduct, JDFNode theNode, JDFComponent c) {
        JDFResourceLink rlc = theNode.getLink((JDFResource)c, JDFResourceLink.EnumUsage.Output);
        double overage = rlc.getMaxAmount();
        double underage = rlc.getMinAmount();
        double amount = StringUtil.parseDouble(xjdfProduct.getAttribute("Amount", null, null), -1000.0);
        if (amount > 0.0) {
            ResourceHelper contact;
            JDFDeliveryIntent di = (JDFDeliveryIntent)theNode.getRoot().getCreateResource("DeliveryIntent", JDFResourceLink.EnumUsage.Input, 0);
            if (overage > 0.0) {
                di.getCreateOverage().setActual(100.0 * (overage - amount) / amount);
            }
            if (underage > 0.0) {
                di.getCreateUnderage().setActual(100.0 * (amount - underage) / amount);
            }
            JDFDropIntent dropIntent = di.getCreateDropIntent(0);
            XJDFHelper h = XJDFHelper.getHelper(xjdfProduct);
            SetHelper contacts = h == null ? null : h.getSet("Contact", JDFResourceLink.EnumUsage.Input);
            ResourceHelper resourceHelper = contact = contacts == null ? null : contacts.getPartition("ContactType", JDFContact.EnumContactType.Delivery.getName());
            if (contact != null) {
                contact.ensureReference(di, null);
                this.cleanRefs(di, di);
            }
            JDFDropItemIntent dropItemIntent = dropIntent.appendDropItemIntent();
            dropItemIntent.setAmount((int)amount);
            dropItemIntent.refElement(c);
        }
    }

    private void copyToNode(KElement e, JDFNode theNode) {
        String desc = theNode.getNonEmpty("DescriptiveName");
        VString ignore = new VString("IsRoot", null);
        if (desc != null) {
            ignore.add("DescriptiveName");
        }
        theNode.setAttributes(e, ignore);
        this.updateAttributes(theNode);
    }

    private JDFComponent fixComponent(JDFNode theNode, KElement xjdfProduct) {
        JDFComponent c = (JDFComponent)theNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        ProductHelper productHelper = new ProductHelper(xjdfProduct);
        if (c == null) {
            c = (JDFComponent)theNode.addResource("Component", JDFResourceLink.EnumUsage.Output);
            this.xjdfToJDFImpl.idMap.put(c.getID(), new IDPart(c.getID(), null));
            boolean isRootProduct = productHelper.isRootProduct();
            JDFAutoComponent.EnumComponentType partialFinal = isRootProduct ? JDFAutoComponent.EnumComponentType.FinalProduct : JDFAutoComponent.EnumComponentType.PartialProduct;
            c.setComponentType(partialFinal, null);
        }
        AttributeInfo info = c.getAttributeInfo();
        VString cKnown = info.knownAttribs();
        AttributeInfo infoNode = theNode.getAttributeInfo();
        cKnown.removeAll(infoNode.knownAttribs());
        cKnown.remove("Amount");
        cKnown.remove("ActualAmount");
        for (String known : cKnown) {
            if (!theNode.hasAttribute(known)) continue;
            c.moveAttribute(known, theNode);
        }
        JDFResourceLink rl = theNode.getLink((JDFResource)c, JDFResourceLink.EnumUsage.Output);
        if (rl != null) {
            JDFNode parent;
            rl.moveAttribute("Amount", theNode);
            rl.moveAttribute("MinAmount", theNode);
            rl.moveAttribute("MaxAmount", theNode);
            if (!productHelper.isRootProduct() && (parent = theNode.getParentJDF()) != null && JDFNode.EnumType.Product.equals((Object)parent.getEnumType())) {
                JDFResourceLink inLink = parent.ensureLink(c, JDFResourceLink.EnumUsage.Input, null);
                inLink.copyAttribute("Amount", rl);
            }
        }
        return c;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && toCheck.getLocalName().equals("Product");
    }
}

