/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.Collection;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoScavengerArea;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.JDFMarkObject;
import org.cip4.jdflib.resource.process.JDFSeparationSpec;
import org.w3c.dom.DOMException;

public class JDFScavengerArea
extends JDFAutoScavengerArea {
    private static final long serialVersionUID = 1L;

    public JDFScavengerArea(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFScavengerArea(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFScavengerArea(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFScavengerArea[  --> " + super.toString() + " ]";
    }

    public JDFRectangle getRect() {
        JDFMatrix m;
        JDFXYPair c = this.getCenter();
        JDFXYPair s = this.getSize();
        if (c == null || s == null) {
            return null;
        }
        double rot = this.getRotation();
        if (rot == 90.0 || rot == 270.0) {
            s.swapXY();
        }
        JDFRectangle r = new JDFRectangle(s);
        r.setCenter(c);
        JDFMarkObject mo = this.getParentMarkObject();
        JDFMatrix jDFMatrix = m = mo == null ? null : mo.getTrimCTM();
        if (m == null) {
            return r;
        }
        return m.transform(r);
    }

    public JDFMarkObject getParentMarkObject() {
        KElement e = this.getParentNode_KElement();
        return e instanceof JDFMarkObject ? (JDFMarkObject)e : null;
    }

    public VString getSeparations() {
        VString vs = new VString();
        Collection<JDFSeparationSpec> v = this.getAllSeparationSpec();
        for (JDFSeparationSpec s : v) {
            String sepName = s.getName();
            vs.add(sepName);
        }
        return vs;
    }

    public void setSeparations(VString vSeps) {
        this.removeChildren("SeparationSpec", null, null);
        this.appendSeparations(vSeps);
    }

    public JDFSeparationSpec appendSeparation(String sep) {
        JDFSeparationSpec ss = this.appendSeparationSpec();
        ss.setName(sep);
        return ss;
    }

    public void appendSeparations(VString vSeps) {
        if (vSeps == null) {
            return;
        }
        for (String sep : vSeps) {
            this.appendSeparation(sep);
        }
    }
}

