/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAddress;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFAddress
extends JDFAutoAddress
implements IMatches {
    private static final long serialVersionUID = 1L;

    public JDFAddress(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAddress(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAddress(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFAddress[  --> " + super.toString() + " ]";
    }

    public String getExtendedAddressText() {
        if (this.hasChildElement("ExtendedAddress", null)) {
            return this.getExtendedAddress().getText();
        }
        return "";
    }

    public void setExtendedAddressText(String extendedAddress) {
        this.getCreateExtendedAddress().setText(extendedAddress);
    }

    @Override
    public boolean matches(Object subset) {
        if (!(subset instanceof JDFAddress)) {
            return false;
        }
        JDFAddress other = (JDFAddress)subset;
        if (StringUtil.getDistance(this.getCity(), other.getCity(), true, true, true) > 2) {
            return false;
        }
        if (StringUtil.getDistance(this.getCountry(), other.getCountry(), true, true, true) > 2) {
            return false;
        }
        if (StringUtil.getDistance(this.getCountryCode(), other.getCountryCode(), true, true, true) > 0) {
            return false;
        }
        if (StringUtil.getDistance(this.getPostalCode(), other.getPostalCode(), true, true, true) > 0) {
            return false;
        }
        if (StringUtil.getDistance(this.getRegion(), other.getRegion(), true, true, true) > 2) {
            return false;
        }
        return StringUtil.getDistance(this.getStreet(), other.getStreet(), true, true, true) <= 2;
    }
}

