/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.mime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFParser;
import org.cip4.jdflib.core.JDFParserFactory;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.MimeUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.MimeHelper;

public class BodyPartHelper {
    protected BodyPart theBodyPart;
    private static Log log = LogFactory.getLog(BodyPartHelper.class);

    public BodyPartHelper(BodyPart bp) {
        this.theBodyPart = bp;
    }

    public BodyPartHelper() {
        this.createBodyPart();
    }

    public BodyPart getBodyPart() {
        return this.theBodyPart;
    }

    public void createBodyPart() {
        this.theBodyPart = new MimeBodyPart();
        this.setHeader("Content-Transfer-Encoding", MimeUtil.MIMEDetails.defaultTransferEncoding);
    }

    public boolean setHeader(String key, String value) {
        if (this.theBodyPart == null) {
            return false;
        }
        try {
            this.theBodyPart.setHeader(key, value);
            return true;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public void setContentID(String cid) {
        if (cid == null) {
            return;
        }
        try {
            this.theBodyPart.setHeader("Content-ID", "<" + MimeUtil.urlToCid(cid).substring(4) + ">");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public void setFileName(String path) {
        if (path == null) {
            return;
        }
        try {
            this.theBodyPart.setFileName(new File(path).getName());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public String getFileName() {
        if (this.theBodyPart == null) {
            return null;
        }
        String s = null;
        try {
            s = StringUtil.getNonEmpty(this.theBodyPart.getFileName());
            if (s != null) {
                return s;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        s = this.getContentID();
        if (s == null) {
            int index = this.getIndex();
            s = StringUtil.sprintf("part_%04i.txt", "" + index);
        }
        return s;
    }

    public boolean matchesCID(String cid) {
        String s;
        if (cid == null) {
            return true;
        }
        if (cid.startsWith("<")) {
            cid = cid.substring(1);
        }
        if (cid.toLowerCase().startsWith("cid:")) {
            cid = cid.substring(4);
        }
        if (cid.endsWith(">")) {
            cid = cid.substring(0, cid.length() - 1);
        }
        if ((s = this.getContentID()) == null) {
            return false;
        }
        return cid.equalsIgnoreCase(s);
    }

    public String getContentID() {
        if (this.theBodyPart == null) {
            return null;
        }
        String[] cids = null;
        try {
            cids = this.theBodyPart.getHeader("Content-ID");
        }
        catch (MessagingException e) {
            return null;
        }
        String s = StringUtil.setvString(cids, null, null, null);
        if (s == null) {
            return s;
        }
        return MimeUtil.urlToCid(s).substring(4);
    }

    public void setContent(XMLDoc xmlDoc) throws MessagingException, IOException {
        if (this.theBodyPart == null || xmlDoc == null) {
            throw new MessagingException("null parameters in setContent");
        }
        ByteArrayIOStream ios = new ByteArrayIOStream();
        xmlDoc.write2Stream(ios, 0, true);
        this.setContent(ios, "text/xml");
        xmlDoc.setBodyPart(this.theBodyPart);
        KElement root = xmlDoc.getRoot();
        if (root instanceof JDFJMF) {
            this.theBodyPart.setHeader("Content-Type", "application/vnd.cip4-jmf+xml");
        } else if (root instanceof JDFNode) {
            this.theBodyPart.setHeader("Content-Type", "application/vnd.cip4-jdf+xml");
        } else {
            String localName = root.getLocalName();
            if (localName.equals("XJDF")) {
                this.theBodyPart.setHeader("Content-Type", "application/vnd.cip4-xjdf+xml");
            } else if (localName.equals("XJMF")) {
                this.theBodyPart.setHeader("Content-Type", "application/vnd.cip4-xjmf+xml");
            } else if (localName.equals("PrintTalk")) {
                this.theBodyPart.setHeader("Content-Type", "application/vnd.cip4-ptk+xml");
            }
        }
    }

    void setContent(ByteArrayIOStream ios, String contentType) throws MessagingException {
        MimeUtil.ByteArrayDataSource ds = new MimeUtil.ByteArrayDataSource(ios, contentType);
        DataHandler dataHandler = new DataHandler((DataSource)ds);
        this.theBodyPart.setDataHandler(dataHandler);
    }

    public boolean setContent(InputStream is, String contentType) {
        try {
            this.setContent(new ByteArrayIOStream(is), contentType);
        }
        catch (MessagingException e) {
            return false;
        }
        return true;
    }

    public BodyPart createFromURL(String urlString) {
        try {
            FileDataSource dataSrc = null;
            File f = UrlUtil.urlToFile(urlString);
            if (f != null && f.canRead()) {
                dataSrc = new FileDataSource(f);
            }
            if (dataSrc == null) {
                return null;
            }
            this.theBodyPart.setDataHandler(new DataHandler((DataSource)dataSrc));
            this.setFileName(f.getAbsolutePath());
            this.setContentID(urlString);
        }
        catch (MessagingException e1) {
            log.warn((Object)("cannot open file: " + urlString), (Throwable)e1);
            return null;
        }
        return this.theBodyPart;
    }

    public JDFDoc getJDFDoc() {
        if (this.theBodyPart == null) {
            return null;
        }
        try {
            String mimeType = this.theBodyPart.getContentType();
            if (!MimeUtil.isJDFMimeType(mimeType)) {
                return null;
            }
            InputStream is = this.theBodyPart.getInputStream();
            JDFParser p = JDFParserFactory.getFactory().get();
            JDFDoc doc = p.parseStream(is);
            if (doc != null) {
                doc.setBodyPart(this.theBodyPart);
            }
            JDFParserFactory.getFactory().push(p);
            return doc;
        }
        catch (IOException e) {
            return null;
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public XMLDoc getXMLDoc() {
        if (this.theBodyPart == null) {
            return null;
        }
        try {
            InputStream is = this.theBodyPart.getInputStream();
            XMLDoc doc = XMLDoc.parseStream(is);
            if (doc != null) {
                doc.setBodyPart(this.theBodyPart);
            }
            return doc;
        }
        catch (IOException e) {
            return null;
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public void writeToDir(File directory) throws IOException, MessagingException {
        boolean exists = directory.exists();
        if (!exists) {
            exists = directory.mkdirs();
        }
        if (!exists) {
            throw new FileNotFoundException();
        }
        String fileName = this.getFileName();
        File outFile = new File(directory.getPath() + File.separator + fileName);
        FileUtil.streamToFile(this.getInputStream(), outFile);
    }

    public int getIndex() {
        Multipart mp = this.theBodyPart.getParent();
        if (mp == null) {
            return 0;
        }
        MimeHelper mh = new MimeHelper(mp);
        BodyPart[] bps = mh.getBodyParts();
        for (int i = 0; i < bps.length; ++i) {
            if (bps[i] != this.theBodyPart) continue;
            return i;
        }
        return 0;
    }

    public InputStream getInputStream() {
        try {
            return this.theBodyPart == null ? null : this.theBodyPart.getInputStream();
        }
        catch (IOException iOException) {
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    public String getContentType() {
        try {
            return this.theBodyPart == null ? null : StringUtil.token(this.theBodyPart.getContentType(), 0, ";");
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String toString() {
        return "BodyPartHelper [" + this.getHeaderMap() + "]";
    }

    public JDFAttributeMap getHeaderMap() {
        try {
            Enumeration headers;
            Enumeration enumeration = headers = this.theBodyPart == null ? null : this.theBodyPart.getAllHeaders();
            if (headers != null) {
                JDFAttributeMap ret = new JDFAttributeMap();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    ret.put(header.getName(), header.getValue());
                }
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean matchesKey(String key, String value) {
        if (this.theBodyPart == null) {
            return false;
        }
        JDFAttributeMap headerMap = this.getHeaderMap();
        String ignoreCase = headerMap == null ? null : headerMap.getIgnoreCase(key);
        return ignoreCase != null && StringUtil.equals(ignoreCase, value);
    }

    public boolean matchesFileName(String name) {
        return name != null && name.equalsIgnoreCase(this.getFileName());
    }
}

