/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.NoSuchElementException;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.util.HashUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFIntegerRange
extends JDFRange {
    private int m_left = 0;
    private int m_right = 0;
    private int m_xDef = m_defaultXDef;
    private static int m_defaultXDef = 0;

    public static JDFIntegerRange createIntegerRange(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFIntegerRange(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public static JDFIntegerRange getIntegerRange(String range) {
        try {
            return new JDFIntegerRange(range);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    public JDFIntegerRange() {
        this.init(0, 0, 0);
    }

    public JDFIntegerRange(int x) {
        this.init(x, x, m_defaultXDef);
    }

    public JDFIntegerRange(int xmin, int xmax) {
        this.init(xmin, xmax, m_defaultXDef);
    }

    public JDFIntegerRange(int xmin, int xmax, int xdef) {
        this.init(xmin, xmax, xdef);
    }

    public JDFIntegerRange(JDFIntegerRange ir) {
        this.init(ir.m_left, ir.m_right, ir.m_xDef);
    }

    protected void init(int xmin, int xmax, int xdef) {
        this.m_left = xmin;
        this.m_right = xmax;
        this.setDef(xdef);
    }

    public JDFIntegerRange(String s) throws DataFormatException {
        this(s, m_defaultXDef);
    }

    public JDFIntegerRange(String s, int xdef) throws DataFormatException {
        if (s == null) {
            throw new DataFormatException("JDFIntegerRange illegal string: " + s);
        }
        String[] strArray = s.split("~");
        if (strArray.length <= 0 || strArray.length > 2) {
            throw new DataFormatException("JDFIntegerRange illegal string: " + s);
        }
        try {
            if (strArray.length == 1) {
                this.m_left = StringUtil.parseInt(strArray[0], xdef);
                if (!StringUtil.isInteger(strArray[0])) {
                    throw new DataFormatException("JDFIntegerRange illegal string: " + s);
                }
                this.m_right = this.m_left;
            } else {
                this.m_left = StringUtil.parseInt(strArray[0], xdef);
                this.m_left = StringUtil.parseInt(strArray[0], xdef);
                if (this.m_left == xdef && !StringUtil.isInteger(strArray[0])) {
                    throw new DataFormatException("JDFIntegerRange illegal string: " + s);
                }
                this.m_right = StringUtil.parseInt(strArray[1], xdef);
                if (this.m_right == xdef && !StringUtil.isInteger(strArray[1])) {
                    throw new DataFormatException("JDFIntegerRange illegal string: " + s);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new DataFormatException("JDFIntegerRange illegal string: " + s);
        }
        this.setDef(xdef);
    }

    public String toString() {
        if (this.getLeft() == this.getRight()) {
            return StringUtil.formatInteger(this.getRight());
        }
        return StringUtil.formatInteger(this.getLeft()) + " ~ " + StringUtil.formatInteger(this.getRight());
    }

    public boolean isValid(String s) {
        try {
            new JDFIntegerRange(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.toString().equals(((JDFIntegerRange)other).toString());
    }

    @Override
    public int hashCode() {
        return HashUtil.hashCode(0, this.toString());
    }

    public int getLeft() {
        return this.m_left < 0 && this.m_xDef > 0 ? this.m_xDef + this.m_left : this.m_left;
    }

    public void setLeft(int x) {
        this.m_left = x;
    }

    public int getRight() {
        return this.m_right < 0 && this.m_xDef > 0 ? this.m_xDef + this.m_right : this.m_right;
    }

    public void scale(int f) {
        this.m_right *= f;
        this.m_left *= f;
    }

    public void setRight(int x) {
        this.m_right = x;
    }

    public int getLowerValue() {
        int right;
        int left = this.getLeft();
        return left < (right = this.getRight()) ? left : right;
    }

    public void setLowerValue(int x) {
        int right;
        int left = this.getLeft();
        if (left == (right = this.getRight())) {
            this.setLeft(x);
            this.setRight(x);
        } else if (left < right) {
            this.setLeft(x);
        } else {
            this.setRight(x);
        }
    }

    public int getUpperValue() {
        int right;
        int left = this.getLeft();
        return left < (right = this.getRight()) ? right : left;
    }

    public void setUpperValue(int x) {
        int right;
        int left = this.getLeft();
        if (left == (right = this.getRight())) {
            this.setLeft(x);
            this.setRight(x);
        } else if (left > right) {
            this.setLeft(x);
        } else {
            this.setRight(x);
        }
    }

    public boolean inRange(int x) {
        return x >= this.getLowerValue() && x <= this.getUpperValue();
    }

    @Override
    public boolean isPartOfRange(JDFRange r) {
        JDFIntegerRange ir = (JDFIntegerRange)r;
        return ir.getLowerValue() >= this.getLowerValue() && ir.getUpperValue() <= this.getUpperValue();
    }

    public int getElementCount() {
        if (m_defaultXDef == 0 && (this.getRight() < 0 || this.getLeft() < 0)) {
            return -1;
        }
        return 1 + Math.abs(this.getLeft() - this.getRight());
    }

    public boolean append(int x) {
        int left;
        int right = this.getRight();
        if (right > (left = this.getLeft())) {
            if (right + 1 == x) {
                this.m_right = x;
                return true;
            }
        } else if (right < left) {
            if (right - 1 == x) {
                this.m_right = x;
                return true;
            }
        } else {
            if (right + 1 == x) {
                this.m_right = x;
                return true;
            }
            if (right - 1 == x) {
                this.m_right = x;
                return true;
            }
        }
        return false;
    }

    public int getElement(int i) throws NoSuchElementException {
        int n = this.getElementCount();
        if (i >= n || i < -n) {
            throw new NoSuchElementException("JDFIntegerRange::Element out of range error!");
        }
        if (i < 0) {
            return this.getElement(n + i);
        }
        int left = this.getLeft();
        int right = this.getRight();
        if (right >= left) {
            return left + i;
        }
        return left - i;
    }

    public void setDef(int xdef) {
        this.m_xDef = xdef;
    }

    public static void setDefaultDef(int xdef) {
        m_defaultXDef = xdef;
    }

    public static int getDefaultDef() {
        return m_defaultXDef;
    }

    public int getDef() {
        return this.m_xDef;
    }

    public JDFIntegerList getIntegerList() {
        JDFIntegerList irl = new JDFIntegerList();
        int elementCount = this.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            irl.add(this.getElement(i));
        }
        return irl;
    }

    @Override
    protected Object getRightObject() {
        return this.m_right;
    }

    @Override
    protected Object getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((Integer)other);
    }
}

