/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.extensions.MessageHelper;
import org.cip4.jdflib.extensions.MessagePoolHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDRemover;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StringUtil;

public class XJMFHelper
extends MessagePoolHelper {
    public XJMFHelper(KElement pool) {
        super(pool);
    }

    public void setVersion(JDFElement.EnumVersion v) {
        this.setAttribute("Version", v == null ? XJDFHelper.defaultVersion().getName() : v.getName());
    }

    public List<MessageHelper> getMessageHelpers(MessageHelper.EFamily family) {
        List<MessageHelper> vA = this.getMessageHelpers();
        ArrayList<MessageHelper> vM = new ArrayList<MessageHelper>();
        for (MessageHelper mh : vA) {
            if (family != null && !family.equals((Object)mh.getEFamily())) continue;
            vM.add(mh);
        }
        return vM;
    }

    public XJMFHelper() {
        super(null);
        this.newXJMF(XJMFHelper.getDefaultVersion());
    }

    public XJMFHelper newXJMF(JDFElement.EnumVersion v) {
        JDFDoc doc = new JDFDoc("XJMF", v);
        doc.setInitOnCreate(false);
        this.theElement = doc.getRoot();
        if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_2_0, v)) {
            this.theElement.setAttribute("Version", v.getName());
        }
        this.cleanUp();
        return this;
    }

    public MessageHelper appendMessage(JDFMessage.EnumFamily family, JDFMessage.EnumType typ) {
        if (family == null || typ == null) {
            return null;
        }
        return this.appendMessage(this.getMessageName(family, typ.getName()));
    }

    public MessageHelper appendMessage(JDFMessage.EnumFamily family, String typ) {
        String messageName = this.getMessageName(family, typ);
        return messageName == null ? null : this.appendMessage(messageName);
    }

    String getMessageName(JDFMessage.EnumFamily family, String typ) {
        if (StringUtil.isEmpty(typ) || family == null || JDFMessage.EnumFamily.Acknowledge.equals((Object)family) || JDFMessage.EnumFamily.Registration.equals((Object)family)) {
            return null;
        }
        return family.getName() + typ;
    }

    public boolean writeToFile(String file) {
        this.cleanUp();
        boolean b = this.getRoot().getOwnerDocument_KElement().write2File(file, 2, false);
        return b;
    }

    public KElement getHeader() {
        return MessageHelper.ensureHeader(this.theElement);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        MessageHelper.ensureHeader(this.theElement);
        new IDRemover().removeIDs(this.theElement);
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.cleanUp();
        this.getRoot().getOwnerDocument_KElement().write2Stream(os, 2, false);
    }

    public static XJMFHelper getHelper(KElement root) {
        if (root == null) {
            return null;
        }
        if (!root.getLocalName().equals("XJMF")) {
            root = root.getDeepParent("XJMF", 0);
        }
        return root != null ? new XJMFHelper(root) : null;
    }

    public static XJMFHelper getHelper(XMLDoc doc) {
        if (doc == null) {
            return null;
        }
        KElement root = doc.getRoot();
        return XJMFHelper.getHelper(root);
    }
}

