/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkAudit;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFResourceAudit;

public class WalkResourceAudit
extends WalkAudit {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement raNew = super.walk(jdf, xjdf);
        JDFResourceLink newLink = this.updateLink((JDFResourceAudit)jdf);
        this.copyLinkValues(raNew, newLink);
        return raNew;
    }

    private JDFResourceLink updateLink(JDFResourceAudit ra) {
        JDFResourceLink newLink = ra.getNewLink();
        if (newLink != null && newLink.getPart(0) == null) {
            VJDFAttributeMap partMapVector = ra.getPartMapVector();
            if (partMapVector != null) {
                JDFAmountPool amountPool = newLink.getAmountPool();
                VJDFAttributeMap apMaps = amountPool == null ? null : amountPool.getPartMapVector();
                VString keys = apMaps == null ? null : apMaps.getKeys();
                partMapVector.removeKeys(keys);
                newLink.setPartMapVector(partMapVector);
            }
            ra.setPartMapVector(null);
        }
        return newLink;
    }

    @Override
    protected String getXJDFName(KElement jdf) {
        return "AuditResource";
    }

    protected void copyLinkValues(KElement raNew, JDFResourceLink rl) {
        if (rl == null) {
            return;
        }
        JDFResourceInfo ri = (JDFResourceInfo)rl.appendElement("ResourceInfo");
        ri.setLink(rl, false);
        this.jdfToXJDF.walkTree(ri, raNew);
        rl.deleteNode();
    }

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFResourceAudit;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("ResourceAudit", null);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("Reason");
        map.remove("ContentsModified");
        map.remove("NodeStatus");
        super.updateAttributes(map);
    }
}

