/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.logging;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.cip4.jdflib.util.UrlUtil;

public class LogConfigurator {
    public static void main(String[] args) {
        Logger logger = LogManager.getLogger(LogConfigurator.class);
        LogConfigurator.configureLog("c:/a", "main.log");
        Log log = LogFactory.getLog(LogConfigurator.class);
        log.info((Object)"pre");
        logger.info("pre2");
        for (int i = 0; i < 5; ++i) {
            log.info((Object)"Configured logging ");
        }
    }

    public static void configureLog(String logDir, String logName) {
        Log log = LogFactory.getLog(LogConfigurator.class);
        try {
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            builder.setConfigurationName("DefaultLogger");
            LayoutComponentBuilder newLayout = builder.newLayout(PatternLayout.class.getSimpleName());
            newLayout.addAttribute("pattern", "%d{HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n");
            AppenderComponentBuilder consoleAppender = builder.newAppender("stdout", "Console");
            consoleAppender.add(newLayout);
            builder.add(consoleAppender);
            RootLoggerComponentBuilder newRootLogger = builder.newRootLogger(Level.INFO);
            AppenderRefComponentBuilder newAppenderRef = builder.newAppenderRef("stdout");
            newRootLogger.add(newAppenderRef);
            if (logDir != null) {
                new File(logDir).mkdirs();
                String logFileName = logDir + "/" + logName;
                if (UrlUtil.extension(logFileName) == null) {
                    logFileName = logFileName + ".log";
                }
                AppenderComponentBuilder fileleAppender = builder.newAppender("file", "RollingFile");
                fileleAppender.add(newLayout);
                fileleAppender.addAttribute("fileName", logFileName);
                String pattern = UrlUtil.newExtension(logFileName, "%i." + UrlUtil.extension(logFileName));
                fileleAppender.addAttribute("filePattern", pattern);
                ComponentBuilder policies = builder.newComponent("Policies");
                ComponentBuilder trigger = builder.newComponent("SizeBasedTriggeringPolicy");
                trigger.addAttribute("size", "10M");
                policies.addComponent(trigger);
                fileleAppender.addComponent(policies);
                ComponentBuilder roll = builder.newComponent("DefaultRolloverStrategy");
                roll.addAttribute("max", 10);
                fileleAppender.addComponent(roll);
                builder.add(fileleAppender);
                AppenderRefComponentBuilder fileAppenderRef = builder.newAppenderRef("file");
                newRootLogger.add(fileAppenderRef);
            }
            builder.add(newRootLogger);
            BuiltConfiguration c = (BuiltConfiguration)builder.build();
            Configurator.reconfigure((Configuration)c);
            log.info((Object)("Configured logging " + logDir));
        }
        catch (Exception e) {
            log.error((Object)"Snafu while configuring logging ", (Throwable)e);
        }
    }
}

