/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.util.StringUtil;

public class ThreadFilter {
    public Vector<Thread> getThreads(String regexp) {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Thread> threadSet = allStackTraces.keySet();
        Vector<Thread> returnSet = new Vector<Thread>();
        for (Thread thread : threadSet) {
            if (!StringUtil.matchesSimple(thread.getName(), regexp)) continue;
            returnSet.add(thread);
        }
        return returnSet;
    }

    public Thread getThread(String regexp, int nSkip) {
        Vector<Thread> threads = this.getThreads(regexp);
        if (nSkip < 0) {
            nSkip += threads.size();
        }
        if (nSkip < 0 || nSkip >= threads.size()) {
            return null;
        }
        return threads.get(nSkip);
    }

    public int numThreads() {
        return Thread.activeCount();
    }
}

