/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.HashUtil;

public class JDFAttributeMapArray
extends ArrayList<JDFAttributeMap> {
    private static final long serialVersionUID = 1234321L;

    public JDFAttributeMapArray() {
    }

    public JDFAttributeMapArray(Collection<JDFAttributeMap> toAdd) {
        if (toAdd != null) {
            this.ensureCapacity(toAdd.size());
            for (JDFAttributeMap map : toAdd) {
                this.add(map.clone());
            }
        }
    }

    public JDFAttributeMapArray(JDFAttributeMap[] toAdd) {
        ContainerUtil.addAll(this, toAdd);
    }

    public JDFAttributeMapArray(JDFAttributeMap moreMap) {
        this();
        if (moreMap != null) {
            this.add(moreMap);
        }
    }

    @Override
    public String toString() {
        return "JDFAttributeMapArray: " + this.showKeys("\n", " ");
    }

    public static JDFAttributeMapArray getNonEmpty(JDFAttributeMapArray v) {
        return JDFAttributeMapArray.isEmpty(v) ? null : v;
    }

    public static JDFAttributeMapArray getArray(JDFAttributeMap partMap) {
        return JDFAttributeMap.isEmpty(partMap) ? null : new JDFAttributeMapArray(partMap);
    }

    public static boolean isEmpty(Collection<JDFAttributeMap> v) {
        return v == null || v.isEmpty() || v.size() == 1 && JDFAttributeMap.isEmpty(v.iterator().next());
    }

    public String showKeys(String sepMap, String sepEntry) {
        StringBuilder builder = new StringBuilder();
        int nPartMaps = this.size();
        for (int n = 0; n < nPartMaps; ++n) {
            JDFAttributeMap amParts = this.get(n);
            builder.append("[").append(n).append("]").append(amParts.showKeys(sepEntry));
            if (n + 1 >= nPartMaps) continue;
            builder.append(sepMap);
        }
        return builder.toString();
    }

    public List<String> getPartValues(String strKey, boolean bUnique) {
        StringArray array = new StringArray();
        for (JDFAttributeMap myMap : this) {
            String strValue = myMap.get(strKey);
            if (strValue == null) continue;
            array.add(strValue);
        }
        if (bUnique) {
            array.unify();
        }
        return array;
    }

    public JDFAttributeMapArray getAndMaps(JDFAttributeMap map) {
        if (JDFAttributeMap.isEmpty(map)) {
            return new JDFAttributeMapArray(this);
        }
        JDFAttributeMapArray newMap = new JDFAttributeMapArray();
        for (JDFAttributeMap map0 : this) {
            if (map0 == null || (map0 = map0.getAndMap(map)) == null) continue;
            newMap.add(map0);
        }
        if (!newMap.isEmpty()) {
            newMap.unify();
        } else {
            newMap = null;
        }
        return newMap;
    }

    public JDFAttributeMapArray getOrMaps(JDFAttributeMap map) {
        if (JDFAttributeMap.isEmpty(map)) {
            return new JDFAttributeMapArray(this);
        }
        JDFAttributeMapArray newMap = new JDFAttributeMapArray();
        for (JDFAttributeMap map0 : this) {
            if ((map0 = map0.getOrMap(map)) == null) continue;
            newMap.add(map0);
        }
        if (newMap.isEmpty()) {
            newMap = null;
        } else {
            newMap.unify();
        }
        return newMap;
    }

    public JDFAttributeMapArray getOrMaps(JDFAttributeMapArray vMap) {
        if (JDFAttributeMapArray.isEmpty(vMap)) {
            return new JDFAttributeMapArray(this);
        }
        JDFAttributeMapArray newMap = new JDFAttributeMapArray();
        for (JDFAttributeMap map : vMap) {
            JDFAttributeMapArray maps0 = this.getOrMaps(map);
            if (maps0 == null) continue;
            newMap.addAll(maps0);
        }
        if (newMap.isEmpty()) {
            newMap = null;
        } else {
            newMap.unify();
        }
        return newMap;
    }

    public boolean containsKey(String key) {
        for (JDFAttributeMap map : this) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public int maxSize() {
        int mx = 0;
        for (JDFAttributeMap map : this) {
            if (map == null) continue;
            mx = Math.max(mx, map.size());
        }
        return mx;
    }

    public int minSize() {
        JDFAttributeMap map;
        int minSize = this.isEmpty() ? 0 : Integer.MAX_VALUE;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && ((map = (JDFAttributeMap)iterator.next()) == null || (minSize = Math.min(minSize, map.size())) != 0)) {
        }
        return minSize;
    }

    @Override
    public JDFAttributeMap get(int i) {
        int ii = ContainerUtil.index(this, i);
        return ii >= 0 ? (JDFAttributeMap)super.get(ii) : null;
    }

    public JDFAttributeMapArray removeKeys(Collection<String> set) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.get(i).removeKeys(set);
            if (!this.get(i).isEmpty()) continue;
            this.remove(i);
        }
        this.unify();
        return this;
    }

    public JDFAttributeMapArray removeKey(String key) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.get(i).remove(key);
            if (!this.get(i).isEmpty()) continue;
            this.remove(i);
        }
        this.unify();
        return this;
    }

    public void reduceMap(Collection<String> keySet) {
        JDFAttributeMapArray v = new JDFAttributeMapArray();
        for (JDFAttributeMap map : this) {
            boolean bNullMap = map.isEmpty();
            map.reduceMap(keySet);
            if (!bNullMap && map.isEmpty()) continue;
            v.add(map);
        }
        v.unify();
        this.clear();
        this.addAll(v);
    }

    public StringArray getKeys() {
        StringArray v = new StringArray();
        for (JDFAttributeMap map : this) {
            v.addAll(map.getKeyList());
        }
        v.unify();
        return v;
    }

    public JDFAttributeMap getCommonMap() {
        JDFAttributeMap nm = new JDFAttributeMap();
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return new JDFAttributeMap(this.get(0));
        }
        JDFAttributeMap m0 = this.get(0);
        StringArray keyList = m0.getKeyList();
        for (String key : keyList) {
            String target = m0.get(key);
            if (target == null) continue;
            for (JDFAttributeMap m : this) {
                String val = m.get(key);
                if (target.equals(val)) continue;
                target = null;
                break;
            }
            if (target == null) continue;
            nm.put(key, target);
        }
        return nm;
    }

    public void unify() {
        ContainerUtil.unify(this);
    }

    public void appendUnique(JDFAttributeMap map) {
        ContainerUtil.appendUnique(this, map);
    }

    public void appendUnique(JDFAttributeMapArray maps) {
        ContainerUtil.appendUnique(this, maps);
    }

    public JDFAttributeMapArray overlapMap(JDFAttributeMap map) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i).overlapMap(map)) continue;
            this.remove(i);
        }
        return this;
    }

    public JDFAttributeMapArray getOverlapMaps(JDFAttributeMap map) {
        JDFAttributeMapArray newV = new JDFAttributeMapArray();
        for (JDFAttributeMap m : this) {
            if (!m.overlapMap(map)) continue;
            newV.add(m);
        }
        return newV;
    }

    public JDFAttributeMapArray getMatchingMaps(String key, String regExp, boolean ignoreCase) {
        JDFAttributeMapArray newV = new JDFAttributeMapArray();
        for (JDFAttributeMap m : this) {
            if (!m.matches(key, regExp, ignoreCase)) continue;
            newV.add(m);
        }
        return newV;
    }

    public JDFAttributeMapArray overlapMap(JDFAttributeMapArray vMap) {
        if (vMap != null) {
            Set<JDFAttributeMap> set = ContainerUtil.toHashSet(vMap);
            for (int i = this.size() - 1; i >= 0; --i) {
                JDFAttributeMap attributeMap = this.get(i);
                if (set.contains(attributeMap) || attributeMap.overlapsMap(vMap)) continue;
                this.remove(i);
            }
        }
        return this;
    }

    public boolean overlapsMap(JDFAttributeMap map) {
        for (JDFAttributeMap m : this) {
            if (!m.overlapMap(map)) continue;
            return true;
        }
        return false;
    }

    public boolean subMap(JDFAttributeMap map) {
        for (JDFAttributeMap m : this) {
            if (!m.subMap(map)) continue;
            return true;
        }
        return false;
    }

    public boolean subMap(JDFAttributeMapArray vMap) {
        if (JDFAttributeMapArray.isEmpty(vMap)) {
            return true;
        }
        for (JDFAttributeMap map : vMap) {
            if (!this.subMap(map)) continue;
            return true;
        }
        return false;
    }

    public boolean overlapsMap(JDFAttributeMapArray vMap) {
        if (JDFAttributeMapArray.isEmpty(vMap)) {
            return true;
        }
        for (JDFAttributeMap m : vMap) {
            if (!this.overlapsMap(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof JDFAttributeMapArray)) {
            return false;
        }
        int size = this.size();
        if (size != ((JDFAttributeMapArray)other).size()) {
            return false;
        }
        HashSet<JDFAttributeMap> sOther = new HashSet<JDFAttributeMap>((JDFAttributeMapArray)other);
        for (JDFAttributeMap map : this) {
            if (sOther.remove(map)) continue;
            return false;
        }
        return true;
    }

    public void put(Object key, Object value) {
        String s1 = key instanceof String ? (String)key : (key instanceof ValuedEnum ? ((ValuedEnum)key).getName() : null);
        String s2 = value instanceof String ? (String)value : (value instanceof ValuedEnum ? ((ValuedEnum)value).getName() : null);
        if (s1 == null || s2 == null) {
            throw new IllegalArgumentException("wrong key and value types in put: " + key + " " + value);
        }
        this.put(s1, s2);
    }

    @Override
    public int hashCode() {
        return HashUtil.hashCode(42, this);
    }

    public void put(String key, String value) {
        if (this.isEmpty()) {
            this.add(new JDFAttributeMap(key, value));
        } else {
            for (JDFAttributeMap m : this) {
                m.put(key, value);
            }
        }
    }

    @Override
    public JDFAttributeMapArray clone() {
        return new JDFAttributeMapArray(this);
    }

    public void removeMaps(JDFAttributeMap map) {
        if (JDFAttributeMap.isEmpty(map)) {
            this.clear();
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                JDFAttributeMap map0 = this.get(i);
                if (map0 == null || !map0.subMap(map)) continue;
                this.remove(i);
            }
        }
    }

    public void put(JDFAttributeMap commonMap) {
        if (commonMap != null) {
            for (Map.Entry entry : commonMap.entrySet()) {
                this.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

