/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.AuditHelper;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.MessageHelper;
import org.cip4.jdflib.extensions.MessageResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class MessagePoolHelper
extends BaseXJDFHelper {
    public MessagePoolHelper(KElement pool) {
        super(pool);
    }

    public MessageResourceHelper getMessageResourceHelper(SetHelper sh) {
        String name;
        String string = name = sh == null ? null : sh.getName();
        if (name == null) {
            return null;
        }
        VElement v = this.theElement.getXPathElementVector("*/ResourceInfo/ResourceSet[@Name=\"" + name + "\"]", 0);
        if (v != null) {
            for (KElement e : v) {
                SetHelper thisHelper = new SetHelper(e);
                if (!sh.matches(thisHelper)) continue;
                KElement message = e.getParentNode_KElement().getParentNode_KElement();
                return this.newMessageResourceHelper(message);
            }
        }
        return null;
    }

    MessageResourceHelper newMessageResourceHelper(KElement message) {
        return new MessageResourceHelper(message);
    }

    public MessageResourceHelper getCreateMessageResourceHelper(SetHelper sh) {
        String name;
        String string = name = sh == null ? null : sh.getName();
        if (name == null) {
            return null;
        }
        MessageResourceHelper ah = this.getMessageResourceHelper(sh);
        if (ah == null) {
            ah = new MessageResourceHelper(this.theElement.appendElement("AuditResource"));
            KElement set = ah.getRoot().appendElement("ResourceInfo").appendElement("ResourceSet");
            SetHelper shNew = new SetHelper(set);
            shNew.setName(name);
            shNew.setUsage(sh.getUsage());
            shNew.setProcessUsage(sh.getProcessUsage());
        }
        ah.cleanUp();
        return ah;
    }

    @Override
    public void cleanUp() {
        List<MessageHelper> vA = this.getMessageHelpers();
        if (vA != null) {
            for (MessageHelper ah : vA) {
                ah.cleanUp();
            }
        }
        super.cleanUp();
    }

    @Deprecated
    public List<MessageHelper> getAuditHelpers() {
        return this.getMessageHelpers();
    }

    public List<MessageHelper> getMessageHelpers() {
        ArrayList<MessageHelper> vA = new ArrayList<MessageHelper>();
        VElement v = this.theElement.getChildElementVector(null, null);
        for (KElement e : v) {
            if ("Header".equals(e.getLocalName())) continue;
            ContainerUtil.add(vA, this.getMessageHelper(e));
        }
        return vA;
    }

    public MessageHelper getMessageHelper(KElement e) {
        if (e == null) {
            return null;
        }
        String name = e.getLocalName();
        if ("AuditResource".equals(name) || "SignalResource".equals(name) || "ResponseResource".equals(name)) {
            return this.newMessageResourceHelper(e);
        }
        if (name.startsWith("Audit")) {
            return new AuditHelper(e);
        }
        return new MessageHelper(e);
    }

    public MessageHelper getMessageHelper(String type, int i) {
        if (StringUtil.isEmpty(type)) {
            return this.getMessageHelper(i);
        }
        List<MessageHelper> messageHelpers = this.getMessageHelpers();
        if (i < 0) {
            Collections.reverse(messageHelpers);
            i = -1 - i;
        }
        for (MessageHelper mh : messageHelpers) {
            if (!type.equals(mh.getType()) || i < 0 || i-- != 0) continue;
            return mh;
        }
        return null;
    }

    public MessageHelper getMessageHelper(int i) {
        List<MessageHelper> v = this.getMessageHelpers();
        if (v == null) {
            return null;
        }
        if (i < 0) {
            i += v.size();
        }
        if (i < 0 || i >= v.size()) {
            return null;
        }
        return v.get(i);
    }

    public MessageHelper appendMessage(String elementName) {
        if (StringUtil.isEmpty(elementName)) {
            log.error((Object)"Cannot append null element");
            return null;
        }
        KElement e = this.theElement.appendElement(elementName);
        MessageHelper messageHelper = this.getMessageHelper(e);
        messageHelper.cleanUp();
        return messageHelper;
    }
}

