/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.extensions.MessageHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.XJMFHelper;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueueSubmissionParams;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;

public class XJDFZipWriter
implements IStreamWriter {
    Log log;
    private XJMFHelper xjmf = null;
    private final Vector<XJDFHelper> vxjdf = new Vector();
    private final Map<String, InputStream> auxMap = new HashMap<String, InputStream>();

    public XJDFZipWriter() {
        this.log = LogFactory.getLog(this.getClass());
    }

    public void setXjmf(XJMFHelper xjmf) {
        this.xjmf = xjmf;
    }

    public void addXJDF(XJDFHelper xjdf) {
        this.vxjdf.add(xjdf);
    }

    public void addAux(String path, InputStream inStream) {
        if (inStream != null && !StringUtil.isEmpty(path)) {
            this.auxMap.put(path, inStream);
        }
    }

    void writeAux(ZipOutputStream zos) {
        for (String path : this.auxMap.keySet()) {
            this.writeAux(zos, path);
        }
    }

    void writeXJMF(ZipOutputStream zos) {
        this.ensureXJMF();
        try {
            ZipEntry ze = new ZipEntry("root.xjmf");
            zos.putNextEntry(ze);
            this.xjmf.writeToStream(zos);
            zos.closeEntry();
        }
        catch (Exception x) {
            this.log.error((Object)"oops: ", (Throwable)x);
        }
    }

    void writeXJDF(ZipOutputStream zos, XJDFHelper h, int i) {
        try {
            ZipEntry ze = new ZipEntry(this.getXJDFPath(i));
            zos.putNextEntry(ze);
            h.writeToStream(zos);
            zos.closeEntry();
        }
        catch (Exception x) {
            this.log.error((Object)"oops: ", (Throwable)x);
        }
    }

    void writeAux(ZipOutputStream zos, String path) {
        try {
            ZipEntry ze = new ZipEntry(path);
            zos.putNextEntry(ze);
            IOUtils.copy((InputStream)this.auxMap.get(path), (OutputStream)zos);
            zos.closeEntry();
        }
        catch (Exception x) {
            this.log.error((Object)"oops: ", (Throwable)x);
        }
    }

    void writeXJDFs(ZipOutputStream zos) {
        int i = 0;
        for (XJDFHelper h : this.vxjdf) {
            this.writeXJDF(zos, h, i++);
        }
    }

    XJMFHelper ensureXJMF() {
        if (this.xjmf == null) {
            this.xjmf = new XJMFHelper();
            MessageHelper mh = this.xjmf.appendMessage(JDFMessage.EnumFamily.Command, JDFMessage.EnumType.SubmitQueueEntry);
            JDFQueueSubmissionParams qsp = (JDFQueueSubmissionParams)mh.appendElement("QueueSubmissionParams");
            if (this.vxjdf.size() == 1) {
                qsp.setURL(this.getXJDFPath(0));
            } else if (this.vxjdf.size() > 1) {
                qsp.setURL("xjdf");
            }
        }
        return this.xjmf;
    }

    protected String getXJDFPath(int i) {
        if (i >= 0 && i < this.vxjdf.size()) {
            XJDFHelper xjdfHelper = this.vxjdf.get(i);
            String jobPartID = xjdfHelper.getJobPartID();
            jobPartID = StringUtil.isEmpty(jobPartID) ? new NumberFormatter().formatInt(i, 2) : new NumberFormatter().formatInt(i, 2) + "." + jobPartID;
            return "xjdf/" + xjdfHelper.getJobID() + "." + jobPartID + ".xjdf";
        }
        return null;
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        this.writeXJMF(zos);
        this.writeXJDFs(zos);
        this.writeAux(zos);
        zos.close();
        StreamUtil.close(os);
    }

    public String toString() {
        return "XJDFZipWriter [" + (this.xjmf != null ? "xjmf=" + this.xjmf + ", " : "") + (this.vxjdf != null ? "vxjdf=" + this.vxjdf + ", " : "") + (this.auxMap != null ? "auxMap=" + this.auxMap : "") + "]";
    }
}

