/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXJDFResource;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFPageData;

public class WalkContentResource
extends WalkXJDFResource {
    @Override
    protected String getJDFResName(SetHelper sh) {
        return "PageList";
    }

    @Override
    protected KElement createPartition(JDFResource jdfRes, JDFAttributeMap partMap, JDFNode theNode) {
        KElement pd;
        if (partMap == null || partMap.size() > 0) {
            return super.createPartition(jdfRes, partMap, theNode);
        }
        JDFPageList pageList = (JDFPageList)jdfRes;
        String pages = partMap.getNonEmpty("PageNumber");
        KElement kElement = pd = pages == null ? null : pageList.getChildWithAttribute("PageData", "PageIndex", null, pages, 0, true);
        if (pd != null) {
            return null;
        }
        JDFPageData rPageData = pageList.appendPageData();
        rPageData.setAttribute("PageIndex", pages);
        JDFResourceLink rll = theNode.getLink((JDFResource)pageList, null);
        if (rll != null) {
            rll.removeChildren("Part", null, null);
        }
        pageList.removeFromAttribute("PartIDKeys", "PageNumber", null, " ", -1);
        return rPageData;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return ResourceHelper.isAsset(toCheck, "Content");
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        KElement rPart = super.walk(e, trackElem);
        if (rPart != null) {
            rPart.removeAttribute("Status");
        }
        return rPart;
    }

    @Override
    JDFAttributeMap getPartMap(JDFPart part) {
        JDFAttributeMap partMap = super.getPartMap(part);
        if (partMap != null) {
            partMap.remove("PageNumber");
        }
        return partMap;
    }
}

