/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.auto.JDFAutoDigitalPrintingParams;
import org.cip4.jdflib.auto.JDFAutoInterpretingParams;
import org.cip4.jdflib.auto.JDFAutoLayoutPreparationParams;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.BaseGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFInterpretingParams;
import org.cip4.jdflib.resource.JDFLayoutPreparationParams;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFDigitalPrintingParams;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.resource.process.prepress.JDFRenderingParams;

public class ODPGoldenTicket
extends BaseGoldenTicket {
    @Override
    protected void fillCatMaps() {
        super.fillCatMaps();
        this.catMap.put("DigitalPrinting", new VString("LayoutPreparation Imposition Interpreting Rendering DigitalPrinting", null));
        this.setCategory("DigitalPrinting");
    }

    public ODPGoldenTicket(int _icsLevel, JDFElement.EnumVersion version) {
        super(0, version);
        this.icsLevel = _icsLevel;
        this.paperProductID = null;
        this.vParts = null;
    }

    @Override
    public void init() {
        String icsTag = "ODP_L" + this.icsLevel + "-" + this.theVersion.getName();
        this.theNode.appendAttribute("ICSVersions", icsTag, null, " ", true);
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("ODP Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        this.vParts = null;
        super.init();
        this.setActivePart(this.vParts, true);
        this.initDocumentRunList();
        this.initOutputComponent();
        this.initInterpretingParams();
        this.initRenderingParams();
        JDFMedia m = this.initPaperMedia();
        this.initDigitalPrintingParams(m);
        this.initLayoutPrep();
    }

    private JDFLayoutPreparationParams initLayoutPrep() {
        JDFLayoutPreparationParams layPP = (JDFLayoutPreparationParams)this.theNode.getCreateResource("LayoutPreparationParams", JDFResourceLink.EnumUsage.Input, 0);
        layPP.setSides(JDFAutoLayoutPreparationParams.EnumSides.TwoSidedFlipY);
        return layPP;
    }

    private JDFInterpretingParams initInterpretingParams() {
        JDFInterpretingParams intParams = (JDFInterpretingParams)this.theNode.getCreateResource("InterpretingParams", JDFResourceLink.EnumUsage.Input, 0);
        intParams.setPrintQuality(JDFAutoInterpretingParams.EnumPrintQuality.Normal);
        return intParams;
    }

    private JDFRenderingParams initRenderingParams() {
        JDFRenderingParams rendParams = (JDFRenderingParams)this.theNode.getCreateResource("RenderingParams", JDFResourceLink.EnumUsage.Input, 0);
        rendParams.appendObjectResolution().setResolution(new JDFXYPair(600, 600));
        return rendParams;
    }

    private JDFDigitalPrintingParams initDigitalPrintingParams(JDFMedia m) {
        JDFDigitalPrintingParams digiParams = (JDFDigitalPrintingParams)this.theNode.getCreateResource("DigitalPrintingParams", JDFResourceLink.EnumUsage.Input, 0);
        digiParams.setSides(JDFAutoDigitalPrintingParams.EnumSides.TwoSided);
        if (m != null) {
            digiParams.refElement(m);
        }
        return digiParams;
    }

    @Override
    public void execute(VJDFAttributeMap parts, boolean outputAvailable, boolean bFirst) {
        this.setActivePart(null, bFirst);
        super.execute(null, outputAvailable, bFirst);
    }

    @Override
    protected JDFRunList initDocumentRunList() {
        JDFRunList rl = super.initDocumentRunList();
        this.theNode.getLink((JDFResource)rl, JDFResourceLink.EnumUsage.Input).setProcessUsage((JDFNode.EnumProcessUsage)null);
        return rl;
    }

    @Override
    protected JDFMedia initPaperMedia() {
        super.initPaperMedia();
        this.paperMedia.removeAttribute("Weight");
        this.paperMedia.removeAttribute("Thickness");
        this.paperMedia.setDimensionInch(new JDFXYPair(8.5, 11.0));
        return this.paperMedia;
    }
}

