/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.IOException;
import java.io.InputStream;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.StringUtil;

public class SkipInputStream
extends ByteArrayIOStream.ByteArrayIOInputStream {
    long deltaPos;
    private final int searchSize;
    private long maxPreread;
    private final boolean ignoreCase;
    private final String searchTag;
    private boolean found = false;
    int myMark = 0;

    public SkipInputStream(String searchTag, InputStream stream2, boolean ignorecase) {
        this(searchTag, stream2, ignorecase, -1L);
    }

    public SkipInputStream(String searchTag, InputStream stream2, boolean ignorecase, long maxPreRead) {
        super(stream2);
        this.searchTag = searchTag;
        this.ignoreCase = ignorecase;
        this.maxPreread = maxPreRead;
        int n = this.searchSize = searchTag == null ? 0 : searchTag.length();
        if (this.searchSize == 0) {
            this.found = true;
            return;
        }
        this.mark(this.searchSize + 10);
        try {
            if (maxPreRead != 0L) {
                this.readToTag();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean readToTag() throws IOException {
        if (StringUtil.getNonEmpty(this.searchTag) == null) {
            return false;
        }
        byte[] bytes = this.searchTag.getBytes();
        byte[] lowerBytes = this.searchTag.toLowerCase().getBytes();
        int tagPos = 0;
        int nSkipped = 0;
        while ((long)nSkipped++ != this.maxPreread) {
            int c;
            if (tagPos == 0) {
                super.mark(this.searchSize + 10);
            }
            if ((c = super.read()) == -1) break;
            if (c == bytes[tagPos] || this.ignoreCase && Character.toLowerCase(c) == lowerBytes[tagPos]) {
                if (++tagPos < this.searchSize) continue;
                super.reset();
                this.deltaPos = 0L;
                this.found = true;
                return this.found;
            }
            if (tagPos != 0) {
                super.reset();
                super.read();
            }
            tagPos = 0;
        }
        return this.found;
    }

    @Override
    public synchronized int read() {
        ++this.deltaPos;
        return this.found ? super.read() : -1;
    }

    public boolean readToNextTag() {
        this.maxPreread = -1L;
        if (StringUtil.getNonEmpty(this.searchTag) == null) {
            return false;
        }
        try {
            for (long i = this.deltaPos; i < (long)this.searchTag.length(); ++i) {
                if (super.read() != -1) continue;
                return false;
            }
            this.found = false;
            this.readToTag();
        }
        catch (IOException e) {
            return false;
        }
        return this.found;
    }

    @Override
    public String toString() {
        return "SkipInputStream " + this.found + " " + this.searchSize + " " + super.toString();
    }

    @Override
    public synchronized void reset() {
        this.mark = this.myMark;
        super.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.myMark = this.pos;
    }
}

